/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.configuration;

import com.microsoft.identity.common.java.logging.Logger;
import lombok.NonNull;

public class LibraryConfiguration {
    private static final String TAG = LibraryConfiguration.class.getSimpleName();
    private static LibraryConfiguration sInstance = null;
    private boolean authorizationInCurrentTask;
    private boolean refreshInEnabled;

    public static synchronized LibraryConfiguration getInstance() {
        if (sInstance == null) {
            sInstance = LibraryConfiguration.createDefaultInstance();
        }
        return sInstance;
    }

    public static synchronized void intializeLibraryConfiguration(@NonNull LibraryConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (sInstance == null) {
            sInstance = config;
        } else {
            Logger.warn(TAG, "MsalConfiguration was already initialized");
        }
    }

    private static synchronized LibraryConfiguration createDefaultInstance() {
        return LibraryConfiguration.builder().authorizationInCurrentTask(false).refreshInEnabled(false).build();
    }

    LibraryConfiguration(boolean authorizationInCurrentTask, boolean refreshInEnabled) {
        this.authorizationInCurrentTask = authorizationInCurrentTask;
        this.refreshInEnabled = refreshInEnabled;
    }

    public static LibraryConfigurationBuilder builder() {
        return new LibraryConfigurationBuilder();
    }

    public boolean isAuthorizationInCurrentTask() {
        return this.authorizationInCurrentTask;
    }

    public boolean isRefreshInEnabled() {
        return this.refreshInEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LibraryConfiguration)) {
            return false;
        }
        LibraryConfiguration other = (LibraryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthorizationInCurrentTask() != other.isAuthorizationInCurrentTask()) {
            return false;
        }
        return this.isRefreshInEnabled() == other.isRefreshInEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LibraryConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthorizationInCurrentTask() ? 79 : 97);
        result = result * 59 + (this.isRefreshInEnabled() ? 79 : 97);
        return result;
    }

    public static class LibraryConfigurationBuilder {
        private boolean authorizationInCurrentTask;
        private boolean refreshInEnabled;

        LibraryConfigurationBuilder() {
        }

        public LibraryConfigurationBuilder authorizationInCurrentTask(boolean authorizationInCurrentTask) {
            this.authorizationInCurrentTask = authorizationInCurrentTask;
            return this;
        }

        public LibraryConfigurationBuilder refreshInEnabled(boolean refreshInEnabled) {
            this.refreshInEnabled = refreshInEnabled;
            return this;
        }

        public LibraryConfiguration build() {
            return new LibraryConfiguration(this.authorizationInCurrentTask, this.refreshInEnabled);
        }

        public String toString() {
            return "LibraryConfiguration.LibraryConfigurationBuilder(authorizationInCurrentTask=" + this.authorizationInCurrentTask + ", refreshInEnabled=" + this.refreshInEnabled + ")";
        }
    }
}

