/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands.parameters;

import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.util.StringUtil;

public class RopcTokenCommandParameters
extends TokenCommandParameters {
    private final String mUsername;
    private final String mPassword;

    @Override
    public void validate() throws ArgumentException {
        if (StringUtil.isNullOrEmpty(this.mUsername)) {
            throw new ArgumentException("acquireTokenWithPassword", "mUsername", "Username is not set");
        }
        if (StringUtil.isNullOrEmpty(this.mPassword)) {
            throw new ArgumentException("acquireTokenWithPassword", "mPassword", "Password is not set");
        }
        super.validate();
    }

    protected RopcTokenCommandParameters(RopcTokenCommandParametersBuilder<?, ?> b) {
        super((TokenCommandParameters.TokenCommandParametersBuilder<?, ?>)b);
        this.mUsername = ((RopcTokenCommandParametersBuilder)b).username;
        this.mPassword = ((RopcTokenCommandParametersBuilder)b).password;
    }

    public static RopcTokenCommandParametersBuilder<?, ?> builder() {
        return new RopcTokenCommandParametersBuilderImpl();
    }

    @Override
    public RopcTokenCommandParametersBuilder<?, ?> toBuilder() {
        return new RopcTokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RopcTokenCommandParameters)) {
            return false;
        }
        RopcTokenCommandParameters other = (RopcTokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mUsername = this.getUsername();
        String other$mUsername = other.getUsername();
        if (this$mUsername == null ? other$mUsername != null : !this$mUsername.equals(other$mUsername)) {
            return false;
        }
        String this$mPassword = this.getPassword();
        String other$mPassword = other.getPassword();
        return !(this$mPassword == null ? other$mPassword != null : !this$mPassword.equals(other$mPassword));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RopcTokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mUsername = this.getUsername();
        result = result * 59 + ($mUsername == null ? 43 : $mUsername.hashCode());
        String $mPassword = this.getPassword();
        result = result * 59 + ($mPassword == null ? 43 : $mPassword.hashCode());
        return result;
    }

    private static final class RopcTokenCommandParametersBuilderImpl
    extends RopcTokenCommandParametersBuilder<RopcTokenCommandParameters, RopcTokenCommandParametersBuilderImpl> {
        private RopcTokenCommandParametersBuilderImpl() {
        }

        @Override
        protected RopcTokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public RopcTokenCommandParameters build() {
            return new RopcTokenCommandParameters(this);
        }
    }

    public static abstract class RopcTokenCommandParametersBuilder<C extends RopcTokenCommandParameters, B extends RopcTokenCommandParametersBuilder<C, B>>
    extends TokenCommandParameters.TokenCommandParametersBuilder<C, B> {
        private String username;
        private String password;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RopcTokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RopcTokenCommandParameters instance, RopcTokenCommandParametersBuilder<?, ?> b) {
            b.username(instance.mUsername);
            b.password(instance.mPassword);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RopcTokenCommandParameters.RopcTokenCommandParametersBuilder(super=" + super.toString() + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

