/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands.parameters;

import com.microsoft.identity.common.java.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.parameters.RopcTokenCommandParameters;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.util.StringUtil;

public class BrokerRopcTokenCommandParameters
extends RopcTokenCommandParameters {
    private final String callerPackageName;
    private final int callerUid;
    private final String callerAppVersion;
    private final String brokerVersion;
    private final String negotiatedBrokerProtocolVersion;

    @Override
    public void validate() throws ArgumentException {
        if (this.callerUid == 0) {
            throw new ArgumentException("acquireTokenWithPassword", "mCallerUId", "Caller Uid is not set");
        }
        if (StringUtil.isNullOrEmpty(this.callerPackageName)) {
            throw new ArgumentException("acquireTokenWithPassword", "mCallerPackageName", "Caller package name is not set");
        }
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireTokenWithPassword", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireTokenWithPassword", "mScopes", "Scope or resource is not set");
        }
        if (StringUtil.isNullOrEmpty(this.getClientId())) {
            throw new ArgumentException("acquireTokenWithPassword", "mClientId", "Client Id is not set");
        }
        if (!(this.getOAuth2TokenCache() instanceof BrokerOAuth2TokenCache)) {
            throw new ArgumentException("acquireTokenSilent", "mOauth2TokenCache", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
        }
    }

    protected BrokerRopcTokenCommandParameters(BrokerRopcTokenCommandParametersBuilder<?, ?> b) {
        super((RopcTokenCommandParameters.RopcTokenCommandParametersBuilder<?, ?>)b);
        this.callerPackageName = ((BrokerRopcTokenCommandParametersBuilder)b).callerPackageName;
        this.callerUid = ((BrokerRopcTokenCommandParametersBuilder)b).callerUid;
        this.callerAppVersion = ((BrokerRopcTokenCommandParametersBuilder)b).callerAppVersion;
        this.brokerVersion = ((BrokerRopcTokenCommandParametersBuilder)b).brokerVersion;
        this.negotiatedBrokerProtocolVersion = ((BrokerRopcTokenCommandParametersBuilder)b).negotiatedBrokerProtocolVersion;
    }

    public static BrokerRopcTokenCommandParametersBuilder<?, ?> builder() {
        return new BrokerRopcTokenCommandParametersBuilderImpl();
    }

    @Override
    public BrokerRopcTokenCommandParametersBuilder<?, ?> toBuilder() {
        return new BrokerRopcTokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public String getCallerPackageName() {
        return this.callerPackageName;
    }

    public int getCallerUid() {
        return this.callerUid;
    }

    public String getCallerAppVersion() {
        return this.callerAppVersion;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public String getNegotiatedBrokerProtocolVersion() {
        return this.negotiatedBrokerProtocolVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerRopcTokenCommandParameters)) {
            return false;
        }
        BrokerRopcTokenCommandParameters other = (BrokerRopcTokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCallerUid() != other.getCallerUid()) {
            return false;
        }
        String this$callerPackageName = this.getCallerPackageName();
        String other$callerPackageName = other.getCallerPackageName();
        if (this$callerPackageName == null ? other$callerPackageName != null : !this$callerPackageName.equals(other$callerPackageName)) {
            return false;
        }
        String this$callerAppVersion = this.getCallerAppVersion();
        String other$callerAppVersion = other.getCallerAppVersion();
        if (this$callerAppVersion == null ? other$callerAppVersion != null : !this$callerAppVersion.equals(other$callerAppVersion)) {
            return false;
        }
        String this$brokerVersion = this.getBrokerVersion();
        String other$brokerVersion = other.getBrokerVersion();
        if (this$brokerVersion == null ? other$brokerVersion != null : !this$brokerVersion.equals(other$brokerVersion)) {
            return false;
        }
        String this$negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        String other$negotiatedBrokerProtocolVersion = other.getNegotiatedBrokerProtocolVersion();
        return !(this$negotiatedBrokerProtocolVersion == null ? other$negotiatedBrokerProtocolVersion != null : !this$negotiatedBrokerProtocolVersion.equals(other$negotiatedBrokerProtocolVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerRopcTokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCallerUid();
        String $callerPackageName = this.getCallerPackageName();
        result = result * 59 + ($callerPackageName == null ? 43 : $callerPackageName.hashCode());
        String $callerAppVersion = this.getCallerAppVersion();
        result = result * 59 + ($callerAppVersion == null ? 43 : $callerAppVersion.hashCode());
        String $brokerVersion = this.getBrokerVersion();
        result = result * 59 + ($brokerVersion == null ? 43 : $brokerVersion.hashCode());
        String $negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        result = result * 59 + ($negotiatedBrokerProtocolVersion == null ? 43 : $negotiatedBrokerProtocolVersion.hashCode());
        return result;
    }

    private static final class BrokerRopcTokenCommandParametersBuilderImpl
    extends BrokerRopcTokenCommandParametersBuilder<BrokerRopcTokenCommandParameters, BrokerRopcTokenCommandParametersBuilderImpl> {
        private BrokerRopcTokenCommandParametersBuilderImpl() {
        }

        @Override
        protected BrokerRopcTokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public BrokerRopcTokenCommandParameters build() {
            return new BrokerRopcTokenCommandParameters(this);
        }
    }

    public static abstract class BrokerRopcTokenCommandParametersBuilder<C extends BrokerRopcTokenCommandParameters, B extends BrokerRopcTokenCommandParametersBuilder<C, B>>
    extends RopcTokenCommandParameters.RopcTokenCommandParametersBuilder<C, B> {
        private String callerPackageName;
        private int callerUid;
        private String callerAppVersion;
        private String brokerVersion;
        private String negotiatedBrokerProtocolVersion;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrokerRopcTokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrokerRopcTokenCommandParameters instance, BrokerRopcTokenCommandParametersBuilder<?, ?> b) {
            b.callerPackageName(instance.callerPackageName);
            b.callerUid(instance.callerUid);
            b.callerAppVersion(instance.callerAppVersion);
            b.brokerVersion(instance.brokerVersion);
            b.negotiatedBrokerProtocolVersion(instance.negotiatedBrokerProtocolVersion);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public B callerPackageName(String callerPackageName) {
            this.callerPackageName = callerPackageName;
            return (B)this.self();
        }

        public B callerUid(int callerUid) {
            this.callerUid = callerUid;
            return (B)this.self();
        }

        public B callerAppVersion(String callerAppVersion) {
            this.callerAppVersion = callerAppVersion;
            return (B)this.self();
        }

        public B brokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return (B)this.self();
        }

        public B negotiatedBrokerProtocolVersion(String negotiatedBrokerProtocolVersion) {
            this.negotiatedBrokerProtocolVersion = negotiatedBrokerProtocolVersion;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrokerRopcTokenCommandParameters.BrokerRopcTokenCommandParametersBuilder(super=" + super.toString() + ", callerPackageName=" + this.callerPackageName + ", callerUid=" + this.callerUid + ", callerAppVersion=" + this.callerAppVersion + ", brokerVersion=" + this.brokerVersion + ", negotiatedBrokerProtocolVersion=" + this.negotiatedBrokerProtocolVersion + ")";
        }
    }
}

