/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.cache.AbstractAccountCredentialCache;
import com.microsoft.identity.common.java.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class SharedPreferencesAccountCredentialCacheWithMemoryCache
extends AbstractAccountCredentialCache {
    private static final String TAG = SharedPreferencesAccountCredentialCacheWithMemoryCache.class.getSimpleName();
    private final ICacheKeyValueDelegate mCacheValueDelegate;
    private final Object mCacheLock = new Object();
    private boolean mLoaded = false;
    private Map<String, AccountRecord> mCachedAccountRecordsWithKeys = new HashMap<String, AccountRecord>();
    private Map<String, Credential> mCachedCredentialsWithKeys = new HashMap<String, Credential>();

    public SharedPreferencesAccountCredentialCacheWithMemoryCache(@NonNull ICacheKeyValueDelegate accountCacheValueDelegate, @NonNull INameValueStorage<String> sharedPreferencesFileManager) {
        super(sharedPreferencesFileManager);
        if (accountCacheValueDelegate == null) {
            throw new NullPointerException("accountCacheValueDelegate is marked non-null but is null");
        }
        if (sharedPreferencesFileManager == null) {
            throw new NullPointerException("sharedPreferencesFileManager is marked non-null but is null");
        }
        Logger.verbose(TAG, "Init: " + TAG);
        this.mCacheValueDelegate = accountCacheValueDelegate;
        new Thread(() -> this.load()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        String methodTag = TAG + ":load";
        Object object = this.mCacheLock;
        synchronized (object) {
            try {
                this.mCachedAccountRecordsWithKeys = this.loadAccountsWithKeys();
                Logger.info(methodTag, "Loaded " + this.mCachedAccountRecordsWithKeys.size() + " AccountRecords");
                this.mCachedCredentialsWithKeys = this.loadCredentialsWithKeys();
                Logger.info(methodTag, "Loaded " + this.mCachedCredentialsWithKeys.size() + " Credentials");
            }
            catch (Throwable t) {
                Logger.error(methodTag, "Failed to load initial accounts or credentials from SharedPreferences", t);
            }
            finally {
                this.mLoaded = true;
                this.mCacheLock.notifyAll();
            }
        }
    }

    private void waitForInitialLoad() {
        String methodTag = TAG + ":waitForInitialLoad";
        while (!this.mLoaded) {
            try {
                this.mCacheLock.wait();
            }
            catch (InterruptedException e) {
                Logger.error(methodTag, "Caught InterruptedException while waiting", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAccount(@NonNull AccountRecord accountInput) {
        if (accountInput == null) {
            throw new NullPointerException("accountInput is marked non-null but is null");
        }
        String methodTag = TAG + ":saveAccount";
        AccountRecord accountToSave = null;
        try {
            accountToSave = (AccountRecord)accountInput.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.error(methodTag, "Failed to clone AccountRecord", e);
            return;
        }
        Logger.verbose(methodTag, "Saving Account...");
        Logger.verbose(methodTag, "Account type: [" + accountToSave.getClass().getSimpleName() + "]");
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(accountToSave);
        Logger.verbosePII(methodTag, "Generated cache key: [" + cacheKey + "]");
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            AccountRecord existingAccount = this.getAccount(cacheKey);
            if (null != existingAccount) {
                accountToSave.mergeAdditionalFields(existingAccount);
            }
            String cacheValue = this.mCacheValueDelegate.generateCacheValue(accountToSave);
            this.mSharedPreferencesFileManager.put(cacheKey, cacheValue);
            this.mCachedAccountRecordsWithKeys.put(cacheKey, accountToSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCredential(@NonNull Credential credentialInput) {
        if (credentialInput == null) {
            throw new NullPointerException("credentialInput is marked non-null but is null");
        }
        String methodTag = TAG + ":saveCredential";
        Credential credentialToSave = null;
        try {
            credentialToSave = (Credential)credentialInput.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.error(methodTag, "Failed to clone Credential", e);
            return;
        }
        Logger.verbose(methodTag, "Saving credential...");
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(credentialToSave);
        Logger.verbosePII(methodTag, "Generated cache key: [" + cacheKey + "]");
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            Credential existingCredential = this.getCredential(cacheKey);
            if (null != existingCredential) {
                credentialToSave.mergeAdditionalFields(existingCredential);
            }
            String cacheValue = this.mCacheValueDelegate.generateCacheValue(credentialToSave);
            this.mSharedPreferencesFileManager.put(cacheKey, cacheValue);
            this.mCachedCredentialsWithKeys.put(cacheKey, credentialToSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountRecord getAccount(@NonNull String cacheKey) {
        AccountRecord foundValue;
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        String methodTag = TAG + ":getAccount";
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            foundValue = this.mCachedAccountRecordsWithKeys.get(cacheKey);
        }
        try {
            if (foundValue != null) {
                foundValue = (AccountRecord)foundValue.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            Logger.error(methodTag, "Failed to clone AccountRecord", e);
        }
        return foundValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Credential getCredential(@NonNull String cacheKey) {
        Credential foundValue;
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        String methodTag = TAG + ":getCredential";
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            foundValue = this.mCachedCredentialsWithKeys.get(cacheKey);
        }
        try {
            if (foundValue != null) {
                foundValue = (Credential)foundValue.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            Logger.error(methodTag, "Failed to clone Credential", e);
        }
        return foundValue;
    }

    @NonNull
    private Map<String, AccountRecord> loadAccountsWithKeys() {
        String methodTag = TAG + ":loadAccountsWithKeys";
        Logger.verbose(methodTag, "Loading Accounts + keys...");
        Iterator cacheValues = this.mSharedPreferencesFileManager.getAllFilteredByKey(new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return SharedPreferencesAccountCredentialCacheWithMemoryCache.isAccount(value);
            }
        });
        HashMap<String, AccountRecord> accounts = new HashMap<String, AccountRecord>();
        if (cacheValues != null) {
            while (cacheValues.hasNext()) {
                Map.Entry cacheValue = cacheValues.next();
                String cacheKey = cacheValue.getKey();
                AccountRecord account = (AccountRecord)this.mCacheValueDelegate.fromCacheValue(cacheValue.getValue().toString(), AccountRecord.class);
                if (null == account) {
                    Logger.warn(methodTag, SharedPreferencesAccountCredentialCache.ACCOUNT_RECORD_DESERIALIZATION_FAILED);
                    continue;
                }
                if (SharedPreferencesAccountCredentialCache.EMPTY_ACCOUNT.equals(account)) {
                    Logger.warn(methodTag, "The returned Account was uninitialized. Removing...");
                    this.mSharedPreferencesFileManager.remove(cacheKey);
                    continue;
                }
                accounts.put(cacheKey, account);
            }
        }
        Logger.verbose(methodTag, "Returning [" + accounts.size() + "] Accounts w/ keys...");
        return accounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<AccountRecord> getAccounts() {
        String methodTag = TAG + ":getAccounts";
        Logger.verbose(methodTag, "Loading Accounts...(no arg)");
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            ArrayList<AccountRecord> accounts = new ArrayList<AccountRecord>();
            for (AccountRecord record : this.mCachedAccountRecordsWithKeys.values()) {
                try {
                    accounts.add((AccountRecord)record.clone());
                }
                catch (CloneNotSupportedException e) {
                    Logger.error(methodTag, "Failed to clone AccountRecord", e);
                }
            }
            Logger.info(methodTag, "Found [" + accounts.size() + "] Accounts...");
            return accounts;
        }
    }

    @Override
    @NonNull
    public List<AccountRecord> getAccountsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable String realm) {
        String methodTag = TAG + ":getAccountsFilteredBy";
        Logger.verbose(methodTag, "Loading Accounts...");
        List<AccountRecord> allAccounts = this.getAccounts();
        List<AccountRecord> matchingAccounts = this.getAccountsFilteredByInternal(homeAccountId, environment, realm, allAccounts);
        Logger.verbose(methodTag, "Found [" + matchingAccounts.size() + "] matching Accounts...");
        return matchingAccounts;
    }

    @NonNull
    private Map<String, Credential> loadCredentialsWithKeys() {
        String methodTag = TAG + ":getCredentialsWithKeys";
        Logger.verbose(methodTag, "Loading Credentials with keys...");
        HashMap<String, Credential> credentials = new HashMap<String, Credential>();
        Iterator cacheValues = this.mSharedPreferencesFileManager.getAllFilteredByKey(new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return SharedPreferencesAccountCredentialCacheWithMemoryCache.isCredential(value);
            }
        });
        while (cacheValues.hasNext()) {
            Map.Entry cacheValue = cacheValues.next();
            String cacheKey = cacheValue.getKey();
            Class<? extends Credential> clazz = this.credentialClassForType(cacheKey);
            Credential credential = (Credential)this.mCacheValueDelegate.fromCacheValue(cacheValue.getValue().toString(), clazz);
            if (null == credential) {
                Logger.warn(methodTag, SharedPreferencesAccountCredentialCache.CREDENTIAL_DESERIALIZATION_FAILED);
                continue;
            }
            if (AccessTokenRecord.class == clazz && SharedPreferencesAccountCredentialCache.EMPTY_AT.equals(credential) || RefreshTokenRecord.class == clazz && SharedPreferencesAccountCredentialCache.EMPTY_RT.equals(credential) || IdTokenRecord.class == clazz && SharedPreferencesAccountCredentialCache.EMPTY_ID.equals(credential)) {
                Logger.warn(methodTag, "The returned Credential was uninitialized. Removing...");
                this.mSharedPreferencesFileManager.remove(cacheKey);
                continue;
            }
            credentials.put(cacheKey, credential);
        }
        Logger.verbose(methodTag, "Loaded [" + credentials.size() + "] Credentials...");
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<Credential> getCredentials() {
        String methodTag = TAG + ":getCredentials";
        Logger.verbose(methodTag, "Loading Credentials...");
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            for (Credential credential : this.mCachedCredentialsWithKeys.values()) {
                try {
                    credentials.add((Credential)credential.clone());
                }
                catch (CloneNotSupportedException e) {
                    Logger.error(methodTag, "Failed to clone Credential", e);
                }
            }
            return credentials;
        }
    }

    @Override
    @NonNull
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme) {
        String methodTag = TAG + ":getCredentialsFilteredBy";
        Logger.verbose(methodTag, "getCredentialsFilteredBy()");
        List<Credential> allCredentials = this.getCredentials();
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(allCredentials, homeAccountId, environment, credentialType, clientId, applicationIdentifier, mamEnrollmentIdentifier, realm, target, authScheme, null, null);
        Logger.verbose(methodTag, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @NonNull List<Credential> inputCredentials) {
        if (inputCredentials == null) {
            throw new NullPointerException("inputCredentials is marked non-null but is null");
        }
        String methodTag = TAG + ":getCredentialsFilteredBy";
        Logger.verbose(methodTag, "getCredentialsFilteredBy() -- with input list");
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(inputCredentials, homeAccountId, environment, credentialType, clientId, applicationIdentifier, mamEnrollmentIdentifier, realm, target, authScheme, null, null);
        Logger.verbose(methodTag, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    @NonNull
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims) {
        String methodTag = TAG + ":getCredentialsFilteredBy";
        Logger.verbose(methodTag, "getCredentialsFilteredBy()");
        List<Credential> allCredentials = this.getCredentials();
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(allCredentials, homeAccountId, environment, credentialType, clientId, applicationIdentifier, mamEnrollmentIdentifier, realm, target, authScheme, requestedClaims, null);
        Logger.verbose(methodTag, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    @NonNull
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims, @NonNull List<Credential> inputCredentials) {
        if (inputCredentials == null) {
            throw new NullPointerException("inputCredentials is marked non-null but is null");
        }
        String methodTag = TAG + ":getCredentialsFilteredBy";
        Logger.verbose(methodTag, "getCredentialsFilteredBy()");
        List<Credential> matchingCredentials = this.getCredentialsFilteredByInternal(inputCredentials, homeAccountId, environment, credentialType, clientId, applicationIdentifier, mamEnrollmentIdentifier, realm, target, authScheme, requestedClaims, null);
        Logger.verbose(methodTag, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    @Override
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @NonNull Set<CredentialType> credentialTypes, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims) {
        if (credentialTypes == null) {
            throw new NullPointerException("credentialTypes is marked non-null but is null");
        }
        List<Credential> allCredentials = this.getCredentials();
        ArrayList<Credential> result = new ArrayList<Credential>();
        for (CredentialType type : credentialTypes) {
            result.addAll(this.getCredentialsFilteredByInternal(allCredentials, homeAccountId, environment, type, clientId, applicationIdentifier, mamEnrollmentIdentifier, realm, target, authScheme, requestedClaims, null));
        }
        return result;
    }

    @Override
    public List<Credential> getCredentialsFilteredBy(@NonNull List<Credential> inputCredentials, @Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String applicationIdentifier, @Nullable String mamEnrollmentIdentifier, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @Nullable String requestedClaims, @Nullable String kid) {
        if (inputCredentials == null) {
            throw new NullPointerException("inputCredentials is marked non-null but is null");
        }
        ArrayList<Credential> result = new ArrayList<Credential>();
        result.addAll(this.getCredentialsFilteredByInternal(inputCredentials, homeAccountId, environment, credentialType, clientId, applicationIdentifier, mamEnrollmentIdentifier, realm, target, authScheme, requestedClaims, kid));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAccount(@NonNull AccountRecord accountToRemove) {
        if (accountToRemove == null) {
            throw new NullPointerException("accountToRemove is marked non-null but is null");
        }
        String methodTag = TAG + ":removeAccount";
        Logger.info(methodTag, "Removing Account...");
        if (null == accountToRemove) {
            throw new IllegalArgumentException("Param [accountToRemove] cannot be null.");
        }
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(accountToRemove);
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            boolean accountRemoved = false;
            if (this.mSharedPreferencesFileManager.keySet().contains(cacheKey)) {
                this.mSharedPreferencesFileManager.remove(cacheKey);
                accountRemoved = true;
            }
            Logger.info(methodTag, "Account was removed? [" + accountRemoved + "]");
            this.mCachedAccountRecordsWithKeys.remove(cacheKey);
            return accountRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCredential(@NonNull Credential credentialToRemove) {
        if (credentialToRemove == null) {
            throw new NullPointerException("credentialToRemove is marked non-null but is null");
        }
        String methodTag = TAG + ":removeCredential";
        Logger.info(methodTag, "Removing Credential...");
        if (null == credentialToRemove) {
            throw new IllegalArgumentException("Param [credentialToRemove] cannot be null.");
        }
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(credentialToRemove);
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            boolean credentialRemoved = false;
            if (this.mSharedPreferencesFileManager.keySet().contains(cacheKey)) {
                this.mSharedPreferencesFileManager.remove(cacheKey);
                credentialRemoved = true;
            }
            Logger.info(methodTag, "Credential was removed? [" + credentialRemoved + "]");
            this.mCachedCredentialsWithKeys.remove(cacheKey);
            return credentialRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        String methodTag = TAG + ":clearAll";
        Logger.info(methodTag, "Clearing all SharedPreferences entries...");
        Object object = this.mCacheLock;
        synchronized (object) {
            this.waitForInitialLoad();
            this.mSharedPreferencesFileManager.clear();
            this.mCachedCredentialsWithKeys.clear();
            this.mCachedAccountRecordsWithKeys.clear();
        }
        Logger.info(methodTag, "SharedPreferences cleared.");
    }

    @Nullable
    private Class<? extends Credential> credentialClassForType(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        String methodTag = TAG + ":credentialClassForType";
        Logger.verbose(methodTag, "Resolving class for key/CredentialType...");
        Logger.verbosePII(methodTag, "Supplied key: [" + cacheKey + "]");
        CredentialType targetType = SharedPreferencesAccountCredentialCacheWithMemoryCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        if (targetType == null) {
            return null;
        }
        Logger.verbose(methodTag, "CredentialType matched: [" + (Object)((Object)targetType) + "]");
        return this.getTargetClassForCredentialType(cacheKey, targetType);
    }

    @Nullable
    public static CredentialType getCredentialTypeForCredentialCacheKey(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        String methodTag = TAG + ":getCredentialTypeForCredentialCacheKey";
        if (StringUtil.isNullOrEmpty(cacheKey)) {
            throw new IllegalArgumentException("Param [cacheKey] cannot be null.");
        }
        Logger.verbosePII(methodTag, "Evaluating cache key for CredentialType [" + cacheKey + "]");
        HashSet<String> credentialTypesLowerCase = new HashSet<String>();
        for (String credentialTypeStr : CredentialType.valueSet()) {
            credentialTypesLowerCase.add(credentialTypeStr.toLowerCase(Locale.US));
        }
        CredentialType type = null;
        for (String credentialTypeStr : credentialTypesLowerCase) {
            if (!cacheKey.contains("-" + credentialTypeStr + "-")) continue;
            Logger.verbose(methodTag, "Cache key is a Credential type...");
            if (CredentialType.AccessToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.AccessToken;
                break;
            }
            if (CredentialType.AccessToken_With_AuthScheme.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.AccessToken_With_AuthScheme;
                break;
            }
            if (CredentialType.RefreshToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.RefreshToken;
                break;
            }
            if (CredentialType.IdToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.IdToken;
                break;
            }
            if (CredentialType.V1IdToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.V1IdToken;
                break;
            }
            if (CredentialType.PrimaryRefreshToken.name().equalsIgnoreCase(credentialTypeStr)) {
                type = CredentialType.PrimaryRefreshToken;
                break;
            }
            Logger.warn(methodTag, "Unexpected credential type.");
        }
        Logger.verbose(methodTag, "Cache key was type: [" + type + "]");
        return type;
    }

    private static boolean isAccount(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        String methodTag = TAG + ":isAccount";
        Logger.verbosePII(methodTag, "Evaluating cache key: [" + cacheKey + "]");
        boolean isAccount = null == SharedPreferencesAccountCredentialCacheWithMemoryCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.verbose(methodTag, "isAccount? [" + isAccount + "]");
        return isAccount;
    }

    private static boolean isCredential(@NonNull String cacheKey) {
        if (cacheKey == null) {
            throw new NullPointerException("cacheKey is marked non-null but is null");
        }
        String methodTag = TAG + ":isCredential";
        Logger.verbosePII(methodTag, "Evaluating cache key: [" + cacheKey + "]");
        boolean isCredential = null != SharedPreferencesAccountCredentialCacheWithMemoryCache.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.verbose(methodTag, "isCredential? [" + isCredential + "]");
        return isCredential;
    }
}

