/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.AuthenticationSchemeFactory;
import com.microsoft.identity.common.java.cache.AbstractAccountCredentialCache;
import com.microsoft.identity.common.java.cache.CacheRecord;
import com.microsoft.identity.common.java.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.java.cache.IAccountCredentialCache;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class MicrosoftFamilyOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends MsalOAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> {
    private static final String TAG = MicrosoftFamilyOAuth2TokenCache.class.getSimpleName();

    public MicrosoftFamilyOAuth2TokenCache(IPlatformComponents context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> accountCredentialAdapter) {
        super(context, accountCredentialCache, accountCredentialAdapter);
    }

    public ICacheRecord loadByFamilyId(@Nullable String clientId, @Nullable String target, @NonNull AccountRecord accountRecord, @Nullable AbstractAuthenticationScheme authenticationScheme) {
        if (accountRecord == null) {
            throw new NullPointerException("accountRecord is marked non-null but is null");
        }
        String methodName = ":loadByFamilyId";
        String familyId = "1";
        Logger.verbose(TAG + ":loadByFamilyId", "ClientId[" + clientId + ", " + "1" + "]");
        RefreshTokenRecord rtToReturn = null;
        IdTokenRecord idTokenToReturn = null;
        IdTokenRecord v1IdTokenToReturn = null;
        AccessTokenRecord atRecordToReturn = null;
        List<Credential> allCredentials = this.getAccountCredentialCache().getCredentials();
        for (Credential credential : allCredentials) {
            RefreshTokenRecord rtRecord;
            if (!(credential instanceof RefreshTokenRecord) || !"1".equals((rtRecord = (RefreshTokenRecord)credential).getFamilyId()) || !accountRecord.getEnvironment().equals(rtRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(rtRecord.getHomeAccountId())) continue;
            rtToReturn = rtRecord;
            break;
        }
        for (Credential credential : allCredentials) {
            if (!(credential instanceof IdTokenRecord)) continue;
            IdTokenRecord idTokenRecord = (IdTokenRecord)credential;
            if (null == clientId || !clientId.equals(idTokenRecord.getClientId()) || !accountRecord.getEnvironment().equals(idTokenRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(idTokenRecord.getHomeAccountId()) || !accountRecord.getRealm().equals(idTokenRecord.getRealm())) continue;
            if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenRecord.getCredentialType())) {
                v1IdTokenToReturn = idTokenRecord;
                continue;
            }
            idTokenToReturn = idTokenRecord;
        }
        if (null != target && null != authenticationScheme) {
            for (Credential credential : allCredentials) {
                if (!(credential instanceof AccessTokenRecord)) continue;
                AccessTokenRecord atRecord = (AccessTokenRecord)credential;
                if (null == clientId || !clientId.equals(atRecord.getClientId()) || !accountRecord.getEnvironment().equals(atRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(atRecord.getHomeAccountId()) || !accountRecord.getRealm().equals(atRecord.getRealm()) || !AbstractAccountCredentialCache.targetsIntersect(target, atRecord.getTarget(), true)) continue;
                if (CredentialType.AccessToken.name().equalsIgnoreCase(atRecord.getCredentialType()) && "Bearer".equalsIgnoreCase(authenticationScheme.getName())) {
                    atRecordToReturn = atRecord;
                    break;
                }
                if (!CredentialType.AccessToken_With_AuthScheme.name().equalsIgnoreCase(atRecord.getCredentialType()) || !AuthenticationSchemeFactory.isPopAuthenticationScheme(authenticationScheme)) continue;
                atRecordToReturn = atRecord;
                break;
            }
        }
        CacheRecord.CacheRecordBuilder result = CacheRecord.builder();
        result.account(accountRecord);
        result.refreshToken(rtToReturn);
        result.accessToken(atRecordToReturn);
        result.v1IdToken(v1IdTokenToReturn);
        result.idToken(idTokenToReturn);
        return result.build();
    }

    public List<ICacheRecord> loadByFamilyIdWithAggregatedAccountData(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account, @Nullable AbstractAuthenticationScheme authenticationScheme) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        String methodName = ":loadByFamilyIdWithAggregatedAccountData";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        result.add(this.loadByFamilyId(clientId, target, account, authenticationScheme));
        ArrayList<AccountRecord> accountsInOtherTenants = new ArrayList<AccountRecord>(this.getAllTenantAccountsForAccountByClientId(clientId, account));
        Logger.info(TAG + ":loadByFamilyIdWithAggregatedAccountData", "Found " + (accountsInOtherTenants.size() - 1) + " profiles for this account");
        accountsInOtherTenants.remove(0);
        if (!accountsInOtherTenants.isEmpty()) {
            for (AccountRecord accountRecord : accountsInOtherTenants) {
                CacheRecord.CacheRecordBuilder cacheRecord = CacheRecord.builder();
                cacheRecord.account(accountRecord);
                cacheRecord.refreshToken(((ICacheRecord)result.get(0)).getRefreshToken());
                List<IdTokenRecord> idTokensForAccount = this.getIdTokensForAccountRecord(clientId, accountRecord);
                for (IdTokenRecord idTokenRecord : idTokensForAccount) {
                    if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenRecord.getCredentialType())) {
                        cacheRecord.v1IdToken(idTokenRecord);
                        continue;
                    }
                    cacheRecord.idToken(idTokenRecord);
                }
                result.add(cacheRecord.build());
            }
        }
        return result;
    }
}

