/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.AccountCredentialBase;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.dto.PrimaryRefreshTokenRecord;
import com.microsoft.identity.common.java.dto.RefreshTokenRecord;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheKeyValueDelegate
implements ICacheKeyValueDelegate {
    private static final String TAG = CacheKeyValueDelegate.class.getSimpleName();
    public static final String CACHE_VALUE_SEPARATOR = "-";
    private static final String FOCI_PREFIX = "foci-";
    private final Gson mGson = new Gson();

    public CacheKeyValueDelegate() {
        Logger.verbose(TAG, "Init: " + TAG);
    }

    @Override
    public String generateCacheKey(AccountRecord account) {
        String cacheKey = "<home_account_id>-<environment>-<realm>";
        cacheKey = cacheKey.replace("<home_account_id>", StringUtil.sanitizeNullAndLowercaseAndTrim(account.getHomeAccountId()));
        cacheKey = cacheKey.replace("<environment>", StringUtil.sanitizeNullAndLowercaseAndTrim(account.getEnvironment()));
        cacheKey = cacheKey.replace("<realm>", StringUtil.sanitizeNullAndLowercaseAndTrim(account.getRealm()));
        return cacheKey;
    }

    private String generateCacheValueInternal(Object baseObject) {
        JsonElement outboundElement = this.mGson.toJsonTree(baseObject);
        JsonObject outboundObject = outboundElement.getAsJsonObject();
        if (baseObject instanceof AccountCredentialBase) {
            AccountCredentialBase accountCredentialBase = (AccountCredentialBase)baseObject;
            for (String key : accountCredentialBase.getAdditionalFields().keySet()) {
                outboundObject.add(key, accountCredentialBase.getAdditionalFields().get(key));
            }
        }
        String json = this.mGson.toJson((JsonElement)outboundObject);
        return json;
    }

    @Override
    public String generateCacheValue(AccountRecord account) {
        String result = this.generateCacheValueInternal(account);
        return result;
    }

    @Override
    public String generateCacheKey(Credential credential) {
        RefreshTokenRecord rt;
        String cacheKey = "<home_account_id>-<environment>-<credential_type>-<client_id>-<realm>-<target>";
        cacheKey = cacheKey.replace("<home_account_id>", StringUtil.sanitizeNullAndLowercaseAndTrim(credential.getHomeAccountId()));
        cacheKey = cacheKey.replace("<environment>", StringUtil.sanitizeNullAndLowercaseAndTrim(credential.getEnvironment()));
        cacheKey = cacheKey.replace("<credential_type>", StringUtil.sanitizeNullAndLowercaseAndTrim(credential.getCredentialType()));
        if (credential instanceof RefreshTokenRecord && !StringUtil.isNullOrEmpty((rt = (RefreshTokenRecord)credential).getFamilyId())) {
            String familyIdForCacheKey = rt.getFamilyId();
            if (familyIdForCacheKey.startsWith(FOCI_PREFIX)) {
                familyIdForCacheKey = familyIdForCacheKey.replace(FOCI_PREFIX, "");
            }
            cacheKey = cacheKey.replace("<client_id>", familyIdForCacheKey);
        } else {
            cacheKey = cacheKey.replace("<client_id>", StringUtil.sanitizeNullAndLowercaseAndTrim(credential.getClientId()));
        }
        if (credential instanceof AccessTokenRecord) {
            AccessTokenRecord accessToken = (AccessTokenRecord)credential;
            cacheKey = cacheKey.replace("<realm>", StringUtil.sanitizeNullAndLowercaseAndTrim(accessToken.getRealm()));
            cacheKey = cacheKey.replace("<target>", StringUtil.sanitizeNullAndLowercaseAndTrim(accessToken.getTarget()));
            if (!StringUtil.isNullOrEmpty(accessToken.getApplicationIdentifier())) {
                cacheKey = cacheKey + "-<application_identifier>";
                cacheKey = cacheKey.replace("<application_identifier>", StringUtil.sanitizeNullAndLowercaseAndTrim(accessToken.getApplicationIdentifier()));
            }
            if (!StringUtil.isNullOrEmpty(accessToken.getMamEnrollmentIdentifier())) {
                cacheKey = cacheKey + "-<mam_enrollment_identifier>";
                cacheKey = cacheKey.replace("<mam_enrollment_identifier>", StringUtil.sanitizeNullAndLowercaseAndTrim(accessToken.getMamEnrollmentIdentifier()));
            }
            if ("pop".equalsIgnoreCase(accessToken.getAccessTokenType())) {
                cacheKey = cacheKey + "-<auth_scheme>";
                cacheKey = cacheKey.replace("<auth_scheme>", StringUtil.sanitizeNullAndLowercaseAndTrim(accessToken.getAccessTokenType()));
            }
            if (!StringUtil.isNullOrEmpty(accessToken.getRequestedClaims())) {
                cacheKey = cacheKey + "-<requested_claims>";
                String reqClaimsHash = String.valueOf(StringUtil.sanitizeNullAndLowercaseAndTrim(accessToken.getRequestedClaims()).hashCode());
                cacheKey = cacheKey.replace("<requested_claims>", StringUtil.sanitizeNullAndLowercaseAndTrim(reqClaimsHash));
            }
        } else if (credential instanceof RefreshTokenRecord) {
            RefreshTokenRecord refreshToken = (RefreshTokenRecord)credential;
            cacheKey = cacheKey.replace("<realm>", "");
            cacheKey = cacheKey.replace("<target>", StringUtil.sanitizeNullAndLowercaseAndTrim(refreshToken.getTarget()));
        } else if (credential instanceof IdTokenRecord) {
            IdTokenRecord idToken = (IdTokenRecord)credential;
            cacheKey = cacheKey.replace("<realm>", StringUtil.sanitizeNullAndLowercaseAndTrim(idToken.getRealm()));
            cacheKey = cacheKey.replace("<target>", "");
        } else if (credential instanceof PrimaryRefreshTokenRecord) {
            cacheKey = cacheKey.replace("<realm>", "");
            cacheKey = cacheKey.replace("<target>", "");
        }
        return cacheKey;
    }

    @Override
    public String generateCacheValue(Credential credential) {
        String result = this.generateCacheValueInternal(credential);
        return result;
    }

    @Override
    public <T extends AccountCredentialBase> T fromCacheValue(String string, Class<? extends AccountCredentialBase> t) {
        String methodName = "fromCacheValue";
        try {
            AccountCredentialBase resultObject = (AccountCredentialBase)this.mGson.fromJson(string, t);
            if (!StringUtil.isNullOrEmpty(string)) {
                JsonObject incomingJson = new JsonParser().parse(string).getAsJsonObject();
                Set<String> expectedFields = CacheKeyValueDelegate.getExpectedJsonFields(t);
                for (String expectedField : expectedFields) {
                    incomingJson.remove(expectedField);
                }
                HashMap<String, JsonElement> additionalFields = new HashMap<String, JsonElement>();
                for (String key : incomingJson.keySet()) {
                    additionalFields.put(key, incomingJson.get(key));
                }
                resultObject.setAdditionalFields(additionalFields);
            }
            return (T)resultObject;
        }
        catch (JsonSyntaxException e) {
            Logger.error(TAG + ":" + "fromCacheValue", "Failed to parse cache value.", null);
            return null;
        }
    }

    private static Set<String> getExpectedJsonFields(Class<? extends AccountCredentialBase> clazz) {
        HashSet<String> serializedNames = new HashSet<String>();
        List<Field> fieldsToInspect = CacheKeyValueDelegate.getFieldsUpTo(clazz, AccountCredentialBase.class);
        List<Field> annotatedFields = CacheKeyValueDelegate.getSerializedNameAnnotatedFields(fieldsToInspect);
        for (Field annotatedField : annotatedFields) {
            SerializedName serializedName = annotatedField.getAnnotation(SerializedName.class);
            serializedNames.add(serializedName.value());
        }
        return serializedNames;
    }

    private static List<Field> getSerializedNameAnnotatedFields(List<Field> fieldsToInspect) {
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : fieldsToInspect) {
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            if (null == serializedName) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    private static List<Field> getFieldsUpTo(Class<?> startClass, @Nullable Class<?> upperBound) {
        ArrayList<Field> currentClassFields = new ArrayList<Field>(Arrays.asList(startClass.getDeclaredFields()));
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || upperBound != null && parentClass.equals(upperBound))) {
            List<Field> parentClassFields = CacheKeyValueDelegate.getFieldsUpTo(parentClass, upperBound);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    static class CacheKeyReplacements {
        static final String HOME_ACCOUNT_ID = "<home_account_id>";
        static final String ENVIRONMENT = "<environment>";
        static final String REALM = "<realm>";
        static final String CREDENTIAL_TYPE = "<credential_type>";
        static final String CLIENT_ID = "<client_id>";
        static final String APPLICATION_IDENTIFIER = "<application_identifier>";
        static final String MAM_ENROLLMENT_IDENTIFIER = "<mam_enrollment_identifier>";
        static final String TARGET = "<target>";
        static final String AUTH_SCHEME = "<auth_scheme>";
        static final String REQUESTED_CLAIMS = "<requested_claims>";

        CacheKeyReplacements() {
        }
    }
}

