/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.AccountDeletionRecord;
import com.microsoft.identity.common.java.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.java.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.dto.CredentialType;
import com.microsoft.identity.common.java.dto.IdTokenRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class BrokerOAuth2TokenCacheTelemetryWrapper<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends MicrosoftTokenResponse, GenericAccount extends MicrosoftAccount, GenericRefreshToken extends MicrosoftRefreshToken>
extends BrokerOAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> {
    private final BrokerOAuth2TokenCache mCacheToWrap;

    public BrokerOAuth2TokenCacheTelemetryWrapper(@NonNull IPlatformComponents mPlatformComponents, int uid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache, @NonNull BrokerOAuth2TokenCache cacheToWrap) {
        super(mPlatformComponents, uid, applicationMetadataCache);
        if (mPlatformComponents == null) {
            throw new NullPointerException("mPlatformComponents is marked non-null but is null");
        }
        if (applicationMetadataCache == null) {
            throw new NullPointerException("applicationMetadataCache is marked non-null but is null");
        }
        if (cacheToWrap == null) {
            throw new NullPointerException("cacheToWrap is marked non-null but is null");
        }
        this.mCacheToWrap = cacheToWrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheRecord save(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        if (oAuth2Strategy == null) {
            throw new NullPointerException("oAuth2Strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        long startTime = System.currentTimeMillis();
        try {
            ICacheRecord iCacheRecord = this.mCacheToWrap.save(oAuth2Strategy, request, response);
            return iCacheRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_save.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> saveAndLoadAggregatedAccountData(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        if (oAuth2Strategy == null) {
            throw new NullPointerException("oAuth2Strategy is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        long startTime = System.currentTimeMillis();
        try {
            List<ICacheRecord> list = this.mCacheToWrap.saveAndLoadAggregatedAccountData(oAuth2Strategy, request, response);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_save_and_load_aggregated_account_data.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheRecord save(AccountRecord accountRecord, IdTokenRecord idTokenRecord) {
        long startTime = System.currentTimeMillis();
        try {
            ICacheRecord iCacheRecord = this.mCacheToWrap.save(accountRecord, idTokenRecord);
            return iCacheRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_save.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheRecord load(String clientId, String applicationIdentifier, String mamEnrollmentIdentifier, String target, AccountRecord account, AbstractAuthenticationScheme authScheme) {
        long startTime = System.currentTimeMillis();
        try {
            ICacheRecord iCacheRecord = this.mCacheToWrap.load(clientId, applicationIdentifier, mamEnrollmentIdentifier, target, account, authScheme);
            return iCacheRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_load.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> loadWithAggregatedAccountData(String clientId, String applicationIdentifier, String mamEnrollmentIdentifier, String target, AccountRecord account, AbstractAuthenticationScheme authenticationScheme) {
        long startTime = System.currentTimeMillis();
        try {
            List<ICacheRecord> list = this.mCacheToWrap.loadWithAggregatedAccountData(clientId, applicationIdentifier, mamEnrollmentIdentifier, target, account, authenticationScheme);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_load_aggregated_account_data.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCredential(Credential credential) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = this.mCacheToWrap.removeCredential(credential);
            return bl;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_remove_credential.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountRecord getAccount(String environment, String clientId, String homeAccountId, String realm) {
        long startTime = System.currentTimeMillis();
        try {
            AccountRecord accountRecord = this.mCacheToWrap.getAccount(environment, clientId, homeAccountId, realm);
            return accountRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_account.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(String environment, String clientId, String homeAccountId) {
        long startTime = System.currentTimeMillis();
        try {
            List<ICacheRecord> list = this.mCacheToWrap.getAccountsWithAggregatedAccountData(environment, clientId, homeAccountId);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_accounts_with_aggregated_account_data.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountRecord getAccountByLocalAccountId(String environment, String clientId, String localAccountId) {
        long startTime = System.currentTimeMillis();
        try {
            AccountRecord accountRecord = this.mCacheToWrap.getAccountByLocalAccountId(environment, clientId, localAccountId);
            return accountRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_account_by_local_account_id.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(String environment, String clientId, String localAccountId) {
        long startTime = System.currentTimeMillis();
        try {
            ICacheRecord iCacheRecord = this.mCacheToWrap.getAccountWithAggregatedAccountDataByLocalAccountId(environment, clientId, localAccountId);
            return iCacheRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_account_with_aggregated_account_data_by_local_account_id.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccountRecord> getAccounts(String environment, String clientId) {
        long startTime = System.currentTimeMillis();
        try {
            List<AccountRecord> list = this.mCacheToWrap.getAccounts(environment, clientId);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_accounts.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccountRecord> getAllTenantAccountsForAccountByClientId(String clientId, AccountRecord accountRecord) {
        long startTime = System.currentTimeMillis();
        try {
            List<AccountRecord> list = this.mCacheToWrap.getAllTenantAccountsForAccountByClientId(clientId, accountRecord);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_all_tenant_accounts_for_account_by_client_id.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(String environment, String clientId) {
        long startTime = System.currentTimeMillis();
        try {
            List<ICacheRecord> list = this.mCacheToWrap.getAccountsWithAggregatedAccountData(environment, clientId);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_accounts_with_aggregated_account_data.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IdTokenRecord> getIdTokensForAccountRecord(String clientId, AccountRecord accountRecord) {
        long startTime = System.currentTimeMillis();
        try {
            List<IdTokenRecord> list = this.mCacheToWrap.getIdTokensForAccountRecord(clientId, accountRecord);
            return list;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_id_tokens_for_account_record.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm) {
        long startTime = System.currentTimeMillis();
        try {
            AccountDeletionRecord accountDeletionRecord = this.mCacheToWrap.removeAccount(environment, clientId, homeAccountId, realm);
            return accountDeletionRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_remove_account.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm, CredentialType ... typesToRemove) {
        long startTime = System.currentTimeMillis();
        try {
            AccountDeletionRecord accountDeletionRecord = this.mCacheToWrap.removeAccount(environment, clientId, homeAccountId, realm, typesToRemove);
            return accountDeletionRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_remove_account.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        long startTime = System.currentTimeMillis();
        try {
            this.mCacheToWrap.clearAll();
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_clear_all.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> getAllClientIds() {
        long startTime = System.currentTimeMillis();
        try {
            Set<String> set = this.mCacheToWrap.getAllClientIds();
            return set;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_all_client_ids.name(), elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountRecord getAccountByHomeAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (homeAccountId == null) {
            throw new NullPointerException("homeAccountId is marked non-null but is null");
        }
        long startTime = System.currentTimeMillis();
        try {
            AccountRecord accountRecord = this.mCacheToWrap.getAccountByHomeAccountId(environment, clientId, homeAccountId);
            return accountRecord;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_cache_get_account_by_home_account_id.name(), elapsedTime);
        }
    }
}

