/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;
import java.util.HashMap;
import java.util.Map;

public class MicrosoftStsAuthorizationRequest
extends MicrosoftAuthorizationRequest<MicrosoftStsAuthorizationRequest> {
    private static final long serialVersionUID = 6545759826515911472L;
    private static final String AUTHORIZATION_ENDPOINT = "oAuth2/v2.0/authorize";
    @Expose
    @SerializedName(value="prompt")
    private String mPrompt;
    @SerializedName(value="login_req")
    private String mUid;
    @SerializedName(value="domain_req")
    private String mUtid;
    private transient String mDisplayableId;
    private transient String mTokenScope;
    public static final String HIDE_SWITCH_USER_QUERY_PARAMETER = "hsu";

    protected MicrosoftStsAuthorizationRequest(Builder builder) {
        super(builder);
        this.mPrompt = builder.mPrompt;
        this.mUid = builder.mUid;
        this.mUtid = builder.mUtid;
        this.mDisplayableId = builder.mDisplayableId;
        this.mTokenScope = builder.mTokenScope;
    }

    public String getUid() {
        return this.mUid;
    }

    public String getUtid() {
        return this.mUtid;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    public String getTokenScope() {
        return this.mTokenScope;
    }

    @Override
    public Uri getAuthorizationRequestAsHttpRequest() {
        HashMap<Object, Object> qpMap = new HashMap<Object, Object>();
        qpMap.putAll(ObjectMapper.serializeObjectHashMap(this));
        for (Map.Entry entry : this.mFlightParameters.entrySet()) {
            qpMap.put(entry.getKey(), entry.getValue());
        }
        if (this.mSlice != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mSlice.getSlice())) {
                qpMap.put("slice", this.mSlice.getSlice());
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSlice.getDC())) {
                qpMap.put("dc", this.mSlice.getDC());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.getLoginHint())) {
            qpMap.put(HIDE_SWITCH_USER_QUERY_PARAMETER, "1");
        }
        if (null != this.getExtraQueryParams() && !this.getExtraQueryParams().isEmpty()) {
            for (Pair pair : this.getExtraQueryParams()) {
                if (qpMap.containsKey(pair.first)) continue;
                qpMap.put(pair.first, pair.second);
            }
        }
        Uri.Builder uriBuilder = Uri.parse((String)this.getAuthorizationEndpoint()).buildUpon();
        for (Map.Entry entry : qpMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            uriBuilder.appendQueryParameter((String)entry.getKey(), entry.getValue().toString());
        }
        return uriBuilder.build();
    }

    @Override
    public String getAuthorizationEndpoint() {
        Uri authorityUri = Uri.parse((String)this.getAuthority().toString());
        Uri endpointUri = authorityUri.buildUpon().appendEncodedPath(AUTHORIZATION_ENDPOINT).build();
        return endpointUri.toString();
    }

    public static class Builder
    extends MicrosoftAuthorizationRequest.Builder<Builder> {
        private String mUid;
        private String mUtid;
        private String mDisplayableId;
        private String mTokenScope;

        public Builder setUid(String uid) {
            this.mUid = uid;
            return this.self();
        }

        public Builder setUtid(String utid) {
            this.mUtid = utid;
            return this.self();
        }

        public Builder setDisplayableId(String displayableId) {
            this.mDisplayableId = displayableId;
            return this.self();
        }

        public Builder setTokenScope(String tokenScope) {
            this.mTokenScope = tokenScope;
            return this.self();
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public MicrosoftStsAuthorizationRequest build() {
            return new MicrosoftStsAuthorizationRequest(this);
        }
    }

    public static final class Prompt {
        public static final String SELECT_ACCOUNT = "select_account";
        public static final String FORCE_LOGIN = "login";
        public static final String CONSENT = "consent";
    }
}

