/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands.parameters;

import android.accounts.Account;
import android.text.TextUtils;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.internal.commands.parameters.IHasExtraParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.request.BrokerRequestType;
import java.util.Map;

public class BrokerInteractiveTokenCommandParameters
extends InteractiveTokenCommandParameters
implements IHasExtraParameters {
    private final String callerPackageName;
    private final int callerUid;
    private final String callerAppVersion;
    private final String brokerVersion;
    private final boolean shouldResolveInterrupt;
    private final BrokerRequestType requestType;
    private final String negotiatedBrokerProtocolVersion;
    private final Iterable<Map.Entry<String, String>> extraParameters;
    private final String enrollmentId;
    private final Account accountManagerAccount;
    private final String homeAccountId;
    private final String localAccountId;

    public boolean isRequestFromBroker() {
        return this.requestType == BrokerRequestType.BROKER_RT_REQUEST || this.requestType == BrokerRequestType.RESOLVE_INTERRUPT;
    }

    @Override
    public void validate() throws ArgumentException {
        super.validate();
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireToken", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireToken", "mScopes", "Scope or resource is not set");
        }
        if (TextUtils.isEmpty((CharSequence)this.getClientId())) {
            throw new ArgumentException("acquireToken", "mClientId", "Client Id is not set");
        }
        if (!this.isRequestFromBroker()) {
            if (this.callerUid == 0) {
                throw new ArgumentException("acquireToken", "mCallerUId", "Caller Uid is not set");
            }
            if (TextUtils.isEmpty((CharSequence)this.callerPackageName)) {
                throw new ArgumentException("acquireToken", "mCallerPackageName", "Caller package name is not set");
            }
            if (!(this.getOAuth2TokenCache() instanceof BrokerOAuth2TokenCache)) {
                throw new ArgumentException("acquireToken", "AcquireTokenSilentOperationParameters", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
            }
            if (this.getSdkType().isCapableOfMSA() && !BrokerValidator.isValidBrokerRedirect(this.getRedirectUri(), this.getAndroidApplicationContext(), this.getCallerPackageName())) {
                throw new ArgumentException("acquireToken", "mRedirectUri", "The redirect URI doesn't match the uri generated with caller package name and signature");
            }
        }
    }

    @Override
    public void setExtraParameters(Iterable<Map.Entry<String, String>> params) {
        throw new UnsupportedOperationException();
    }

    protected BrokerInteractiveTokenCommandParameters(BrokerInteractiveTokenCommandParametersBuilder<?, ?> b) {
        super((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder<?, ?>)b);
        this.callerPackageName = ((BrokerInteractiveTokenCommandParametersBuilder)b).callerPackageName;
        this.callerUid = ((BrokerInteractiveTokenCommandParametersBuilder)b).callerUid;
        this.callerAppVersion = ((BrokerInteractiveTokenCommandParametersBuilder)b).callerAppVersion;
        this.brokerVersion = ((BrokerInteractiveTokenCommandParametersBuilder)b).brokerVersion;
        this.shouldResolveInterrupt = ((BrokerInteractiveTokenCommandParametersBuilder)b).shouldResolveInterrupt;
        this.requestType = ((BrokerInteractiveTokenCommandParametersBuilder)b).requestType;
        this.negotiatedBrokerProtocolVersion = ((BrokerInteractiveTokenCommandParametersBuilder)b).negotiatedBrokerProtocolVersion;
        this.extraParameters = ((BrokerInteractiveTokenCommandParametersBuilder)b).extraParameters;
        this.enrollmentId = ((BrokerInteractiveTokenCommandParametersBuilder)b).enrollmentId;
        this.accountManagerAccount = ((BrokerInteractiveTokenCommandParametersBuilder)b).accountManagerAccount;
        this.homeAccountId = ((BrokerInteractiveTokenCommandParametersBuilder)b).homeAccountId;
        this.localAccountId = ((BrokerInteractiveTokenCommandParametersBuilder)b).localAccountId;
    }

    public static BrokerInteractiveTokenCommandParametersBuilder<?, ?> builder() {
        return new BrokerInteractiveTokenCommandParametersBuilderImpl();
    }

    @Override
    public BrokerInteractiveTokenCommandParametersBuilder<?, ?> toBuilder() {
        return new BrokerInteractiveTokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public String getCallerPackageName() {
        return this.callerPackageName;
    }

    public int getCallerUid() {
        return this.callerUid;
    }

    public String getCallerAppVersion() {
        return this.callerAppVersion;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public boolean isShouldResolveInterrupt() {
        return this.shouldResolveInterrupt;
    }

    public BrokerRequestType getRequestType() {
        return this.requestType;
    }

    public String getNegotiatedBrokerProtocolVersion() {
        return this.negotiatedBrokerProtocolVersion;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getExtraParameters() {
        return this.extraParameters;
    }

    public String getEnrollmentId() {
        return this.enrollmentId;
    }

    public Account getAccountManagerAccount() {
        return this.accountManagerAccount;
    }

    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    public String getLocalAccountId() {
        return this.localAccountId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerInteractiveTokenCommandParameters)) {
            return false;
        }
        BrokerInteractiveTokenCommandParameters other = (BrokerInteractiveTokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$callerPackageName = this.getCallerPackageName();
        String other$callerPackageName = other.getCallerPackageName();
        if (this$callerPackageName == null ? other$callerPackageName != null : !this$callerPackageName.equals(other$callerPackageName)) {
            return false;
        }
        if (this.getCallerUid() != other.getCallerUid()) {
            return false;
        }
        String this$callerAppVersion = this.getCallerAppVersion();
        String other$callerAppVersion = other.getCallerAppVersion();
        if (this$callerAppVersion == null ? other$callerAppVersion != null : !this$callerAppVersion.equals(other$callerAppVersion)) {
            return false;
        }
        String this$brokerVersion = this.getBrokerVersion();
        String other$brokerVersion = other.getBrokerVersion();
        if (this$brokerVersion == null ? other$brokerVersion != null : !this$brokerVersion.equals(other$brokerVersion)) {
            return false;
        }
        if (this.isShouldResolveInterrupt() != other.isShouldResolveInterrupt()) {
            return false;
        }
        BrokerRequestType this$requestType = this.getRequestType();
        BrokerRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !((Object)((Object)this$requestType)).equals((Object)other$requestType)) {
            return false;
        }
        String this$negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        String other$negotiatedBrokerProtocolVersion = other.getNegotiatedBrokerProtocolVersion();
        if (this$negotiatedBrokerProtocolVersion == null ? other$negotiatedBrokerProtocolVersion != null : !this$negotiatedBrokerProtocolVersion.equals(other$negotiatedBrokerProtocolVersion)) {
            return false;
        }
        Iterable<Map.Entry<String, String>> this$extraParameters = this.getExtraParameters();
        Iterable<Map.Entry<String, String>> other$extraParameters = other.getExtraParameters();
        if (this$extraParameters == null ? other$extraParameters != null : !this$extraParameters.equals(other$extraParameters)) {
            return false;
        }
        String this$enrollmentId = this.getEnrollmentId();
        String other$enrollmentId = other.getEnrollmentId();
        if (this$enrollmentId == null ? other$enrollmentId != null : !this$enrollmentId.equals(other$enrollmentId)) {
            return false;
        }
        Account this$accountManagerAccount = this.getAccountManagerAccount();
        Account other$accountManagerAccount = other.getAccountManagerAccount();
        if (this$accountManagerAccount == null ? other$accountManagerAccount != null : !this$accountManagerAccount.equals(other$accountManagerAccount)) {
            return false;
        }
        String this$homeAccountId = this.getHomeAccountId();
        String other$homeAccountId = other.getHomeAccountId();
        if (this$homeAccountId == null ? other$homeAccountId != null : !this$homeAccountId.equals(other$homeAccountId)) {
            return false;
        }
        String this$localAccountId = this.getLocalAccountId();
        String other$localAccountId = other.getLocalAccountId();
        return !(this$localAccountId == null ? other$localAccountId != null : !this$localAccountId.equals(other$localAccountId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerInteractiveTokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $callerPackageName = this.getCallerPackageName();
        result = result * 59 + ($callerPackageName == null ? 43 : $callerPackageName.hashCode());
        result = result * 59 + this.getCallerUid();
        String $callerAppVersion = this.getCallerAppVersion();
        result = result * 59 + ($callerAppVersion == null ? 43 : $callerAppVersion.hashCode());
        String $brokerVersion = this.getBrokerVersion();
        result = result * 59 + ($brokerVersion == null ? 43 : $brokerVersion.hashCode());
        result = result * 59 + (this.isShouldResolveInterrupt() ? 79 : 97);
        BrokerRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : ((Object)((Object)$requestType)).hashCode());
        String $negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        result = result * 59 + ($negotiatedBrokerProtocolVersion == null ? 43 : $negotiatedBrokerProtocolVersion.hashCode());
        Iterable<Map.Entry<String, String>> $extraParameters = this.getExtraParameters();
        result = result * 59 + ($extraParameters == null ? 43 : $extraParameters.hashCode());
        String $enrollmentId = this.getEnrollmentId();
        result = result * 59 + ($enrollmentId == null ? 43 : $enrollmentId.hashCode());
        Account $accountManagerAccount = this.getAccountManagerAccount();
        result = result * 59 + ($accountManagerAccount == null ? 43 : $accountManagerAccount.hashCode());
        String $homeAccountId = this.getHomeAccountId();
        result = result * 59 + ($homeAccountId == null ? 43 : $homeAccountId.hashCode());
        String $localAccountId = this.getLocalAccountId();
        result = result * 59 + ($localAccountId == null ? 43 : $localAccountId.hashCode());
        return result;
    }

    private static final class BrokerInteractiveTokenCommandParametersBuilderImpl
    extends BrokerInteractiveTokenCommandParametersBuilder<BrokerInteractiveTokenCommandParameters, BrokerInteractiveTokenCommandParametersBuilderImpl> {
        private BrokerInteractiveTokenCommandParametersBuilderImpl() {
        }

        @Override
        protected BrokerInteractiveTokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public BrokerInteractiveTokenCommandParameters build() {
            return new BrokerInteractiveTokenCommandParameters(this);
        }
    }

    public static abstract class BrokerInteractiveTokenCommandParametersBuilder<C extends BrokerInteractiveTokenCommandParameters, B extends BrokerInteractiveTokenCommandParametersBuilder<C, B>>
    extends InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder<C, B> {
        private String callerPackageName;
        private int callerUid;
        private String callerAppVersion;
        private String brokerVersion;
        private boolean shouldResolveInterrupt;
        private BrokerRequestType requestType;
        private String negotiatedBrokerProtocolVersion;
        private Iterable<Map.Entry<String, String>> extraParameters;
        private String enrollmentId;
        private Account accountManagerAccount;
        private String homeAccountId;
        private String localAccountId;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrokerInteractiveTokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrokerInteractiveTokenCommandParameters instance, BrokerInteractiveTokenCommandParametersBuilder<?, ?> b) {
            b.callerPackageName(instance.callerPackageName);
            b.callerUid(instance.callerUid);
            b.callerAppVersion(instance.callerAppVersion);
            b.brokerVersion(instance.brokerVersion);
            b.shouldResolveInterrupt(instance.shouldResolveInterrupt);
            b.requestType(instance.requestType);
            b.negotiatedBrokerProtocolVersion(instance.negotiatedBrokerProtocolVersion);
            b.extraParameters(instance.extraParameters);
            b.enrollmentId(instance.enrollmentId);
            b.accountManagerAccount(instance.accountManagerAccount);
            b.homeAccountId(instance.homeAccountId);
            b.localAccountId(instance.localAccountId);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B callerPackageName(String callerPackageName) {
            this.callerPackageName = callerPackageName;
            return (B)this.self();
        }

        public B callerUid(int callerUid) {
            this.callerUid = callerUid;
            return (B)this.self();
        }

        public B callerAppVersion(String callerAppVersion) {
            this.callerAppVersion = callerAppVersion;
            return (B)this.self();
        }

        public B brokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return (B)this.self();
        }

        public B shouldResolveInterrupt(boolean shouldResolveInterrupt) {
            this.shouldResolveInterrupt = shouldResolveInterrupt;
            return (B)this.self();
        }

        public B requestType(BrokerRequestType requestType) {
            this.requestType = requestType;
            return (B)this.self();
        }

        public B negotiatedBrokerProtocolVersion(String negotiatedBrokerProtocolVersion) {
            this.negotiatedBrokerProtocolVersion = negotiatedBrokerProtocolVersion;
            return (B)this.self();
        }

        public B extraParameters(Iterable<Map.Entry<String, String>> extraParameters) {
            this.extraParameters = extraParameters;
            return (B)this.self();
        }

        public B enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return (B)this.self();
        }

        public B accountManagerAccount(Account accountManagerAccount) {
            this.accountManagerAccount = accountManagerAccount;
            return (B)this.self();
        }

        public B homeAccountId(String homeAccountId) {
            this.homeAccountId = homeAccountId;
            return (B)this.self();
        }

        public B localAccountId(String localAccountId) {
            this.localAccountId = localAccountId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder(super=" + super.toString() + ", callerPackageName=" + this.callerPackageName + ", callerUid=" + this.callerUid + ", callerAppVersion=" + this.callerAppVersion + ", brokerVersion=" + this.brokerVersion + ", shouldResolveInterrupt=" + this.shouldResolveInterrupt + ", requestType=" + (Object)((Object)this.requestType) + ", negotiatedBrokerProtocolVersion=" + this.negotiatedBrokerProtocolVersion + ", extraParameters=" + this.extraParameters + ", enrollmentId=" + this.enrollmentId + ", accountManagerAccount=" + this.accountManagerAccount + ", homeAccountId=" + this.homeAccountId + ", localAccountId=" + this.localAccountId + ")";
        }
    }
}

