/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.logging;

import com.microsoft.identity.common.logging.IRequestContext;
import com.microsoft.identity.common.logging.RequestContext;

public class DiagnosticContext {
    public static final String CORRELATION_ID = "correlation_id";
    public static final String THREAD_ID = "thread_id";
    public static final String THREAD_NAME = "thread_name";
    private static final ThreadLocal<IRequestContext> REQUEST_CONTEXT_THREAD_LOCAL = new ThreadLocal<IRequestContext>(){

        @Override
        protected RequestContext initialValue() {
            RequestContext defaultRequestContext = new RequestContext();
            defaultRequestContext.put(DiagnosticContext.CORRELATION_ID, "UNSET");
            return defaultRequestContext;
        }
    };

    protected DiagnosticContext() {
    }

    public static void setRequestContext(IRequestContext requestContext) {
        if (null == requestContext) {
            DiagnosticContext.clear();
            return;
        }
        requestContext.put(THREAD_ID, String.valueOf(Thread.currentThread().getId()));
        requestContext.put(THREAD_NAME, Thread.currentThread().getName());
        REQUEST_CONTEXT_THREAD_LOCAL.set(requestContext);
    }

    public static IRequestContext getRequestContext() {
        if (!DiagnosticContext.hasThreadMetadata()) {
            DiagnosticContext.setThreadMetadata();
        }
        return REQUEST_CONTEXT_THREAD_LOCAL.get();
    }

    private static void setThreadMetadata() {
        REQUEST_CONTEXT_THREAD_LOCAL.get().put(THREAD_ID, String.valueOf(Thread.currentThread().getId()));
        REQUEST_CONTEXT_THREAD_LOCAL.get().put(THREAD_NAME, Thread.currentThread().getName());
    }

    private static boolean hasThreadMetadata() {
        return REQUEST_CONTEXT_THREAD_LOCAL.get().containsKey(THREAD_ID);
    }

    public static void clear() {
        REQUEST_CONTEXT_THREAD_LOCAL.remove();
    }
}

