/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import java.util.List;
import java.util.Set;

public class ProcessUtil {
    private ProcessUtil() {
    }

    public static boolean isBrokerProcess(@NonNull Context context) {
        String processName = ProcessUtil.getProcessName(context);
        BrokerValidator brokerValidator = new BrokerValidator(context);
        Set<BrokerData> validBrokers = brokerValidator.getValidBrokers();
        for (BrokerData brokerData : validBrokers) {
            String authProcess = brokerData.packageName + ":auth";
            if (!authProcess.equalsIgnoreCase(processName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getProcessName(@NonNull Context context) {
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getApplicationContext().getSystemService("activity");
        List runningProcesses = am.getRunningAppProcesses();
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo procInfo : runningProcesses) {
                if (procInfo.pid != pid) continue;
                return procInfo.processName;
            }
        }
        return null;
    }

    @NonNull
    public static Handler getPreferredHandler() {
        if (null != Looper.myLooper()) {
            return new Handler(Looper.myLooper());
        }
        return new Handler(Looper.getMainLooper());
    }
}

