/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.util.Base64;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class PkceChallenge
implements Serializable {
    private static final int CODE_VERIFIER_BYTE_SIZE = 32;
    private static final int ENCODE_MASK = 11;
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final String ISO_8859_1 = "ISO_8859_1";
    private static final String CHALLENGE_SHA256 = "S256";
    private static final long serialVersionUID = 8549806628675994235L;
    private final transient String mCodeVerifier;
    @SerializedName(value="code_challenge")
    private final String mCodeChallenge;
    @SerializedName(value="code_challenge_method")
    private final String mCodeChallengeMethod = "S256";

    private PkceChallenge(String codeVerifier, String codeChallenge) {
        this.mCodeVerifier = codeVerifier;
        this.mCodeChallenge = codeChallenge;
    }

    public String getCodeVerifier() {
        return this.mCodeVerifier;
    }

    public String getCodeChallenge() {
        return this.mCodeChallenge;
    }

    public String getCodeChallengeMethod() {
        return CHALLENGE_SHA256;
    }

    public static PkceChallenge newPkceChallenge() {
        String codeVerifier = PkceChallenge.generateCodeVerifier();
        String codeChallenge = PkceChallenge.generateCodeVerifierChallenge(codeVerifier);
        return new PkceChallenge(codeVerifier, codeChallenge);
    }

    private static String generateCodeVerifier() {
        byte[] verifierBytes = new byte[32];
        new SecureRandom().nextBytes(verifierBytes);
        return Base64.encodeToString((byte[])verifierBytes, (int)11);
    }

    private static String generateCodeVerifierChallenge(String verifier) {
        try {
            MessageDigest digester = MessageDigest.getInstance(DIGEST_ALGORITHM);
            digester.update(verifier.getBytes(ISO_8859_1));
            byte[] digestBytes = digester.digest();
            return Base64.encodeToString((byte[])digestBytes, (int)11);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate the code verifier challenge", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Every implementation of the Java platform is required to support ISO-8859-1.Consult the release documentation for your implementation.", e);
        }
    }
}

