/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Configuration;
import com.microsoft.identity.common.logging.Logger;
import java.net.URL;

public class MicrosoftStsOAuth2Configuration
extends AzureActiveDirectoryOAuth2Configuration {
    private static final String TAG = MicrosoftStsOAuth2Configuration.class.getSimpleName();
    private static final String ENDPOINT_SUFFIX = "/oAuth2/v2.0";
    private static final String AUTHORIZE_ENDPOINT_SUFFIX = "/oAuth2/v2.0/authorize";
    private static final String TOKEN_ENDPOINT_SUFFIX = "/oAuth2/v2.0/token";
    private static final String DEVICE_AUTHORIZE_ENDPOINT_SUFFIX = "/oAuth2/v2.0/devicecode";

    public URL getAuthorizationEndpoint() {
        return this.getEndpointUrlFromRootAndSuffix(this.getAuthorityUrl(), AUTHORIZE_ENDPOINT_SUFFIX);
    }

    public URL getDeviceAuthorizationEndpoint() {
        return this.getEndpointUrlFromRootAndSuffix(this.getAuthorityUrl(), DEVICE_AUTHORIZE_ENDPOINT_SUFFIX);
    }

    public URL getTokenEndpoint() {
        return this.getEndpointUrlFromRootAndSuffix(this.getAuthorityUrl(), TOKEN_ENDPOINT_SUFFIX);
    }

    private URL getEndpointUrlFromRootAndSuffix(@NonNull URL root, @NonNull String endpointSuffix) {
        String methodName = ":getEndpointUrlFromRootAndSuffix";
        try {
            Uri authorityUri = Uri.parse((String)root.toString());
            Uri endpointUri = authorityUri.buildUpon().appendPath(endpointSuffix).build();
            return new URL(endpointUri.toString());
        }
        catch (Exception e) {
            Logger.error(TAG + ":getEndpointUrlFromRootAndSuffix", "Unable to create URL from provided root and suffix.", null);
            Logger.errorPII(TAG + ":getEndpointUrlFromRootAndSuffix", e.getMessage() + " Unable to create URL from provided root and suffix. root = " + root.toString() + " suffix = " + endpointSuffix, e);
            return null;
        }
    }
}

