/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal;

import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.adal.internal.IDeviceCertificate;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.logging.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public enum AuthenticationSettings {
    INSTANCE;

    private static final String TAG;
    private static final int SECRET_RAW_KEY_LENGTH = 32;
    private static final int DEFAULT_EXPIRATION_BUFFER = 300;
    private static final int DEFAULT_READ_CONNECT_TIMEOUT = 30000;
    private final Map<String, byte[]> mBrokerSecretKeys = new HashMap<String, byte[]>(2);
    private AtomicReference<byte[]> mSecretKeyData = new AtomicReference();
    private String mBrokerPackageName = "com.microsoft.windowsintune.companyportal";
    private String mBrokerSignature = "1L4Z9FJCgn5c0VLhyAxC5O9LdlE=";
    private Class<?> mClazzDeviceCertProxy;
    private String mActivityPackageName;
    private boolean mEnableHardwareAcceleration = true;
    private String mSharedPrefPackageName;
    private boolean mUseBroker = false;
    private int mExpirationBuffer = 300;
    private int mConnectTimeOut = 30000;
    private int mReadTimeOut = 30000;

    public byte[] getSecretKeyData() {
        return this.mSecretKeyData.get();
    }

    public Map<String, byte[]> getBrokerSecretKeys() {
        return Collections.unmodifiableMap(this.mBrokerSecretKeys);
    }

    public void setSecretKey(byte[] rawKey) {
        if (rawKey == null || rawKey.length != 32) {
            throw new IllegalArgumentException("rawKey");
        }
        if (Build.VERSION.SDK_INT >= 18) {
            Logger.warn(":setSecretKey", "You're using setSecretKey in a version of android that supports keyStore functionality.  Consider not doing this, as it only exists for devices with an SDK lower than 18");
        }
        this.mSecretKeyData.set(rawKey);
    }

    public void setBrokerSecretKeys(Map<String, byte[]> secretKeys) {
        if (secretKeys == null) {
            throw new IllegalArgumentException("The passed in secret key map is null.");
        }
        if (secretKeys.size() != 2) {
            throw new IllegalArgumentException("Expect two keys are passed in.");
        }
        for (Map.Entry<String, byte[]> entry : secretKeys.entrySet()) {
            if (entry.getValue() == null || entry.getValue().length != 32) {
                throw new IllegalArgumentException("Passed in raw key is null or length is not as expected. ");
            }
            this.mBrokerSecretKeys.put(entry.getKey(), entry.getValue());
        }
    }

    public void clearBrokerSecretKeys() {
        this.mBrokerSecretKeys.clear();
    }

    public void clearLegacySecretKeyConfiguration() {
        Logger.info(TAG + ":clearLegacySecretKeyConfiguration", "Clearing legacy secret key configuration.");
        this.mBrokerSecretKeys.clear();
        this.mSecretKeyData.set(null);
    }

    @VisibleForTesting(otherwise=5)
    public void clearSecretKeysForTestCases() {
        this.clearLegacySecretKeyConfiguration();
    }

    public String getBrokerPackageName() {
        return this.mBrokerPackageName;
    }

    public void setBrokerPackageName(String packageName) {
        if (StringExtensions.isNullOrBlank(packageName)) {
            throw new IllegalArgumentException("packageName cannot be empty or null");
        }
        this.mBrokerPackageName = packageName;
    }

    public String getBrokerSignature() {
        return this.mBrokerSignature;
    }

    public void setBrokerSignature(String brokerSignature) {
        if (StringExtensions.isNullOrBlank(brokerSignature)) {
            throw new IllegalArgumentException("brokerSignature cannot be empty or null");
        }
        this.mBrokerSignature = brokerSignature;
    }

    public void setDeviceCertificateProxyClass(Class clazz) {
        if (!IDeviceCertificate.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("clazz");
        }
        this.mClazzDeviceCertProxy = clazz;
    }

    public Class<?> getDeviceCertificateProxy() {
        return this.mClazzDeviceCertProxy;
    }

    public String getActivityPackageName() {
        return this.mActivityPackageName;
    }

    public void setActivityPackageName(String activityPackageName) {
        if (StringExtensions.isNullOrBlank(activityPackageName)) {
            throw new IllegalArgumentException("activityPackageName cannot be empty or null");
        }
        this.mActivityPackageName = activityPackageName;
    }

    @Deprecated
    public boolean getSkipBroker() {
        return !this.mUseBroker;
    }

    @Deprecated
    public void setSkipBroker(boolean skip) {
        this.mUseBroker = !skip;
    }

    public boolean getUseBroker() {
        return this.mUseBroker;
    }

    public void setUseBroker(boolean useBroker) {
        this.mUseBroker = useBroker;
    }

    public void setSharedPrefPackageName(String packageNameForSharedFile) {
        this.mSharedPrefPackageName = packageNameForSharedFile;
    }

    public String getSharedPrefPackageName() {
        return this.mSharedPrefPackageName;
    }

    public int getExpirationBuffer() {
        return this.mExpirationBuffer;
    }

    public void setExpirationBuffer(int expirationBuffer) {
        this.mExpirationBuffer = expirationBuffer;
    }

    public int getConnectTimeOut() {
        return this.mConnectTimeOut;
    }

    public void setConnectTimeOut(int timeOutMillis) {
        if (timeOutMillis < 0) {
            throw new IllegalArgumentException("Invalid timeOutMillis");
        }
        this.mConnectTimeOut = timeOutMillis;
    }

    public int getReadTimeOut() {
        return this.mReadTimeOut;
    }

    public void setReadTimeOut(int timeOutMillis) {
        if (timeOutMillis < 0) {
            throw new IllegalArgumentException("Invalid timeOutMillis");
        }
        this.mReadTimeOut = timeOutMillis;
    }

    public void setDisableWebViewHardwareAcceleration(boolean enable) {
        this.mEnableHardwareAcceleration = enable;
    }

    public boolean getDisableWebViewHardwareAcceleration() {
        return this.mEnableHardwareAcceleration;
    }

    static {
        TAG = AuthenticationSettings.class.getSimpleName();
    }
}

