/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.util.Base64;
import androidx.annotation.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

public class Browser {
    private static final String DIGEST_SHA_512 = "SHA-512";
    private static final int PRIME_HASH_FACTOR = 92821;
    private final String mPackageName;
    private final Set<String> mSignatureHashes;
    private final String mVersion;
    private final Boolean mIsCustomTabsServiceSupported;

    public Browser(@NonNull PackageInfo packageInfo) {
        this(packageInfo.packageName, Browser.generateSignatureHashes(packageInfo.signatures), packageInfo.versionName, false);
    }

    public Browser(@NonNull PackageInfo packageInfo, Boolean isCustomTabsServiceSupported) {
        this(packageInfo.packageName, Browser.generateSignatureHashes(packageInfo.signatures), packageInfo.versionName, isCustomTabsServiceSupported);
    }

    public Browser(@NonNull String packageName, @NonNull Set<String> signatureHashes, @NonNull String version, boolean isCustomTabsServiceSupported) {
        this.mPackageName = packageName;
        this.mSignatureHashes = signatureHashes;
        this.mVersion = version;
        this.mIsCustomTabsServiceSupported = isCustomTabsServiceSupported;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public Set<String> getSignatureHashes() {
        return this.mSignatureHashes;
    }

    public String getVersion() {
        return this.mVersion;
    }

    @NonNull
    public static Set<String> generateSignatureHashes(@NonNull Signature[] signatures) {
        HashSet<String> signatureHashes = new HashSet<String>();
        for (Signature signature : signatures) {
            try {
                MessageDigest digest = MessageDigest.getInstance(DIGEST_SHA_512);
                byte[] hashBytes = digest.digest(signature.toByteArray());
                signatureHashes.add(Base64.encodeToString((byte[])hashBytes, (int)10));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Platform does not supportSHA-512 hashing");
            }
        }
        return signatureHashes;
    }

    public boolean isCustomTabsServiceSupported() {
        return this.mIsCustomTabsServiceSupported;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Browser)) {
            return false;
        }
        Browser other = (Browser)obj;
        return this.mPackageName.equals(other.getPackageName()) && this.mVersion.equals(other.getVersion()) && this.mSignatureHashes.equals(other.getSignatureHashes());
    }

    public int hashCode() {
        int hash = this.mPackageName.hashCode();
        hash = 92821 * hash + this.mVersion.hashCode();
        hash = 92821 * hash + (this.mIsCustomTabsServiceSupported != false ? 1 : 0);
        for (String signatureHash : this.mSignatureHashes) {
            hash = 92821 * hash + signatureHash.hashCode();
        }
        return hash;
    }
}

