/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.platform.Algorithm;
import com.microsoft.identity.common.internal.platform.CryptoSuite;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.microsoft.identity.common.internal.platform.SymmetricAlgorithm;
import java.security.KeyStore;

public enum SymmetricCipher implements CryptoSuite
{
    AES_GCM_NONE_HMACSHA256(SymmetricAlgorithm.Builder.of("AES/GCM/NoPadding"), "HmacSHA256", 256){

        @Override
        public KeyGenParameterSpec.Builder decorateKeyGenerator(@NonNull KeyGenParameterSpec.Builder spec) {
            return spec.setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(this.keySize());
        }
    };

    SymmetricAlgorithm mValue;
    String mMacString;
    int mKeySize;

    private SymmetricCipher(SymmetricAlgorithm value, String macValue, int keySize) {
        this.mValue = value;
        this.mMacString = macValue;
        this.mKeySize = keySize;
    }

    @Override
    public Algorithm cipher() {
        return this.mValue;
    }

    @Override
    public String macName() {
        return this.mMacString;
    }

    @Override
    public boolean isAsymmetric() {
        return false;
    }

    @Override
    public Class<? extends KeyStore.Entry> keyClass() {
        return KeyStore.SecretKeyEntry.class;
    }

    @Override
    public int keySize() {
        return this.mKeySize;
    }

    @Override
    public IDevicePopManager.SigningAlgorithm signingAlgorithm() {
        return null;
    }

    @NonNull
    public abstract KeyGenParameterSpec.Builder decorateKeyGenerator(@NonNull KeyGenParameterSpec.Builder var1);
}

