/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.platform.AsymmetricKeyAccessor;
import com.microsoft.identity.common.internal.platform.CryptoSuite;
import com.microsoft.identity.common.internal.platform.DeviceKeyManager;
import com.microsoft.identity.common.internal.platform.DevicePopManager;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.microsoft.identity.common.internal.platform.KeyAccessor;
import com.microsoft.identity.common.internal.platform.RawKeyAccessor;
import com.microsoft.identity.common.internal.platform.SecretKeyAccessor;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import com.microsoft.identity.common.internal.platform.SymmetricCipher;
import com.microsoft.identity.common.internal.util.Supplier;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.text.ParseException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class KeyStoreAccessor {
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int KEY_PURPOSES = 7;

    public static KeyAccessor forAlias(@NonNull Context context, @NonNull String alias, @NonNull CryptoSuite suite) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException {
        DevicePopManager popManager = new DevicePopManager(alias);
        if (suite.cipher() instanceof IDevicePopManager.Cipher) {
            if (!popManager.asymmetricKeyExists()) {
                popManager.generateAsymmetricKey(context);
            }
            return KeyStoreAccessor.getKeyAccessor((IDevicePopManager.Cipher)suite.cipher(), suite.signingAlgorithm(), popManager);
        }
        KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
        DeviceKeyManager keyManager = new DeviceKeyManager(instance, alias, KeyStoreAccessor.symmetricThumbprint(alias, instance));
        return new SecretKeyAccessor(keyManager, suite){

            @Override
            public byte[] sign(byte[] text) throws ClientException {
                throw new UnsupportedOperationException("This key instance does not support signing");
            }

            @Override
            public boolean verify(byte[] text, byte[] signature) throws ClientException {
                throw new UnsupportedOperationException("This key instance does not support verification");
            }
        };
    }

    private static final KeyAccessor getKeyAccessor(final @NonNull IDevicePopManager.Cipher cipher, final @NonNull IDevicePopManager.SigningAlgorithm signingAlg, final @NonNull IDevicePopManager popManager) {
        return new AsymmetricKeyAccessor(){

            @Override
            public String getPublicKey(IDevicePopManager.PublicKeyFormat format) throws ClientException {
                return popManager.getPublicKey(format);
            }

            @Override
            public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
                return popManager.getPublicKey();
            }

            @Override
            public byte[] encrypt(byte[] plaintext) throws ClientException {
                return popManager.encrypt(cipher, plaintext);
            }

            @Override
            public byte[] decrypt(byte[] ciphertext) throws ClientException {
                return popManager.decrypt(cipher, ciphertext);
            }

            @Override
            public byte[] sign(byte[] text) throws ClientException {
                return popManager.sign(signingAlg, text);
            }

            @Override
            public boolean verify(byte[] text, byte[] signature) throws ClientException {
                return popManager.verify(signingAlg, text, signature);
            }

            @Override
            public byte[] getThumprint() throws ClientException {
                return popManager.getAsymmetricKeyThumbprint().getBytes(UTF8);
            }

            @Override
            public Certificate[] getCertificateChain() throws ClientException {
                return popManager.getCertificateChain();
            }

            @Override
            public SecureHardwareState getSecureHardwareState() throws ClientException {
                return popManager.getSecureHardwareState();
            }
        };
    }

    public static KeyAccessor newInstance(@NonNull Context context, @NonNull IDevicePopManager.Cipher cipher, @NonNull IDevicePopManager.SigningAlgorithm signingAlg) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException {
        String alias = UUID.randomUUID().toString();
        DevicePopManager popManager = new DevicePopManager(alias);
        popManager.generateAsymmetricKey(context);
        return KeyStoreAccessor.getKeyAccessor(cipher, signingAlg, popManager);
    }

    public static KeyAccessor newInstance(@NonNull SymmetricCipher cipher, @NonNull boolean needRawAccess) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException, NoSuchProviderException, InvalidAlgorithmParameterException {
        String alias = UUID.randomUUID().toString();
        if (Build.VERSION.SDK_INT >= 23 && !needRawAccess) {
            KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
            instance.load(null);
            String[] params = cipher.cipher().name().split("/");
            KeyGenerator generator = KeyGenerator.getInstance(params[0], ANDROID_KEYSTORE);
            KeyGenParameterSpec spec = null;
            try {
                if (Build.VERSION.SDK_INT >= 28) {
                    spec = new KeyGenParameterSpec.Builder(alias, 7).setIsStrongBoxBacked(true).setKeySize(cipher.keySize()).setBlockModes(new String[]{params[1]}).setEncryptionPaddings(new String[]{params[2]}).setKeySize(cipher.keySize()).build();
                }
                generator.init((AlgorithmParameterSpec)spec);
                generator.generateKey();
            }
            catch (ProviderException e) {
                if (e.getClass().getSimpleName().equals("StrongBoxUnavailableException")) {
                    spec = null;
                }
                throw e;
            }
            if (spec == null) {
                spec = new KeyGenParameterSpec.Builder(alias, 7).setKeySize(cipher.keySize()).setBlockModes(new String[]{params[1]}).setEncryptionPaddings(new String[]{params[2]}).setKeySize(cipher.keySize()).build();
                generator.init((AlgorithmParameterSpec)spec);
                generator.generateKey();
            }
            DeviceKeyManager keyManager = new DeviceKeyManager(instance, alias, KeyStoreAccessor.symmetricThumbprint(alias, instance));
            return new SecretKeyAccessor(keyManager, (CryptoSuite)cipher){

                @Override
                public byte[] sign(byte[] text) throws ClientException {
                    throw new UnsupportedOperationException("This key instance does not support signing");
                }

                @Override
                public boolean verify(byte[] text, byte[] signature) throws ClientException {
                    throw new UnsupportedOperationException("This key instance does not support verification");
                }
            };
        }
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(cipher.mKeySize);
        byte[] key = generator.generateKey().getEncoded();
        return new RawKeyAccessor(cipher, key);
    }

    public static Supplier<byte[]> symmetricThumbprint(final @NonNull String alias, final @NonNull KeyStore instance) {
        return new Supplier<byte[]>(){

            @Override
            @Nullable
            public byte[] get() {
                try {
                    KeyStore.Entry entry = instance.getEntry(alias, null);
                    if (entry instanceof KeyStore.SecretKeyEntry) {
                        SecretKey key = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
                        MessageDigest digest = MessageDigest.getInstance("SHA256");
                        return digest.digest(cipher.doFinal((key.getAlgorithm() + cipher.getBlockSize() + cipher.getParameters()).getBytes(UTF8)));
                    }
                    return null;
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    Logger.error("KeyAccessor:newInstance", null, "Exception while getting key entry", e);
                    return null;
                }
            }
        };
    }

    public static KeyAccessor importSymmetricKey(@NonNull Context context, @NonNull SymmetricCipher cipher, @NonNull String keyAlias, @NonNull String key_jwe, @NonNull KeyAccessor stk_accessor) throws ParseException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException {
        throw new UnsupportedOperationException("This operation is not yet supported");
    }
}

