/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.platform.Algorithm;
import com.microsoft.identity.common.internal.platform.AsymmetricAlgorithm;
import com.microsoft.identity.common.internal.platform.SecureHardwareState;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Date;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public interface IDevicePopManager {
    public static final String MGF_1 = "MGF1";
    public static final String SHA_1 = "SHA-1";

    public boolean asymmetricKeyExists();

    public boolean asymmetricKeyExists(String var1);

    public String getAsymmetricKeyThumbprint() throws ClientException;

    public void generateAsymmetricKey(Context var1, TaskCompletedCallbackWithError<String, ClientException> var2);

    public String generateAsymmetricKey(Context var1) throws ClientException;

    public Date getAsymmetricKeyCreationDate() throws ClientException;

    public boolean clearAsymmetricKey();

    public String getRequestConfirmation() throws ClientException;

    public void getRequestConfirmation(TaskCompletedCallbackWithError<String, ClientException> var1);

    public String sign(SigningAlgorithm var1, String var2) throws ClientException;

    public byte[] sign(@NonNull SigningAlgorithm var1, byte[] var2) throws ClientException;

    public boolean verify(SigningAlgorithm var1, String var2, String var3);

    public boolean verify(@NonNull SigningAlgorithm var1, byte[] var2, byte[] var3);

    public String encrypt(Cipher var1, String var2) throws ClientException;

    public byte[] encrypt(@NonNull Cipher var1, @NonNull byte[] var2) throws ClientException;

    public String decrypt(Cipher var1, String var2) throws ClientException;

    public byte[] decrypt(@NonNull Cipher var1, byte[] var2) throws ClientException;

    public SecureHardwareState getSecureHardwareState() throws ClientException;

    public String getPublicKey(PublicKeyFormat var1) throws ClientException;

    public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException;

    public Certificate[] getCertificateChain() throws ClientException;

    public String mintSignedAccessToken(String var1, long var2, URL var4, String var5, String var6) throws ClientException;

    public String mintSignedAccessToken(String var1, long var2, URL var4, String var5, String var6, String var7) throws ClientException;

    public String mintSignedHttpRequest(String var1, long var2, URL var4, String var5, String var6) throws ClientException;

    public static enum Cipher implements AsymmetricAlgorithm
    {
        RSA_ECB_PKCS1_PADDING("RSA/ECB/PKCS1Padding"),
        RSA_NONE_OAEPWithSHA_1AndMGF1Padding("RSA/NONE/OAEPWithSHA-1AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec(IDevicePopManager.SHA_1, IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        }
        ,
        RSA_ECB_OAEPWithSHA_1AndMGF1Padding("RSA/ECB/OAEPWithSHA-1AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec(IDevicePopManager.SHA_1, IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        }
        ,
        RSA_ECB_OAEPWithSHA_256AndMGF1Padding("RSA/ECB/OAEPWithSHA-256AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec("SHA-256", IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        }
        ,
        RSA_ECB_OAEPWithSHA_384AndMGF1Padding("RSA/ECB/OAEPWithSHA-384AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec("SHA-384", IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        }
        ,
        RSA_ECB_OAEPWithSHA_512AndMGF1Padding("RSA/ECB/OAEPWithSHA-512AndMGF1Padding"){

            @Override
            public AlgorithmParameterSpec getParameters() {
                return new OAEPParameterSpec("SHA-512", IDevicePopManager.MGF_1, new MGF1ParameterSpec(IDevicePopManager.SHA_1), PSource.PSpecified.DEFAULT);
            }
        };

        private final String mValue;

        private Cipher(String value) {
            this.mValue = value;
        }

        @NonNull
        public String toString() {
            return this.mValue;
        }

        public Algorithm cipherName() {
            return AsymmetricAlgorithm.Builder.of(this.mValue);
        }

        public AlgorithmParameterSpec getParameters() {
            return null;
        }

        public boolean supportsShr() {
            return true;
        }
    }

    public static enum SigningAlgorithm {
        MD5_WITH_RSA("MD5withRSA"),
        NONE_WITH_RSA("NONEwithRSA"),
        SHA_1_WITH_RSA("SHA1withRSA"),
        SHA_256_WITH_RSA("SHA256withRSA"),
        SHA_256_WITH_RSA_PSS("SHA256withRSA/PSS"),
        SHA_384_WITH_RSA("SHA384withRSA"),
        SHA_384_WITH_RSA_PSS("SHA384withRSA/PSS"),
        SHA_512_WITH_RSA("SHA512withRSA"),
        SHA_512_WITH_RSA_PSS("SHA512withRSA/PSS");

        private final String mValue;

        private SigningAlgorithm(String value) {
            this.mValue = value;
        }

        @NonNull
        public String toString() {
            return this.mValue;
        }
    }

    public static enum PublicKeyFormat {
        X_509_SubjectPublicKeyInfo_ASN_1,
        JWK;

    }
}

