/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class HttpResponse {
    private final int mStatusCode;
    private final String mResponseBody;
    private final Map<String, List<String>> mResponseHeaders;
    private final Date mDate;

    public HttpResponse(int statusCode, String responseBody, Map<String, List<String>> responseHeaders) {
        this(null, statusCode, responseBody, responseHeaders);
    }

    public HttpResponse(@Nullable Date date, int statusCode, @NonNull String responseBody, @NonNull Map<String, List<String>> headerFields) {
        this.mDate = date;
        this.mStatusCode = statusCode;
        this.mResponseBody = responseBody;
        this.mResponseHeaders = headerFields;
    }

    public Date getDate() {
        return this.mDate;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getBody() {
        return this.mResponseBody;
    }

    public Map<String, List<String>> getHeaders() {
        return this.mResponseHeaders;
    }

    public String toString() {
        return "HttpResponse{mStatusCode=" + this.mStatusCode + ", mResponseBody='" + this.mResponseBody + '\'' + ", mResponseHeaders=" + this.mResponseHeaders + '}';
    }
}

