/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.ParcelableUtil;
import java.util.List;

public class ContentProviderStrategy
implements IIpcStrategy {
    private static final String TAG = ContentProviderStrategy.class.getName();
    private final Context mContext;

    public ContentProviderStrategy(Context context) {
        this.mContext = context;
    }

    @Override
    @Nullable
    public Bundle communicateToBroker(@NonNull BrokerOperationBundle brokerOperationBundle) throws BrokerCommunicationException {
        Cursor cursor;
        String methodName = brokerOperationBundle.getOperation().name();
        Uri uri = this.getContentProviderURI(brokerOperationBundle.getTargetBrokerAppPackageName(), brokerOperationBundle.getContentProviderPath());
        Logger.info(TAG + methodName, "Request to BrokerContentProvider for uri path " + brokerOperationBundle.getContentProviderPath());
        String marshalledRequestString = null;
        Bundle requestBundle = brokerOperationBundle.getBundle();
        if (requestBundle != null) {
            byte[] marshalledBytes = ParcelableUtil.marshall((Parcelable)requestBundle);
            marshalledRequestString = Base64.encodeToString((byte[])marshalledBytes, (int)0);
        }
        if ((cursor = this.mContext.getContentResolver().query(uri, null, marshalledRequestString, null, null)) != null) {
            Bundle resultBundle = cursor.getExtras();
            cursor.close();
            if (resultBundle == null) {
                String message = "Received an empty bundle. This means the operation is not supported on the other side. If you're using a newer feature, please bump the minimum protocol version.";
                Logger.error(TAG + methodName, "Received an empty bundle. This means the operation is not supported on the other side. If you're using a newer feature, please bump the minimum protocol version.", null);
                throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, this.getType(), "Received an empty bundle. This means the operation is not supported on the other side. If you're using a newer feature, please bump the minimum protocol version.", null);
            }
            Logger.info(TAG + methodName, "Received successful result from Broker Content Provider.");
            return resultBundle;
        }
        String message = "Failed to get result from Broker Content Provider, cursor is null";
        Logger.error(TAG + methodName, "Failed to get result from Broker Content Provider, cursor is null", null);
        throw new BrokerCommunicationException(BrokerCommunicationException.Category.CONNECTION_ERROR, this.getType(), "Failed to get result from Broker Content Provider, cursor is null", null);
    }

    @Override
    public IIpcStrategy.Type getType() {
        return IIpcStrategy.Type.CONTENT_PROVIDER;
    }

    private Uri getContentProviderURI(@NonNull String targetedBrokerPackageName, @NonNull String path) {
        String authority = this.getContentProviderAuthority(targetedBrokerPackageName);
        return Uri.parse((String)("content://" + authority + path));
    }

    private String getContentProviderAuthority(@NonNull String targetedBrokerPackageName) {
        return targetedBrokerPackageName + "." + "microsoft.identity.broker";
    }

    public boolean isBrokerContentProviderAvailable(@NonNull String targetedBrokerPackageName) {
        String methodName = ":isBrokerContentProviderAvailable";
        String contentProviderAuthority = this.getContentProviderAuthority(targetedBrokerPackageName);
        List providers = this.mContext.getPackageManager().queryContentProviders(null, 0, 0);
        if (providers == null) {
            Logger.error(TAG + ":isBrokerContentProviderAvailable", "Content Provider not found.", null);
            return false;
        }
        for (ProviderInfo providerInfo : providers) {
            if (providerInfo.authority == null || !providerInfo.authority.equals(contentProviderAuthority)) continue;
            return true;
        }
        return false;
    }
}

