/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.net;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.adal.internal.PowerManagerWrapper;
import com.microsoft.identity.common.adal.internal.net.IConnectionService;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;

public class DefaultConnectionService
implements IConnectionService {
    private final Context mConnectionContext;
    private static boolean connectionAvailable = false;
    private static ConnectivityManager.NetworkCallback networkCallback;
    private static final Object lock;

    public DefaultConnectionService(Context ctx) {
        this.mConnectionContext = ctx;
        if (Build.VERSION.SDK_INT >= 21) {
            this.registerNetworkCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=21)
    public void registerNetworkCallback() {
        Object object = lock;
        synchronized (object) {
            if (null == networkCallback) {
                try {
                    ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
                    NetworkRequest.Builder builder = new NetworkRequest.Builder().addCapability(12);
                    NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
                    connectionAvailable = null != activeNetwork && activeNetwork.isConnectedOrConnecting();
                    networkCallback = new ConnectivityManager.NetworkCallback(){

                        public void onAvailable(@NonNull Network network) {
                            connectionAvailable = true;
                        }

                        public void onLost(@NonNull Network network) {
                            connectionAvailable = false;
                        }
                    };
                    connectivityManager.registerNetworkCallback(builder.build(), networkCallback);
                }
                catch (Exception e) {
                    connectionAvailable = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=21)
    public void unregisterNetworkCallback() {
        Object object = lock;
        synchronized (object) {
            if (networkCallback != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
                connectivityManager.unregisterNetworkCallback(networkCallback);
                networkCallback = null;
            }
        }
    }

    @Override
    public boolean isConnectionAvailable() {
        if (Build.VERSION.SDK_INT < 21) {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            connectionAvailable = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        }
        Telemetry.emit((BaseEvent)new BaseEvent().put("Microsoft.MSAL.network_connection", String.valueOf(connectionAvailable)));
        return connectionAvailable;
    }

    @TargetApi(value=23)
    public boolean isNetworkDisabledFromOptimizations() {
        PowerManagerWrapper powerManagerWrapper;
        if (Build.VERSION.SDK_INT >= 23 && (powerManagerWrapper = PowerManagerWrapper.getInstance()).isDeviceIdleMode(this.mConnectionContext) && !powerManagerWrapper.isIgnoringBatteryOptimizations(this.mConnectionContext)) {
            Telemetry.emit((BaseEvent)new BaseEvent().put("Microsoft.MSAL.power_optimization", String.valueOf(true)));
            return true;
        }
        Telemetry.emit((BaseEvent)new BaseEvent().put("Microsoft.MSAL.power_optimization", String.valueOf(false)));
        return false;
    }

    static {
        lock = new Object();
    }
}

