/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.BrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.webview.EmbeddedWebViewAuthorizationStrategy;

public class AuthorizationStrategyFactory<GenericAuthorizationStrategy extends AuthorizationStrategy> {
    private static final String TAG = AuthorizationStrategyFactory.class.getSimpleName();
    private static AuthorizationStrategyFactory sInstance = null;

    public static AuthorizationStrategyFactory getInstance() {
        if (sInstance == null) {
            sInstance = new AuthorizationStrategyFactory();
        }
        return sInstance;
    }

    public GenericAuthorizationStrategy getAuthorizationStrategy(@NonNull InteractiveTokenCommandParameters parameters) {
        Context context = parameters.getAndroidApplicationContext();
        AuthorizationAgent validatedAuthorizationAgent = this.validAuthorizationAgent(parameters.getAuthorizationAgent(), context);
        boolean isBrokerRequest = parameters instanceof BrokerInteractiveTokenCommandParameters;
        if (validatedAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            Logger.info(TAG, "Use webView for authorization.");
            return (GenericAuthorizationStrategy)new EmbeddedWebViewAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment());
        }
        if (validatedAuthorizationAgent == AuthorizationAgent.DEFAULT) {
            block4: {
                try {
                    BrowserSelector.select(context, parameters.getBrowserSafeList());
                }
                catch (ClientException exception) {
                    Logger.info(TAG, "No supported browser available found. Fallback to the webView authorization agent.");
                    if (!"No available browser installed on the device.".equalsIgnoreCase(exception.getErrorCode())) break block4;
                    return (GenericAuthorizationStrategy)new EmbeddedWebViewAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment());
                }
            }
            Logger.info(TAG, "Use browser for authorization.");
            BrowserAuthorizationStrategy browserAuthorizationStrategy = new BrowserAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment(), isBrokerRequest);
            browserAuthorizationStrategy.setBrowserSafeList(parameters.getBrowserSafeList());
            return (GenericAuthorizationStrategy)browserAuthorizationStrategy;
        }
        Logger.info(TAG, "Use browser for authorization.");
        BrowserAuthorizationStrategy browserAuthorizationStrategy = new BrowserAuthorizationStrategy(context, parameters.getActivity(), parameters.getFragment(), isBrokerRequest);
        browserAuthorizationStrategy.setBrowserSafeList(parameters.getBrowserSafeList());
        return (GenericAuthorizationStrategy)browserAuthorizationStrategy;
    }

    private AuthorizationAgent validAuthorizationAgent(AuthorizationAgent agent, Context context) {
        if (agent != AuthorizationAgent.WEBVIEW && BrowserSelector.getAllBrowsers(context).isEmpty()) {
            Logger.verbose(TAG, "Unable to use browser to do the authorization because No available browser installed on the device. Use embedded webView instead.");
            return AuthorizationAgent.WEBVIEW;
        }
        return agent;
    }
}

