/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.internal.util.GzipUtil;
import com.microsoft.identity.common.internal.util.HeaderSerializationUtil;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;

public class MsalBrokerResultAdapter
implements IBrokerResultAdapter {
    private static final String TAG = MsalBrokerResultAdapter.class.getName();

    @Override
    public Bundle bundleFromAuthenticationResult(@NonNull ILocalAuthenticationResult authenticationResult, @Nullable String negotiatedBrokerProtocolVersion) {
        Logger.info(TAG, "Constructing result bundle from ILocalAuthenticationResult");
        IAccountRecord accountRecord = authenticationResult.getAccountRecord();
        AccessTokenRecord accessTokenRecord = authenticationResult.getAccessTokenRecord();
        BrokerResult brokerResult = new BrokerResult.Builder().tenantProfileRecords(authenticationResult.getCacheRecordWithTenantProfileData()).accessToken(authenticationResult.getAccessToken()).idToken(authenticationResult.getIdToken()).refreshToken(authenticationResult.getRefreshToken()).homeAccountId(accountRecord.getHomeAccountId()).localAccountId(accountRecord.getLocalAccountId()).userName(accountRecord.getUsername()).tokenType(accessTokenRecord.getAccessTokenType()).clientId(accessTokenRecord.getClientId()).familyId(authenticationResult.getFamilyId()).scope(accessTokenRecord.getTarget()).clientInfo(accountRecord.getClientInfo()).authority(accessTokenRecord.getAuthority()).environment(accessTokenRecord.getEnvironment()).tenantId(authenticationResult.getTenantId()).expiresOn(Long.parseLong(accessTokenRecord.getExpiresOn())).extendedExpiresOn(Long.parseLong(accessTokenRecord.getExtendedExpiresOn())).cachedAt(Long.parseLong(accessTokenRecord.getCachedAt())).speRing(authenticationResult.getSpeRing()).refreshTokenAge(authenticationResult.getRefreshTokenAge()).success(true).servicedFromCache(authenticationResult.isServicedFromCache()).build();
        Bundle resultBundle = this.bundleFromBrokerResult(brokerResult, negotiatedBrokerProtocolVersion);
        resultBundle.putBoolean("broker_request_v2_success", true);
        return resultBundle;
    }

    @Override
    public Bundle bundleFromBaseException(@NonNull BaseException exception, @Nullable String negotiatedBrokerProtocolVersion) {
        Logger.info(TAG, "Constructing result bundle from BaseException");
        BrokerResult.Builder builder = new BrokerResult.Builder().success(false).errorCode(exception.getErrorCode()).errorMessage(exception.getMessage()).exceptionType(exception.getExceptionName()).correlationId(exception.getCorrelationId()).cliTelemErrorCode(exception.getCliTelemErrorCode()).cliTelemSubErrorCode(exception.getCliTelemSubErrorCode()).speRing(exception.getSpeRing()).refreshTokenAge(exception.getRefreshTokenAge());
        if (exception instanceof ServiceException) {
            builder.oauthSubErrorCode(((ServiceException)exception).getOAuthSubErrorCode()).httpStatusCode(((ServiceException)exception).getHttpStatusCode()).httpResponseHeaders(HeaderSerializationUtil.toJson(((ServiceException)exception).getHttpResponseHeaders())).httpResponseBody(MsalBrokerRequestAdapter.sRequestAdapterGsonInstance.toJson(((ServiceException)exception).getHttpResponseBody()));
        }
        if (exception instanceof IntuneAppProtectionPolicyRequiredException) {
            builder.userName(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUpn()).localAccountId(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUserId()).authority(((IntuneAppProtectionPolicyRequiredException)exception).getAuthorityUrl()).tenantId(((IntuneAppProtectionPolicyRequiredException)exception).getTenantId());
        }
        Bundle resultBundle = this.bundleFromBrokerResult(builder.build(), negotiatedBrokerProtocolVersion);
        resultBundle.putBoolean("broker_request_v2_success", false);
        return resultBundle;
    }

    @Override
    public ILocalAuthenticationResult authenticationResultFromBundle(@NonNull Bundle resultBundle) {
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        if (brokerResult == null) {
            Logger.error(TAG, "Broker Result not returned from Broker, ", null);
            return null;
        }
        Logger.info(TAG, "Broker Result returned from Bundle, constructing authentication result");
        List<ICacheRecord> tenantProfileCacheRecords = brokerResult.getTenantProfileData();
        LocalAuthenticationResult authenticationResult = new LocalAuthenticationResult(tenantProfileCacheRecords.get(0), tenantProfileCacheRecords, SdkType.MSAL, brokerResult.isServicedFromCache());
        return authenticationResult;
    }

    @Override
    public BaseException getBaseExceptionFromBundle(@NonNull Bundle resultBundle) {
        Logger.info(TAG, "Constructing exception from result bundle");
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        if (brokerResult == null) {
            Logger.error(TAG, "Broker Result not returned from Broker", null);
            return new BaseException("unknown_error", "Broker Result not returned from Broker");
        }
        String exceptionType = brokerResult.getExceptionType();
        if (!TextUtils.isEmpty((CharSequence)exceptionType)) {
            return this.getBaseExceptionFromExceptionType(exceptionType, brokerResult);
        }
        Logger.info(TAG, "Exception type is not returned from the broker, using error codes to transform to the right exception");
        return this.getBaseExceptionFromErrorCodes(brokerResult);
    }

    public Bundle bundleFromBrokerResult(@NonNull BrokerResult brokerResult, @NonNull String negotiatedBrokerProtocolVersion) {
        Bundle resultBundle = new Bundle();
        String brokerResultString = MsalBrokerRequestAdapter.sRequestAdapterGsonInstance.toJson((Object)brokerResult, BrokerResult.class);
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads(negotiatedBrokerProtocolVersion)) {
            try {
                byte[] compressedBytes = GzipUtil.compressString(brokerResultString);
                Logger.info(TAG, "Broker Result, raw payload size:" + brokerResultString.getBytes().length + " ,compressed bytes " + compressedBytes.length);
                resultBundle.putByteArray("broker_result_v2_compressed", compressedBytes);
            }
            catch (IOException e) {
                Logger.error(TAG, "Failed to compress Broker Result, sending as jsonString ", e);
                resultBundle.putString("broker_result_v2", brokerResultString);
            }
        } else {
            Logger.info(TAG, "Broker protocol version: " + negotiatedBrokerProtocolVersion + " lower than compression changes, sending as string");
            resultBundle.putString("broker_result_v2", brokerResultString);
        }
        return resultBundle;
    }

    @Nullable
    public BrokerResult brokerResultFromBundle(Bundle resultBundle) {
        BrokerResult brokerResult = null;
        if (resultBundle.containsKey("broker_result_v2_compressed")) {
            byte[] compressedBytes = resultBundle.getByteArray("broker_result_v2_compressed");
            try {
                String brokerResultString = GzipUtil.decompressBytesToString(compressedBytes);
                brokerResult = JsonExtensions.getBrokerResultFromJsonString(brokerResultString);
            }
            catch (IOException e) {
                Logger.error(TAG, "Failed to decompress broker result :", e);
            }
        } else {
            brokerResult = JsonExtensions.getBrokerResultFromJsonString(resultBundle.getString("broker_result_v2"));
        }
        return brokerResult;
    }

    private BaseException getBaseExceptionFromExceptionType(@NonNull String exceptionType, @NonNull BrokerResult brokerResult) {
        BaseException baseException = null;
        Logger.warn(TAG, "Received a " + exceptionType + " from Broker : " + brokerResult.getErrorCode());
        if (exceptionType.equalsIgnoreCase(UiRequiredException.sName)) {
            baseException = new UiRequiredException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else if (exceptionType.equalsIgnoreCase(ServiceException.sName)) {
            baseException = this.getServiceException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase(IntuneAppProtectionPolicyRequiredException.sName)) {
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase(UserCancelException.sName)) {
            baseException = new UserCancelException();
        } else if (exceptionType.equalsIgnoreCase(ClientException.sName)) {
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else if (exceptionType.equalsIgnoreCase(ArgumentException.sName)) {
            baseException = new ArgumentException("brokerTokenRequest", brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else {
            Logger.warn(TAG, " Exception type is unknown : " + exceptionType + brokerResult.getErrorCode() + ", defaulting to Client Exception ");
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    private BaseException getBaseExceptionFromErrorCodes(@NonNull BrokerResult brokerResult) {
        BaseException baseException;
        String errorCode = brokerResult.getErrorCode();
        if ("interaction_required".equalsIgnoreCase(errorCode) || "invalid_grant".equalsIgnoreCase(errorCode) || "Broker refresh token is invalid".equalsIgnoreCase(errorCode) || "no_tokens_found".equalsIgnoreCase(errorCode)) {
            Logger.warn(TAG, "Received a UIRequired exception from Broker : " + errorCode);
            baseException = new UiRequiredException(errorCode, brokerResult.getErrorMessage());
        } else if ("unauthorized_client".equalsIgnoreCase(errorCode) && "protection_policy_required".equalsIgnoreCase(brokerResult.getSubErrorCode())) {
            Logger.warn(TAG, "Received a IntuneAppProtectionPolicyRequiredException exception from Broker : " + errorCode);
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if ("User cancelled".equalsIgnoreCase(errorCode)) {
            Logger.warn(TAG, "Received a User cancelled exception from Broker : " + errorCode);
            baseException = new UserCancelException();
        } else if ("illegal_argument_exception".equalsIgnoreCase(errorCode)) {
            Logger.warn(TAG, "Received a Argument exception from Broker : " + errorCode);
            baseException = new ArgumentException("brokerTokenRequest", errorCode, brokerResult.getErrorMessage());
        } else if (!TextUtils.isEmpty((CharSequence)brokerResult.getHttpResponseHeaders()) || !TextUtils.isEmpty((CharSequence)brokerResult.getHttpResponseBody())) {
            Logger.warn(TAG, "Received a Service exception from Broker : " + errorCode);
            baseException = this.getServiceException(brokerResult);
        } else {
            Logger.warn(TAG, "Received a Client exception from Broker : " + errorCode);
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    private IntuneAppProtectionPolicyRequiredException getIntuneProtectionRequiredException(@NonNull BrokerResult brokerResult) {
        IntuneAppProtectionPolicyRequiredException exception = new IntuneAppProtectionPolicyRequiredException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        exception.setTenantId(brokerResult.getTenantId());
        exception.setAuthorityUrl(brokerResult.getAuthority());
        exception.setAccountUserId(brokerResult.getLocalAccountId());
        exception.setAccountUpn(brokerResult.getUserName());
        exception.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        try {
            exception.setHttpResponseBody(HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()));
            if (brokerResult.getHttpResponseHeaders() != null) {
                exception.setHttpResponseHeaders(HeaderSerializationUtil.fromJson(brokerResult.getHttpResponseHeaders()));
            }
        }
        catch (JSONException e) {
            Logger.warn(TAG, "Unable to parse json");
        }
        return exception;
    }

    private ServiceException getServiceException(@NonNull BrokerResult brokerResult) {
        ServiceException serviceException = new ServiceException(brokerResult.getErrorCode(), brokerResult.getErrorMessage(), null);
        serviceException.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        try {
            serviceException.setHttpResponseBody(brokerResult.getHttpResponseBody() != null ? HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()) : null);
            serviceException.setHttpResponseHeaders(brokerResult.getHttpResponseHeaders() != null ? HeaderSerializationUtil.fromJson(brokerResult.getHttpResponseHeaders()) : null);
        }
        catch (JSONException e) {
            Logger.warn(TAG, "Unable to parse json");
        }
        return serviceException;
    }

    public String verifyHelloFromResultBundle(Bundle bundle) throws ClientException {
        String methodName = ":verifyHelloFromResultBundle";
        if (bundle == null) {
            Logger.warn(TAG + ":verifyHelloFromResultBundle", "The hello result bundle is null.");
            throw new ClientException("unsupported_broker_version", "Please update Intune Company Portal and/or Microsoft Authenticator to the latest version.");
        }
        if (!StringUtil.isEmpty(bundle.getString("common.broker.protocol.version.name"))) {
            String negotiatedBrokerProtocolVersion = bundle.getString("common.broker.protocol.version.name");
            Logger.info(TAG + ":verifyHelloFromResultBundle", "Able to establish the connect, the broker protocol version in common is [" + negotiatedBrokerProtocolVersion + "]");
            return negotiatedBrokerProtocolVersion;
        }
        if (!StringUtil.isEmpty(bundle.getString("error")) && !StringUtil.isEmpty(bundle.getString("error_description"))) {
            String errorCode = bundle.getString("error");
            String errorMessage = bundle.getString("error_description");
            throw new ClientException(errorCode, errorMessage);
        }
        if (bundle.get("broker_result_v2") != null && bundle.get("broker_result_v2") instanceof BrokerResult) {
            BrokerResult brokerResult = (BrokerResult)bundle.get("broker_result_v2");
            throw new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        Logger.warn(TAG + ":verifyHelloFromResultBundle", "The result bundle is not in a recognizable format.");
        throw new ClientException("unsupported_broker_version", "Please update Intune Company Portal and/or Microsoft Authenticator to the latest version.");
    }

    public AcquireTokenResult getAcquireTokenResultFromResultBundle(@NonNull Bundle resultBundle) throws BaseException {
        MsalBrokerResultAdapter resultAdapter = new MsalBrokerResultAdapter();
        if (resultBundle.getBoolean("broker_request_v2_success")) {
            AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
            acquireTokenResult.setLocalAuthenticationResult(resultAdapter.authenticationResultFromBundle(resultBundle));
            return acquireTokenResult;
        }
        throw resultAdapter.getBaseExceptionFromBundle(resultBundle);
    }

    public Bundle bundleFromAccounts(@NonNull List<ICacheRecord> cacheRecords, @Nullable String negotiatedProtocolVersion) {
        Bundle resultBundle = new Bundle();
        if (cacheRecords != null) {
            String jsonString = JsonExtensions.getJsonStringFromICacheRecordList(cacheRecords);
            if (BrokerProtocolVersionUtil.canCompressBrokerPayloads(negotiatedProtocolVersion)) {
                try {
                    byte[] bytes = GzipUtil.compressString(jsonString);
                    Logger.info(TAG, "Get accounts, raw payload size :" + jsonString.getBytes().length + " compressed size " + bytes.length);
                    resultBundle.putByteArray("broker_accounts_compressed", bytes);
                }
                catch (IOException e) {
                    Logger.error(TAG, " Failed to compress account list to bytes, sending as jsonString", e);
                    resultBundle.putString("broker_accounts", jsonString);
                }
            } else {
                Logger.info(TAG, "Broker protocol version: " + negotiatedProtocolVersion + " lower than compression changes, sending as string");
                resultBundle.putString("broker_accounts", jsonString);
            }
        }
        return resultBundle;
    }

    public List<ICacheRecord> getAccountsFromResultBundle(@NonNull Bundle bundle) throws BaseException {
        String accountJson;
        if (bundle.containsKey("broker_accounts_compressed")) {
            try {
                accountJson = GzipUtil.decompressBytesToString(bundle.getByteArray("broker_accounts_compressed"));
            }
            catch (IOException e) {
                Logger.error(TAG, " Failed to decompress account list to bytes", e);
                throw new BaseException("unknown_error", " Failed to decompress account list to bytes");
            }
        } else {
            accountJson = bundle.getString("broker_accounts");
        }
        if (accountJson == null) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        return JsonExtensions.getICacheRecordListFromJsonString(accountJson);
    }

    public void verifyRemoveAccountResultFromBundle(@NonNull Bundle bundle) throws BaseException {
        if (bundle == null) {
            return;
        }
        BrokerResult brokerResult = JsonExtensions.getBrokerResultFromJsonString(bundle.getString("broker_result_v2"));
        if (brokerResult != null && brokerResult.isSuccess()) {
            return;
        }
        Logger.warn(TAG, "Failed to remove account.");
        throw this.getBaseExceptionFromBundle(bundle);
    }

    public Bundle bundleFromDeviceMode(@NonNull boolean isSharedDevice) {
        Bundle resultBundle = new Bundle();
        resultBundle.putBoolean("broker_device_mode", isSharedDevice);
        return resultBundle;
    }

    public boolean getDeviceModeFromResultBundle(@NonNull Bundle bundle) throws BaseException {
        if (!bundle.containsKey("broker_device_mode")) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        return bundle.getBoolean("broker_device_mode");
    }
}

