/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.net.Uri;
import android.util.Pair;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class AuthorizationRequest<T extends AuthorizationRequest<T>>
implements Serializable {
    private static final long serialVersionUID = 6171895895590170062L;
    @Expose
    @SerializedName(value="response_type")
    private String mResponseType;
    @Expose
    @SerializedName(value="client_id")
    private String mClientId;
    @SerializedName(value="redirect_uri")
    private String mRedirectUri;
    @Expose
    @SerializedName(value="state")
    protected String mState;
    @Expose
    @SerializedName(value="scope")
    private String mScope;
    @Expose
    @SerializedName(value="claims")
    private String mClaims;
    @Expose
    @SerializedName(value="web_view_zoom_controls_enabled")
    private boolean webViewZoomControlsEnabled;
    @Expose
    @SerializedName(value="web_view_zoom_enabled")
    private boolean webViewZoomEnabled;
    private transient HashMap<String, String> mRequestHeaders;
    private transient List<Pair<String, String>> mExtraQueryParams;

    protected AuthorizationRequest(Builder builder) {
        this.mResponseType = builder.mResponseType;
        this.mClientId = builder.mClientId;
        this.mRedirectUri = builder.mRedirectUri;
        this.mState = builder.mState;
        this.mScope = builder.mScope;
        this.mExtraQueryParams = builder.mExtraQueryParams;
        this.mClaims = builder.mClaims;
        this.mRequestHeaders = builder.mRequestHeaders;
        this.webViewZoomEnabled = builder.webViewZoomEnabled;
        this.webViewZoomControlsEnabled = builder.webViewZoomControlsEnabled;
    }

    public String getResponseType() {
        return this.mResponseType;
    }

    public List<Pair<String, String>> getExtraQueryParams() {
        return this.mExtraQueryParams;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public HashMap<String, String> getRequestHeaders() {
        return this.mRequestHeaders;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String getState() {
        return this.mState;
    }

    public String getClaims() {
        return this.mClaims;
    }

    public boolean isWebViewZoomEnabled() {
        return this.webViewZoomEnabled;
    }

    public boolean isWebViewZoomControlsEnabled() {
        return this.webViewZoomControlsEnabled;
    }

    public String toString() {
        return "AuthorizationRequest{mResponseType='" + this.mResponseType + '\'' + ", mClientId='" + this.mClientId + '\'' + ", mRedirectUri='" + this.mRedirectUri + '\'' + ", mScope='" + this.mScope + '\'' + ", mState='" + this.mState + '\'' + '}';
    }

    public String getScope() {
        return this.mScope;
    }

    public abstract String getAuthorizationEndpoint();

    public Uri getAuthorizationRequestAsHttpRequest() {
        HashMap<Object, Object> qpMap = new HashMap<Object, Object>();
        qpMap.putAll(ObjectMapper.serializeObjectHashMap(this));
        if (null != this.mExtraQueryParams && !this.mExtraQueryParams.isEmpty()) {
            for (Pair<String, String> queryParam : this.mExtraQueryParams) {
                if (qpMap.containsKey(queryParam.first)) continue;
                qpMap.put(queryParam.first, queryParam.second);
            }
        }
        Uri.Builder uriBuilder = Uri.parse((String)this.getAuthorizationEndpoint()).buildUpon();
        for (Map.Entry entry : qpMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            uriBuilder.appendQueryParameter((String)entry.getKey(), entry.getValue().toString());
        }
        return uriBuilder.build();
    }

    public static abstract class Builder<B extends Builder<B>> {
        private String mResponseType = "code";
        private String mClientId;
        private String mRedirectUri;
        private String mState;
        private String mScope;
        private String mClaims;
        private HashMap<String, String> mRequestHeaders;
        private boolean webViewZoomControlsEnabled;
        private boolean webViewZoomEnabled;
        public String mLoginHint;
        public UUID mCorrelationId;
        public List<Pair<String, String>> mExtraQueryParams;
        public String mPrompt;

        public B setPrompt(String prompt) {
            this.mPrompt = prompt;
            return this.self();
        }

        public B setResponseType(String responseType) {
            this.mResponseType = responseType;
            return this.self();
        }

        public B setClientId(String clientId) {
            this.mClientId = clientId;
            return this.self();
        }

        public B setRedirectUri(String redirectUri) {
            this.mRedirectUri = redirectUri;
            return this.self();
        }

        public B setState(String state) {
            this.mState = state;
            return this.self();
        }

        public B setScope(String scope) {
            this.mScope = scope;
            return this.self();
        }

        public B setLoginHint(String loginHint) {
            this.mLoginHint = loginHint;
            return this.self();
        }

        public B setCorrelationId(UUID correlationId) {
            this.mCorrelationId = correlationId;
            return this.self();
        }

        public B setExtraQueryParams(List<Pair<String, String>> extraQueryParams) {
            this.mExtraQueryParams = extraQueryParams;
            return this.self();
        }

        public B setClaims(String claims) {
            this.mClaims = claims;
            return this.self();
        }

        public B setRequestHeaders(HashMap<String, String> requestHeaders) {
            this.mRequestHeaders = requestHeaders;
            return this.self();
        }

        public Builder<B> setWebViewZoomEnabled(boolean webViewZoomEnabled) {
            this.webViewZoomEnabled = webViewZoomEnabled;
            return this.self();
        }

        public Builder<B> setWebViewZoomControlsEnabled(boolean webViewZoomControlsEnabled) {
            this.webViewZoomControlsEnabled = webViewZoomControlsEnabled;
            return this.self();
        }

        public abstract B self();

        public abstract AuthorizationRequest build();
    }

    public static final class ResponseType {
        public static final String CODE = "code";
    }
}

