/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.logging;

import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.ILoggerCallback;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Logger {
    private static final String CUSTOM_LOG_ERROR = "Custom log failed to log message:%s";
    private static ExecutorService sLogExecutor = Executors.newSingleThreadExecutor();
    private static final Logger INSTANCE = new Logger();
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private LogLevel mLogLevel = LogLevel.VERBOSE;
    private ILoggerCallback mExternalLogger;
    private static boolean sAllowPii = false;
    private static boolean sAllowLogcat = false;

    public static Logger getInstance() {
        return INSTANCE;
    }

    public static void setAllowPii(boolean allowPii) {
        sAllowPii = allowPii;
    }

    public static void setAllowLogcat(boolean allowLogcat) {
        sAllowLogcat = allowLogcat;
    }

    public static boolean getAllowPii() {
        return sAllowPii;
    }

    public static boolean getAllowLogcat() {
        return sAllowLogcat;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    public void setExternalLogger(ILoggerCallback externalLogger) {
        this.mExternalLogger = externalLogger;
    }

    public static void error(String tag, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, DiagnosticContext.getRequestContext().toJsonString(), errorMessage, exception, false);
    }

    public static void error(String tag, @Nullable String correlationID, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, correlationID, errorMessage, exception, false);
    }

    public static void errorPII(String tag, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, DiagnosticContext.getRequestContext().toJsonString(), errorMessage, exception, true);
    }

    public static void errorPII(String tag, @Nullable String correlationID, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, correlationID, errorMessage, exception, true);
    }

    public static void warn(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, DiagnosticContext.getRequestContext().toJsonString(), message, null, false);
    }

    public static void warn(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, correlationID, message, null, false);
    }

    public static void warnPII(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, DiagnosticContext.getRequestContext().toJsonString(), message, null, true);
    }

    public static void warnPII(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, correlationID, message, null, true);
    }

    public static void info(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, DiagnosticContext.getRequestContext().toJsonString(), message, null, false);
    }

    public static void info(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, correlationID, message, null, false);
    }

    public static void infoPII(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, DiagnosticContext.getRequestContext().toJsonString(), message, null, true);
    }

    public static void infoPII(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, correlationID, message, null, true);
    }

    public static void verbose(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, DiagnosticContext.getRequestContext().toJsonString(), message, null, false);
    }

    public static void verbose(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, correlationID, message, null, false);
    }

    public static void verbosePII(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, DiagnosticContext.getRequestContext().toJsonString(), message, null, true);
    }

    public static void verbosePII(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, correlationID, message, null, true);
    }

    private void log(final String tag, final LogLevel logLevel, final @Nullable String correlationID, final @Nullable String message, final @Nullable Throwable throwable, final boolean containsPII) {
        sLogExecutor.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    ILoggerCallback externalLogger;
                    if (logLevel.compareTo(Logger.this.mLogLevel) > 0) {
                        return;
                    }
                    if (!sAllowPii && containsPII) {
                        return;
                    }
                    String logMessage = Logger.this.formatMessage(correlationID, message, throwable);
                    if (sAllowLogcat) {
                        Logger.this.sendLogcatLogs(tag, logLevel, logMessage);
                    }
                    if (null != (externalLogger = Logger.this.mExternalLogger)) {
                        try {
                            Logger.this.mExternalLogger.log(tag, logLevel, logMessage, containsPII);
                        }
                        catch (Exception e) {
                            if (containsPII && !sAllowPii) break block6;
                            Log.w((String)tag, (String)String.format(Logger.CUSTOM_LOG_ERROR, logMessage));
                        }
                    }
                }
            }
        });
    }

    private String formatMessage(@Nullable String correlationID, @Nullable String message, @Nullable Throwable throwable) {
        String logMessage = StringExtensions.isNullOrBlank(message) ? "N/A" : message;
        return " [" + Logger.getUTCDateTimeAsString() + (StringExtensions.isNullOrBlank(correlationID) ? "] " : " - " + correlationID + "] ") + logMessage + " Android " + Build.VERSION.SDK_INT + (throwable == null ? "" : '\n' + Log.getStackTraceString((Throwable)throwable));
    }

    private static String getUTCDateTimeAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    private void sendLogcatLogs(String tag, LogLevel logLevel, String message) {
        switch (logLevel) {
            case ERROR: {
                Log.e((String)tag, (String)message);
                break;
            }
            case WARN: {
                Log.w((String)tag, (String)message);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)message);
                break;
            }
            case VERBOSE: {
                Log.v((String)tag, (String)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level");
            }
        }
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        VERBOSE;

    }
}

