/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import android.util.Pair;
import androidx.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.eststelemetry.FailedRequest;
import com.microsoft.identity.common.internal.eststelemetry.RequestTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LastRequestTelemetry
extends RequestTelemetry {
    static final int FAILED_REQUEST_CAP = 100;
    @SerializedName(value="silent_successful_count")
    private int silentSuccessfulCount = 0;
    @SerializedName(value="failed_requests")
    private List<FailedRequest> failedRequests = new ArrayList<FailedRequest>();

    LastRequestTelemetry(@NonNull String schemaVersion) {
        super(schemaVersion);
    }

    List<FailedRequest> getFailedRequests() {
        return Collections.unmodifiableList(this.failedRequests);
    }

    @Override
    public String getHeaderStringForFields() {
        Pair<String, String> headerSegments = this.getHeaderStringForFailedRequests();
        StringBuilder sb = new StringBuilder();
        sb.append(this.silentSuccessfulCount).append("|").append((String)headerSegments.first).append("|").append((String)headerSegments.second);
        return sb.toString();
    }

    void incrementSilentSuccessCount() {
        ++this.silentSuccessfulCount;
    }

    void resetSilentSuccessCount() {
        this.silentSuccessfulCount = 0;
    }

    void appendFailedRequest(String apiId, String correlationId, String error) {
        this.appendFailedRequest(new FailedRequest(apiId, correlationId, error));
    }

    void appendFailedRequest(FailedRequest failedRequest) {
        if (this.failedRequests.size() >= 100) {
            int beginIndex = this.failedRequests.size() - 100 + 1;
            int endIndex = this.failedRequests.size();
            this.failedRequests = this.failedRequests.subList(beginIndex, endIndex);
        }
        this.failedRequests.add(failedRequest);
    }

    void wipeFailedRequestAndErrorForSubList(Collection<FailedRequest> failedRequestsToRemove) {
        if (failedRequestsToRemove != null) {
            this.failedRequests.removeAll(failedRequestsToRemove);
        }
    }

    @Override
    public RequestTelemetry copySharedValues(@NonNull RequestTelemetry requestTelemetry) {
        if (requestTelemetry instanceof LastRequestTelemetry) {
            this.silentSuccessfulCount = ((LastRequestTelemetry)requestTelemetry).silentSuccessfulCount;
        }
        return super.copySharedValues(requestTelemetry);
    }

    private Pair<String, String> getHeaderStringForFailedRequests() {
        if (this.failedRequests == null) {
            return new Pair((Object)"", (Object)"");
        }
        FailedRequest[] failedRequestsArray = this.failedRequests.toArray(new FailedRequest[0]);
        if (failedRequestsArray == null) {
            return new Pair((Object)"", (Object)"");
        }
        StringBuilder apiIdCorrelationIdSegmentBuilder = new StringBuilder();
        StringBuilder errorSegmentBuilder = new StringBuilder();
        for (int i = 0; i < failedRequestsArray.length; ++i) {
            FailedRequest failedRequest = failedRequestsArray[i];
            apiIdCorrelationIdSegmentBuilder.append(failedRequest.toApiIdCorrelationString());
            errorSegmentBuilder.append(failedRequest.toErrorCodeString());
            if (i == failedRequestsArray.length - 1) continue;
            apiIdCorrelationIdSegmentBuilder.append(',');
            errorSegmentBuilder.append(',');
        }
        return new Pair((Object)apiIdCorrelationIdSegmentBuilder.toString(), (Object)errorSegmentBuilder.toString());
    }
}

