/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.dto;

import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum CredentialType {
    RefreshToken,
    AccessToken,
    IdToken,
    V1IdToken,
    Password,
    Cookie,
    Certificate,
    AccessToken_With_AuthScheme;

    public static final CredentialType[] ID_TOKEN_TYPES;

    public static Set<String> valueSet() {
        HashSet<String> strTypes = new HashSet<String>();
        for (CredentialType type : CredentialType.values()) {
            strTypes.add(type.name());
        }
        return Collections.unmodifiableSet(strTypes);
    }

    @Nullable
    public static CredentialType fromString(@Nullable String name) {
        for (CredentialType credentialType : CredentialType.values()) {
            if (!credentialType.name().equalsIgnoreCase(name)) continue;
            return credentialType;
        }
        return null;
    }

    static {
        ID_TOKEN_TYPES = new CredentialType[]{IdToken, V1IdToken};
    }
}

