/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.broker.BrokerAccountManagerStrategy;
import com.microsoft.identity.common.internal.broker.BrokerActivity;
import com.microsoft.identity.common.internal.broker.BrokerAuthServiceStrategy;
import com.microsoft.identity.common.internal.broker.BrokerBaseStrategy;
import com.microsoft.identity.common.internal.broker.BrokerContentProviderStrategy;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerResultFuture;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.util.AccountManagerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    private BrokerResultFuture mBrokerResultFuture;
    private Context mApplicationContext;

    public BrokerMsalController(Context applicationContext) {
        this.mApplicationContext = applicationContext;
    }

    @Override
    public AcquireTokenResult acquireToken(InteractiveTokenCommandParameters parameters) throws Exception {
        AcquireTokenResult result;
        Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId("201"));
        this.mBrokerResultFuture = new BrokerResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Intent brokerActivityIntent = new Intent(parameters.getAndroidApplicationContext(), BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        this.mBrokerResultFuture = new BrokerResultFuture();
        parameters.getActivity().startActivity(brokerActivityIntent);
        Bundle resultBundle = this.mBrokerResultFuture.get();
        if (parameters.getOAuth2TokenCache() != null) {
            this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getOAuth2TokenCache());
        }
        try {
            result = new MsalBrokerResultAdapter().getAcquireTokenResultFromResultBundle(resultBundle);
        }
        catch (BaseException e) {
            Telemetry.emit(new ApiEndEvent().putException(e).putApiId("201"));
            throw e;
        }
        Telemetry.emit(new ApiEndEvent().putResult(result).putApiId("201"));
        return result;
    }

    private <T extends CommandParameters, U> U invokeBrokerOperation(@NonNull T parameters, @NonNull BrokerOperationInfo<T, U> strategyTask) throws Exception {
        if (strategyTask.getTelemetryApiId() != null) {
            Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId(strategyTask.getTelemetryApiId()));
        }
        List<BrokerBaseStrategy> strategies = this.getStrategies();
        Object result = null;
        Exception lastCaughtException = null;
        for (int ii = 0; ii < strategies.size(); ++ii) {
            BrokerBaseStrategy strategy = strategies.get(ii);
            try {
                Logger.info(TAG + strategyTask.getMethodName(), "Executing with broker strategy: " + strategy.getClass().getSimpleName());
                String negotiatedBrokerProtocolVersion = strategy.hello(parameters);
                result = strategyTask.perform(strategy, parameters, negotiatedBrokerProtocolVersion);
                if (result == null) continue;
                break;
            }
            catch (BrokerCommunicationException communicationException) {
                lastCaughtException = communicationException;
                continue;
            }
            catch (BaseException exception) {
                if (strategyTask.getTelemetryApiId() != null) {
                    Telemetry.emit(new ApiEndEvent().putException(exception).putApiId(strategyTask.getTelemetryApiId()));
                }
                throw exception;
            }
            catch (Exception exception) {
                lastCaughtException = exception;
            }
        }
        if (result == null) {
            ClientException exception = new ClientException("Failed to bind the service in broker app", "Unable to connect to the broker", lastCaughtException);
            if (strategyTask.getTelemetryApiId() != null) {
                Telemetry.emit(new ApiEndEvent().putException(exception).putApiId(strategyTask.getTelemetryApiId()));
            }
            throw exception;
        }
        if (strategyTask.getTelemetryApiId() != null) {
            ApiEndEvent successEvent = new ApiEndEvent().putApiId(strategyTask.getTelemetryApiId()).isApiCallSuccessful(Boolean.TRUE);
            strategyTask.putValueInSuccessEvent(successEvent, result);
            Telemetry.emit(successEvent);
        }
        return result;
    }

    private List<BrokerBaseStrategy> getStrategies() {
        ArrayList<BrokerBaseStrategy> strategies = new ArrayList<BrokerBaseStrategy>();
        StringBuilder sb = new StringBuilder(100);
        sb.append("Broker Strategies added : ");
        if (this.isBrokerContentProviderAvailable()) {
            sb.append("ContentProviderStrategy, ");
            strategies.add(new BrokerContentProviderStrategy());
        }
        if (this.isMicrosoftAuthServiceSupported()) {
            sb.append("AuthServiceStrategy, ");
            strategies.add(new BrokerAuthServiceStrategy());
        }
        if (AccountManagerUtil.canUseAccountManagerOperation(this.mApplicationContext)) {
            sb.append("AccountManagerStrategy.");
            strategies.add(new BrokerAccountManagerStrategy());
        }
        Logger.info(TAG, sb.toString());
        return strategies;
    }

    private Intent getBrokerAuthorizationIntent(@NonNull InteractiveTokenCommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<InteractiveTokenCommandParameters, Intent>(){

            @Override
            @Nullable
            public Intent perform(@NonNull BrokerBaseStrategy strategy, @NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException, InterruptedException, ExecutionException, RemoteException {
                return strategy.getBrokerAuthorizationIntent(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Intent result) {
            }
        });
    }

    @Override
    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        Telemetry.emit(new ApiStartEvent().putApiId("202").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mBrokerResultFuture.setResultBundle(data.getExtras());
        Telemetry.emit(new ApiEndEvent().putApiId("202"));
    }

    @Override
    public AcquireTokenResult acquireTokenSilent(SilentTokenCommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<SilentTokenCommandParameters, AcquireTokenResult>(){

            @Override
            @Nullable
            public AcquireTokenResult perform(@NonNull BrokerBaseStrategy strategy, @NonNull SilentTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException, InterruptedException, ExecutionException, RemoteException {
                return strategy.acquireTokenSilent(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":acquireTokenSilent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "203";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    @Override
    public List<ICacheRecord> getAccounts(@NonNull CommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<CommandParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public List<ICacheRecord> perform(@NonNull BrokerBaseStrategy strategy, @NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws RemoteException, InterruptedException, ExecutionException, AuthenticatorException, IOException, OperationCanceledException, BaseException {
                return strategy.getBrokerAccounts(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAccounts";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "206";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    @Override
    @WorkerThread
    public boolean removeAccount(@NonNull RemoveAccountCommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<RemoveAccountCommandParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(@NonNull BrokerBaseStrategy strategy, @NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws InterruptedException, ExecutionException, BaseException, RemoteException {
                strategy.removeBrokerAccount(parameters, negotiatedBrokerProtocolVersion);
                return true;
            }

            @Override
            public String getMethodName() {
                return ":removeAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "207";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
            }
        });
    }

    @Override
    @WorkerThread
    public boolean getDeviceMode(@NonNull CommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<CommandParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(@NonNull BrokerBaseStrategy strategy, @NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws Exception {
                return strategy.getDeviceMode(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getDeviceMode";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "204";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
                event.put("Microsoft.MSAL.is_device_shared", Boolean.toString(result));
            }
        });
    }

    @Override
    public List<ICacheRecord> getCurrentAccount(CommandParameters parameters) throws Exception {
        String methodName = ":getCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":getCurrentAccount", "Not a shared device, invoke getAccounts() instead of getCurrentAccount()");
            return this.getAccounts(parameters);
        }
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<CommandParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public List<ICacheRecord> perform(@NonNull BrokerBaseStrategy strategy, @NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws Exception {
                return strategy.getCurrentAccountInSharedDevice(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getCurrentAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "205";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    @Override
    public boolean removeCurrentAccount(RemoveAccountCommandParameters parameters) throws Exception {
        String methodName = ":removeCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":removeCurrentAccount", "Not a shared device, invoke removeAccount() instead of removeCurrentAccount()");
            return this.removeAccount(parameters);
        }
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<RemoveAccountCommandParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(@NonNull BrokerBaseStrategy strategy, @NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws InterruptedException, ExecutionException, BaseException, RemoteException {
                strategy.signOutFromSharedDevice(parameters, negotiatedBrokerProtocolVersion);
                BrokerMsalController.this.logOutFromBrowser(BrokerMsalController.this.mApplicationContext, parameters);
                return true;
            }

            @Override
            public String getMethodName() {
                return ":removeCurrentAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "208";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
            }
        });
    }

    private void logOutFromBrowser(@NonNull Context context, @NonNull RemoveAccountCommandParameters parameters) {
        String methodName = ":logOutFromBrowser";
        String browserPackageName = null;
        try {
            Browser browser = BrowserSelector.select(context, parameters.getBrowserSafeList());
            browserPackageName = browser.getPackageName();
        }
        catch (ClientException e) {
            Logger.error(TAG, e.getErrorCode(), e);
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setData(Uri.parse((String)"https://login.microsoftonline.com/common/oauth2/v2.0/logout"));
            if (browserPackageName != null) {
                intent.setPackage(browserPackageName);
            }
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(TAG + ":logOutFromBrowser", "Failed to launch browser sign out with browser=[" + browserPackageName + "]. Skipping.", e);
        }
    }

    @Override
    public AuthorizationResult deviceCodeFlowAuthRequest(DeviceCodeFlowCommandParameters parameters) throws ClientException {
        throw new ClientException("deviceCodeFlowAuthRequest() not supported in BrokerMsalController");
    }

    @Override
    public AcquireTokenResult acquireDeviceCodeFlowToken(AuthorizationResult authorizationResult, DeviceCodeFlowCommandParameters commandParameters) throws ClientException {
        throw new ClientException("acquireDeviceCodeFlowToken() not supported in BrokerMsalController");
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws ClientException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = new MsalBrokerResultAdapter().brokerResultFromBundle(resultBundle);
        if (resultBundle.getBoolean("broker_request_v2_success") && brokerResult != null && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info(TAG + ":saveMsaAccountToCache", "Result returned for MSA Account, saving to cache");
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                msalOAuth2TokenCache.setSingleSignOnState(microsoftStsAccount, microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII(TAG + ":saveMsaAccountToCache", "Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", e);
                throw new ClientException("invalid_jwt", e.getMessage(), e);
            }
        }
    }

    private boolean isMicrosoftAuthServiceSupported() {
        MicrosoftAuthClient client = new MicrosoftAuthClient(this.mApplicationContext);
        Intent microsoftAuthServiceIntent = client.getIntentForAuthService(this.mApplicationContext);
        return null != microsoftAuthServiceIntent;
    }

    private boolean isBrokerContentProviderAvailable() {
        String activeBrokerPackageName = new BrokerValidator(this.mApplicationContext).getCurrentActiveBrokerPackageName();
        String brokerContentProviderAuthority = activeBrokerPackageName + "." + "microsoft.identity.broker";
        List providers = this.mApplicationContext.getPackageManager().queryContentProviders(null, 0, 0);
        for (ProviderInfo providerInfo : providers) {
            if (providerInfo.authority == null || !providerInfo.authority.equals(brokerContentProviderAuthority)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerMsalController)) {
            return false;
        }
        BrokerMsalController other = (BrokerMsalController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerMsalController;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static interface BrokerOperationInfo<T extends CommandParameters, U> {
        @Nullable
        public U perform(BrokerBaseStrategy var1, T var2, String var3) throws Exception;

        public String getMethodName();

        @Nullable
        public String getTelemetryApiId();

        public void putValueInSuccessEvent(ApiEndEvent var1, U var2);
    }
}

