/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands.parameters;

import android.text.TextUtils;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.request.BrokerRequestType;
import com.microsoft.identity.common.internal.request.SdkType;

public class BrokerInteractiveTokenCommandParameters
extends InteractiveTokenCommandParameters {
    private String callerPackageName;
    private int callerUid;
    private String callerAppVersion;
    private String brokerVersion;
    private boolean shouldResolveInterrupt;
    private BrokerRequestType requestType;
    private String negotiatedBrokerProtocolVersion;
    private String enrollmentId;

    public boolean isRequestFromBroker() {
        return this.requestType == BrokerRequestType.BROKER_RT_REQUEST || this.requestType == BrokerRequestType.RESOLVE_INTERRUPT;
    }

    @Override
    public void validate() throws ArgumentException {
        super.validate();
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireToken", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireToken", "mScopes", "Scope or resource is not set");
        }
        if (TextUtils.isEmpty((CharSequence)this.getClientId())) {
            throw new ArgumentException("acquireToken", "mClientId", "Client Id is not set");
        }
        if (!this.isRequestFromBroker()) {
            if (this.callerUid == 0) {
                throw new ArgumentException("acquireToken", "mCallerUId", "Caller Uid is not set");
            }
            if (TextUtils.isEmpty((CharSequence)this.callerPackageName)) {
                throw new ArgumentException("acquireToken", "mCallerPackageName", "Caller package name is not set");
            }
            if (!(this.getOAuth2TokenCache() instanceof BrokerOAuth2TokenCache)) {
                throw new ArgumentException("acquireToken", "AcquireTokenSilentOperationParameters", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
            }
            if (SdkType.MSAL == this.getSdkType() && !BrokerValidator.isValidBrokerRedirect(this.getRedirectUri(), this.getAndroidApplicationContext(), this.getCallerPackageName())) {
                throw new ArgumentException("acquireToken", "mRedirectUri", "The redirect URI doesn't match the uri generated with caller package name and signature");
            }
        }
    }

    protected BrokerInteractiveTokenCommandParameters(BrokerInteractiveTokenCommandParametersBuilder<?, ?> b) {
        super((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder<?, ?>)b);
        this.callerPackageName = ((BrokerInteractiveTokenCommandParametersBuilder)b).callerPackageName;
        this.callerUid = ((BrokerInteractiveTokenCommandParametersBuilder)b).callerUid;
        this.callerAppVersion = ((BrokerInteractiveTokenCommandParametersBuilder)b).callerAppVersion;
        this.brokerVersion = ((BrokerInteractiveTokenCommandParametersBuilder)b).brokerVersion;
        this.shouldResolveInterrupt = ((BrokerInteractiveTokenCommandParametersBuilder)b).shouldResolveInterrupt;
        this.requestType = ((BrokerInteractiveTokenCommandParametersBuilder)b).requestType;
        this.negotiatedBrokerProtocolVersion = ((BrokerInteractiveTokenCommandParametersBuilder)b).negotiatedBrokerProtocolVersion;
        this.enrollmentId = ((BrokerInteractiveTokenCommandParametersBuilder)b).enrollmentId;
    }

    public static BrokerInteractiveTokenCommandParametersBuilder<?, ?> builder() {
        return new BrokerInteractiveTokenCommandParametersBuilderImpl();
    }

    @Override
    public BrokerInteractiveTokenCommandParametersBuilder<?, ?> toBuilder() {
        return new BrokerInteractiveTokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    public String getCallerPackageName() {
        return this.callerPackageName;
    }

    public int getCallerUid() {
        return this.callerUid;
    }

    public String getCallerAppVersion() {
        return this.callerAppVersion;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public boolean isShouldResolveInterrupt() {
        return this.shouldResolveInterrupt;
    }

    public BrokerRequestType getRequestType() {
        return this.requestType;
    }

    public String getNegotiatedBrokerProtocolVersion() {
        return this.negotiatedBrokerProtocolVersion;
    }

    public String getEnrollmentId() {
        return this.enrollmentId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerInteractiveTokenCommandParameters)) {
            return false;
        }
        BrokerInteractiveTokenCommandParameters other = (BrokerInteractiveTokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$callerPackageName = this.getCallerPackageName();
        String other$callerPackageName = other.getCallerPackageName();
        if (this$callerPackageName == null ? other$callerPackageName != null : !this$callerPackageName.equals(other$callerPackageName)) {
            return false;
        }
        if (this.getCallerUid() != other.getCallerUid()) {
            return false;
        }
        String this$callerAppVersion = this.getCallerAppVersion();
        String other$callerAppVersion = other.getCallerAppVersion();
        if (this$callerAppVersion == null ? other$callerAppVersion != null : !this$callerAppVersion.equals(other$callerAppVersion)) {
            return false;
        }
        String this$brokerVersion = this.getBrokerVersion();
        String other$brokerVersion = other.getBrokerVersion();
        if (this$brokerVersion == null ? other$brokerVersion != null : !this$brokerVersion.equals(other$brokerVersion)) {
            return false;
        }
        if (this.isShouldResolveInterrupt() != other.isShouldResolveInterrupt()) {
            return false;
        }
        BrokerRequestType this$requestType = this.getRequestType();
        BrokerRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !((Object)((Object)this$requestType)).equals((Object)other$requestType)) {
            return false;
        }
        String this$negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        String other$negotiatedBrokerProtocolVersion = other.getNegotiatedBrokerProtocolVersion();
        if (this$negotiatedBrokerProtocolVersion == null ? other$negotiatedBrokerProtocolVersion != null : !this$negotiatedBrokerProtocolVersion.equals(other$negotiatedBrokerProtocolVersion)) {
            return false;
        }
        String this$enrollmentId = this.getEnrollmentId();
        String other$enrollmentId = other.getEnrollmentId();
        return !(this$enrollmentId == null ? other$enrollmentId != null : !this$enrollmentId.equals(other$enrollmentId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BrokerInteractiveTokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $callerPackageName = this.getCallerPackageName();
        result = result * 59 + ($callerPackageName == null ? 43 : $callerPackageName.hashCode());
        result = result * 59 + this.getCallerUid();
        String $callerAppVersion = this.getCallerAppVersion();
        result = result * 59 + ($callerAppVersion == null ? 43 : $callerAppVersion.hashCode());
        String $brokerVersion = this.getBrokerVersion();
        result = result * 59 + ($brokerVersion == null ? 43 : $brokerVersion.hashCode());
        result = result * 59 + (this.isShouldResolveInterrupt() ? 79 : 97);
        BrokerRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : ((Object)((Object)$requestType)).hashCode());
        String $negotiatedBrokerProtocolVersion = this.getNegotiatedBrokerProtocolVersion();
        result = result * 59 + ($negotiatedBrokerProtocolVersion == null ? 43 : $negotiatedBrokerProtocolVersion.hashCode());
        String $enrollmentId = this.getEnrollmentId();
        result = result * 59 + ($enrollmentId == null ? 43 : $enrollmentId.hashCode());
        return result;
    }

    private static final class BrokerInteractiveTokenCommandParametersBuilderImpl
    extends BrokerInteractiveTokenCommandParametersBuilder<BrokerInteractiveTokenCommandParameters, BrokerInteractiveTokenCommandParametersBuilderImpl> {
        private BrokerInteractiveTokenCommandParametersBuilderImpl() {
        }

        @Override
        protected BrokerInteractiveTokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public BrokerInteractiveTokenCommandParameters build() {
            return new BrokerInteractiveTokenCommandParameters(this);
        }
    }

    public static abstract class BrokerInteractiveTokenCommandParametersBuilder<C extends BrokerInteractiveTokenCommandParameters, B extends BrokerInteractiveTokenCommandParametersBuilder<C, B>>
    extends InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder<C, B> {
        private String callerPackageName;
        private int callerUid;
        private String callerAppVersion;
        private String brokerVersion;
        private boolean shouldResolveInterrupt;
        private BrokerRequestType requestType;
        private String negotiatedBrokerProtocolVersion;
        private String enrollmentId;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrokerInteractiveTokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrokerInteractiveTokenCommandParameters instance, BrokerInteractiveTokenCommandParametersBuilder<?, ?> b) {
            b.callerPackageName(instance.callerPackageName);
            b.callerUid(instance.callerUid);
            b.callerAppVersion(instance.callerAppVersion);
            b.brokerVersion(instance.brokerVersion);
            b.shouldResolveInterrupt(instance.shouldResolveInterrupt);
            b.requestType(instance.requestType);
            b.negotiatedBrokerProtocolVersion(instance.negotiatedBrokerProtocolVersion);
            b.enrollmentId(instance.enrollmentId);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B callerPackageName(String callerPackageName) {
            this.callerPackageName = callerPackageName;
            return (B)this.self();
        }

        public B callerUid(int callerUid) {
            this.callerUid = callerUid;
            return (B)this.self();
        }

        public B callerAppVersion(String callerAppVersion) {
            this.callerAppVersion = callerAppVersion;
            return (B)this.self();
        }

        public B brokerVersion(String brokerVersion) {
            this.brokerVersion = brokerVersion;
            return (B)this.self();
        }

        public B shouldResolveInterrupt(boolean shouldResolveInterrupt) {
            this.shouldResolveInterrupt = shouldResolveInterrupt;
            return (B)this.self();
        }

        public B requestType(BrokerRequestType requestType) {
            this.requestType = requestType;
            return (B)this.self();
        }

        public B negotiatedBrokerProtocolVersion(String negotiatedBrokerProtocolVersion) {
            this.negotiatedBrokerProtocolVersion = negotiatedBrokerProtocolVersion;
            return (B)this.self();
        }

        public B enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder(super=" + super.toString() + ", callerPackageName=" + this.callerPackageName + ", callerUid=" + this.callerUid + ", callerAppVersion=" + this.callerAppVersion + ", brokerVersion=" + this.brokerVersion + ", shouldResolveInterrupt=" + this.shouldResolveInterrupt + ", requestType=" + (Object)((Object)this.requestType) + ", negotiatedBrokerProtocolVersion=" + this.negotiatedBrokerProtocolVersion + ", enrollmentId=" + this.enrollmentId + ")";
        }
    }
}

