/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authorities;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.identity.common.internal.authorities.AccountsInOneOrganization;
import com.microsoft.identity.common.internal.authorities.AllAccounts;
import com.microsoft.identity.common.internal.authorities.AnyOrganizationalAccount;
import com.microsoft.identity.common.internal.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.internal.authorities.UnknownAudience;
import com.microsoft.identity.common.internal.logging.Logger;
import java.lang.reflect.Type;

public class AzureActiveDirectoryAudienceDeserializer
implements JsonDeserializer<AzureActiveDirectoryAudience> {
    private static final String TAG = AzureActiveDirectoryAudienceDeserializer.class.getSimpleName();

    public AzureActiveDirectoryAudience deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String methodName = ":deserialize";
        JsonObject audienceObject = json.getAsJsonObject();
        JsonElement type = audienceObject.get("type");
        if (type != null) {
            switch (type.getAsString()) {
                case "AzureADMyOrg": {
                    Logger.verbose(TAG + ":deserialize", "Type: AzureADMyOrg");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AccountsInOneOrganization.class);
                }
                case "AzureADMultipleOrgs": {
                    Logger.verbose(TAG + ":deserialize", "Type: AzureADMultipleOrgs");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AnyOrganizationalAccount.class);
                }
                case "AzureADandPersonalMicrosoftAccount": {
                    Logger.verbose(TAG + ":deserialize", "Type: AzureADandPersonalMicrosoftAccount");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AllAccounts.class);
                }
                case "PersonalMicrosoftAccount": {
                    Logger.verbose(TAG + ":deserialize", "Type: PersonalMicrosoftAccount");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AnyPersonalAccount.class);
                }
            }
            Logger.verbose(TAG + ":deserialize", "Type: Unknown");
            return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, UnknownAudience.class);
        }
        return null;
    }
}

