/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;
import lombok.NonNull;

public class WorkProfileUtil {
    private static final String TAG = WorkProfileUtil.class.getSimpleName();

    public static boolean checkIfIsInPersonalProfileButClouddpcWorkProfileAvailable(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (!CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_AM_API_WORKPROFILE_EXTRA_QUERY_PARAMETERS)) {
            return false;
        }
        try {
            Intent intent = new Intent("com.google.android.apps.work.clouddpc.ACTION_DETECT_WORK_PROFILE");
            List activities = context.getPackageManager().queryIntentActivities(intent, 0);
            if (Build.VERSION.SDK_INT >= 30) {
                return activities.stream().anyMatch(resolveInfo -> resolveInfo.isCrossProfileIntentForwarderActivity());
            }
            if (Build.VERSION.SDK_INT >= 24) {
                return activities.stream().anyMatch(resolveInfo -> resolveInfo.activityInfo.name.equals("com.android.internal.app.ForwardIntentToManagedProfile"));
            }
            return false;
        }
        catch (Exception e) {
            Logger.warn(TAG, "Received an exception while trying to check if clouddpc work profile is available: " + e.getMessage());
            return false;
        }
    }
}

