/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.os.Bundle;
import com.microsoft.identity.common.java.base64.Base64Util;
import com.microsoft.identity.common.java.commands.webapps.WebAppError;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.logging.Logger;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/microsoft/identity/common/internal/util/WebAppsUtil;", "", "()V", "Companion", "common_distRelease"})
public final class WebAppsUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(WebAppsUtil.class).getSimpleName();
    @NotNull
    public static final String DEFAULT_AUTHORITY = "https://login.microsoftonline.com/common";

    @JvmStatic
    public static final void validateMsalJsRedirectOrigin(@NotNull String redirectUri, @NotNull String senderUri) {
        Companion.validateMsalJsRedirectOrigin(redirectUri, senderUri);
    }

    @JvmStatic
    @NotNull
    public static final Bundle getResponseBundle(@NotNull Object responseObject) {
        return Companion.getResponseBundle(responseObject);
    }

    @JvmStatic
    @NotNull
    public static final Bundle createErrorResponseBundle(@NotNull Throwable t, @Nullable String description) {
        return Companion.createErrorResponseBundle(t, description);
    }

    @JvmStatic
    @NotNull
    public static final String createErrorResponseString(@NotNull Throwable t, @Nullable String description) {
        return Companion.createErrorResponseString(t, description);
    }

    @JvmStatic
    public static final <T> T requireNotNullOrEmpty(@Nullable T value, @NotNull String name) throws ClientException {
        return Companion.requireNotNullOrEmpty(value, name);
    }

    @JvmStatic
    public static final long computeRemainingSeconds(@Nullable String epochSecondsStr) {
        return Companion.computeRemainingSeconds(epochSecondsStr);
    }

    @JvmStatic
    @Nullable
    public static final String homeAccountIdToClientInfo(@Nullable String homeAccountId) {
        return Companion.homeAccountIdToClientInfo(homeAccountId);
    }

    @JvmStatic
    @NotNull
    public static final String getSchemeAndHost(@NotNull String url) {
        return Companion.getSchemeAndHost(url);
    }

    @JvmStatic
    public static final boolean hasSameSchemeAndHost(@NotNull String urlA, @NotNull String urlB) {
        return Companion.hasSameSchemeAndHost(urlA, urlB);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J%\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u0001H\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/microsoft/identity/common/internal/util/WebAppsUtil$Companion;", "", "()V", "DEFAULT_AUTHORITY", "", "TAG", "computeRemainingSeconds", "", "epochSecondsStr", "createErrorResponseBundle", "Landroid/os/Bundle;", "t", "", "description", "createErrorResponseString", "getResponseBundle", "responseObject", "getSchemeAndHost", "url", "hasSameSchemeAndHost", "", "urlA", "urlB", "homeAccountIdToClientInfo", "homeAccountId", "requireNotNullOrEmpty", "T", "value", "name", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "validateMsalJsRedirectOrigin", "", "redirectUri", "senderUri", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void validateMsalJsRedirectOrigin(@NotNull String redirectUri, @NotNull String senderUri) {
            Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
            Intrinsics.checkNotNullParameter((Object)senderUri, (String)"senderUri");
            if (!this.hasSameSchemeAndHost(senderUri, redirectUri)) {
                throw new ClientException("invalid_request", "The redirect URI origin does not match the sender origin.");
            }
        }

        @JvmStatic
        @NotNull
        public final Bundle getResponseBundle(@NotNull Object responseObject) {
            Bundle bundle;
            Intrinsics.checkNotNullParameter((Object)responseObject, (String)"responseObject");
            Bundle $this$getResponseBundle_u24lambda_u240 = bundle = new Bundle();
            boolean bl = false;
            $this$getResponseBundle_u24lambda_u240.putString("web_app_successful_result", ObjectMapper.serializeObjectToJsonString((Object)responseObject));
            return bundle;
        }

        @JvmStatic
        @NotNull
        public final Bundle createErrorResponseBundle(@NotNull Throwable t, @Nullable String description) {
            Bundle bundle;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Bundle $this$createErrorResponseBundle_u24lambda_u241 = bundle = new Bundle();
            boolean bl = false;
            $this$createErrorResponseBundle_u24lambda_u241.putString("web_apps_error_result", Companion.createErrorResponseString(t, description));
            return bundle;
        }

        @JvmStatic
        @NotNull
        public final String createErrorResponseString(@NotNull Throwable t, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            CharSequence charSequence = description;
            String errorDescription = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? description + ": " + t.getClass().getSimpleName() + ": " + t.getMessage() : "Error occurred during operation: " + t.getClass().getSimpleName() + ": " + t.getMessage();
            String string2 = ObjectMapper.serializeObjectToJsonString((Object)new WebAppError(t, errorDescription));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serializeObjectToJsonStr\u2026ror(t, errorDescription))");
            return string2;
        }

        @JvmStatic
        public final <T> T requireNotNullOrEmpty(@Nullable T value, @NotNull String name) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (value == null) {
                throw new ClientException("missing_parameter", name + " is null.");
            }
            if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
                throw new ClientException("missing_parameter", name + " is empty.");
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                throw new ClientException("missing_parameter", name + " is empty.");
            }
            return value;
        }

        @JvmStatic
        public final long computeRemainingSeconds(@Nullable String epochSecondsStr) {
            long l;
            CharSequence charSequence = epochSecondsStr;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return 0L;
            }
            try {
                long target = Long.parseLong(epochSecondsStr);
                long now = System.currentTimeMillis() / 1000L;
                long delta = target - now;
                l = delta > 0L ? delta : 0L;
            }
            catch (NumberFormatException e) {
                Logger.warn(TAG + ":computeRemainingSeconds", "Invalid epoch seconds: " + epochSecondsStr);
                l = 0L;
            }
            return l;
        }

        @JvmStatic
        @Nullable
        public final String homeAccountIdToClientInfo(@Nullable String homeAccountId) {
            CharSequence charSequence = homeAccountId;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)homeAccountId, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2 || StringsKt.isBlank((CharSequence)((CharSequence)parts.get(0))) || StringsKt.isBlank((CharSequence)((CharSequence)parts.get(1)))) {
                return null;
            }
            String json = "{\"uid\":\"" + (String)parts.get(0) + "\",\"utid\":\"" + (String)parts.get(1) + "\"}";
            return Base64Util.Companion.encodeUrlSafeString(json);
        }

        @JvmStatic
        @NotNull
        public final String getSchemeAndHost(@NotNull String url) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            try {
                uRI = new URI(((Object)StringsKt.trim((CharSequence)url)).toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse URL for scheme and host validation in WebApps. The URL is invalid.", e);
            }
            URI uri = uRI;
            String string2 = uri.getScheme();
            if (string2 == null) {
                throw new IllegalArgumentException("Failed to parse URL for scheme and host validation in WebApps. The URL is invalid.");
            }
            String scheme = string2;
            String string3 = uri.getHost();
            if (string3 == null) {
                throw new IllegalArgumentException("URL must include a host for WebApps validation.");
            }
            String host = string3;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = scheme.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            StringBuilder stringBuilder2 = stringBuilder.append(string4).append("://");
            String string5 = host.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return stringBuilder2.append(string5).toString();
        }

        @JvmStatic
        public final boolean hasSameSchemeAndHost(@NotNull String urlA, @NotNull String urlB) {
            Intrinsics.checkNotNullParameter((Object)urlA, (String)"urlA");
            Intrinsics.checkNotNullParameter((Object)urlB, (String)"urlB");
            return Intrinsics.areEqual((Object)this.getSchemeAndHost(urlA), (Object)this.getSchemeAndHost(urlB));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

