/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.switchbrowser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.microsoft.identity.common.internal.providers.oauth2.SwitchBrowserActivity;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserRequestHandler;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserUriHelper;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013JL\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001924\u0010\u001a\u001a0\u0012\u0004\u0012\u00020\u001c\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001dj\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017`\u001e\u0012\u0004\u0012\u00020\u00150\u001bR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserProtocolCoordinator;", "", "activity", "Landroid/app/Activity;", "spanContext", "Lio/opentelemetry/api/trace/SpanContext;", "(Landroid/app/Activity;Lio/opentelemetry/api/trace/SpanContext;)V", "switchBrowserRequestHandler", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "(Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;Lio/opentelemetry/api/trace/SpanContext;)V", "span", "Lio/opentelemetry/api/trace/Span;", "getSpan", "()Lio/opentelemetry/api/trace/Span;", "span$delegate", "Lkotlin/Lazy;", "getSwitchBrowserRequestHandler", "()Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "isExpectingSwitchBrowserResume", "", "processSwitchBrowserResume", "", "authorizationRequest", "", "extras", "Landroid/os/Bundle;", "onSuccessAction", "Lkotlin/Function2;", "Landroid/net/Uri;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Companion", "common_distRelease"})
public final class SwitchBrowserProtocolCoordinator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SwitchBrowserRequestHandler switchBrowserRequestHandler;
    @Nullable
    private final SpanContext spanContext;
    @NotNull
    private final Lazy span$delegate;
    @NotNull
    private static final String TAG = "SwitchBrowserProtocolCoordinator";

    public SwitchBrowserProtocolCoordinator(@NotNull SwitchBrowserRequestHandler switchBrowserRequestHandler, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)switchBrowserRequestHandler, (String)"switchBrowserRequestHandler");
        this.switchBrowserRequestHandler = switchBrowserRequestHandler;
        this.spanContext = spanContext;
        this.span$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Span>(this){
            final /* synthetic */ SwitchBrowserProtocolCoordinator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Span invoke() {
                return OTelUtility.createSpanFromParent((String)SpanName.SwitchBrowserResume.name(), (SpanContext)SwitchBrowserProtocolCoordinator.access$getSpanContext$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ SwitchBrowserProtocolCoordinator(SwitchBrowserRequestHandler switchBrowserRequestHandler, SpanContext spanContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            spanContext = null;
        }
        this(switchBrowserRequestHandler, spanContext);
    }

    @NotNull
    public final SwitchBrowserRequestHandler getSwitchBrowserRequestHandler() {
        return this.switchBrowserRequestHandler;
    }

    public SwitchBrowserProtocolCoordinator(@NotNull Activity activity, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(new SwitchBrowserRequestHandler(activity, spanContext), spanContext);
    }

    @NotNull
    public final Span getSpan() {
        Lazy lazy = this.span$delegate;
        return (Span)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processSwitchBrowserResume(@NotNull String authorizationRequest, @NotNull Bundle extras, @NotNull Function2<? super Uri, ? super HashMap<String, String>, Unit> onSuccessAction) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)authorizationRequest, (String)"authorizationRequest");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter(onSuccessAction, (String)"onSuccessAction");
        AutoCloseable autoCloseable = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)this.getSpan());
        Throwable throwable = null;
        try {
            Scope it = (Scope)autoCloseable;
            boolean bl = false;
            String methodTag = "SwitchBrowserProtocolCoordinator:processSwitchBrowserResume";
            String actionUri = extras.getString("action_uri");
            String code = extras.getString("code");
            String state = extras.getString("state");
            CharSequence charSequence = actionUri;
            if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)code) == null || charSequence.length() == 0) {
                CharSequence charSequence2;
                StringBuilder stringBuilder = new StringBuilder().append("Action URI is null/empty: ").append((charSequence2 = (CharSequence)actionUri) == null || charSequence2.length() == 0).append(", code is null/empty: ");
                charSequence2 = code;
                ClientException clientException = new ClientException("missing_parameter", stringBuilder.append(charSequence2 == null || charSequence2.length() == 0).append('.').toString());
                this.getSpan().setStatus(StatusCode.ERROR);
                this.getSpan().recordException((Throwable)clientException);
                this.getSpan().end();
                throw clientException;
            }
            SwitchBrowserUriHelper.INSTANCE.statesMatch(authorizationRequest, state);
            Uri resumeUri = SwitchBrowserUriHelper.INSTANCE.buildResumeUri(actionUri, state);
            String authorizationHeaderValue = "Bearer " + code;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Authorization", (Object)authorizationHeaderValue)};
            HashMap headers = MapsKt.hashMapOf((Pair[])pairArray);
            onSuccessAction.invoke((Object)resumeUri, (Object)headers);
            this.switchBrowserRequestHandler.resetChallengeState();
            Logger.info(methodTag, "Switch browser resume action processed successfully.");
            this.getSpan().setAttribute(AttributeName.is_switch_browser_resume_handled.name(), true);
            this.getSpan().setStatus(StatusCode.OK);
            this.getSpan().end();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final boolean isExpectingSwitchBrowserResume() {
        String methodTag = "SwitchBrowserProtocolCoordinator:isExpectingSwitchBrowserResume";
        Logger.verbose(methodTag, "ExpectingRequest: " + this.switchBrowserRequestHandler.isSwitchBrowserChallengeActive());
        return this.switchBrowserRequestHandler.isSwitchBrowserChallengeActive();
    }

    public static final /* synthetic */ SpanContext access$getSpanContext$p(SwitchBrowserProtocolCoordinator $this) {
        return $this.spanContext;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserProtocolCoordinator$Companion;", "", "()V", "TAG", "", "getIntentToResumeWebViewAuth", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "intentDataString", "isSwitchBrowserResume", "", "url", "redirectUrl", "common_distRelease"})
    @SourceDebugExtension(value={"SMAP\nSwitchBrowserProtocolCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitchBrowserProtocolCoordinator.kt\ncom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserProtocolCoordinator$Companion\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,159:1\n29#2:160\n*S KotlinDebug\n*F\n+ 1 SwitchBrowserProtocolCoordinator.kt\ncom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserProtocolCoordinator$Companion\n*L\n79#1:160\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSwitchBrowserResume(@Nullable String url, @NotNull String redirectUrl) {
            Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
            return SwitchBrowserUriHelper.INSTANCE.isSwitchBrowserRedirectUrl(url, redirectUrl, "switch_browser_resume");
        }

        @NotNull
        public final Intent getIntentToResumeWebViewAuth(@NotNull Context context, @NotNull String intentDataString) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intentDataString, (String)"intentDataString");
            String $this$toUri$iv = intentDataString;
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
            Uri uri2 = uri;
            Intent $this$getIntentToResumeWebViewAuth_u24lambda_u240 = intent = new Intent(context, SwitchBrowserActivity.class);
            boolean bl = false;
            $this$getIntentToResumeWebViewAuth_u24lambda_u240.putExtra("action_uri", uri2.getQueryParameter("action_uri"));
            $this$getIntentToResumeWebViewAuth_u24lambda_u240.putExtra("code", uri2.getQueryParameter("code"));
            $this$getIntentToResumeWebViewAuth_u24lambda_u240.putExtra("state", uri2.getQueryParameter("state"));
            $this$getIntentToResumeWebViewAuth_u24lambda_u240.putExtra("resume_request", true);
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

