/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKeyPivProviderManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKitSmartcardSession;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyManager;
import com.yubico.yubikit.android.transport.usb.connection.UsbSmartCardConnection;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.PivSession;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;

public class YubiKitUsbSmartcardCertBasedAuthManager
extends AbstractUsbSmartcardCertBasedAuthManager {
    private static final String TAG = YubiKitUsbSmartcardCertBasedAuthManager.class.getSimpleName();
    private static final String DEVICE_ERROR_MESSAGE = "No USB device is currently connected.";
    public static final int YUBICO_VENDOR_ID = 4176;
    private final UsbYubiKeyManager mUsbYubiKeyManager;
    private UsbYubiKeyDevice mUsbDevice;
    private static final Object sDeviceLock = new Object();

    public YubiKitUsbSmartcardCertBasedAuthManager(@NonNull Context context) {
        this.mUsbYubiKeyManager = new UsbYubiKeyManager(context.getApplicationContext());
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        Collection usbDevices = usbManager.getDeviceList().values();
        for (UsbDevice device : usbDevices) {
            if (device.getVendorId() != 4176) continue;
            Logger.verbose(TAG, "A YubiKey device is plugged-in upon manager start-up.");
            this.mUsbDeviceInitiallyPluggedIn = true;
            return;
        }
    }

    @Override
    boolean startDiscovery(@NonNull Activity activity) {
        final String methodTag = TAG + ":startDiscovery";
        Logger.info(methodTag, "Starting YubiKey discovery for USB");
        this.mUsbYubiKeyManager.enable(new UsbConfiguration(), (Callback)new Callback<UsbYubiKeyDevice>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(@NonNull UsbYubiKeyDevice device) {
                Logger.info(methodTag, "A YubiKey device was connected via USB.");
                Object object = sDeviceLock;
                synchronized (object) {
                    YubiKitUsbSmartcardCertBasedAuthManager.this.mUsbDevice = device;
                    if (YubiKitUsbSmartcardCertBasedAuthManager.this.mConnectionCallback != null) {
                        YubiKitUsbSmartcardCertBasedAuthManager.this.mConnectionCallback.onCreateConnection();
                    }
                    YubiKitUsbSmartcardCertBasedAuthManager.this.mUsbDevice.setOnClosed(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Logger.info(methodTag, "A YubiKey device was disconnected via USB.");
                            Object object = sDeviceLock;
                            synchronized (object) {
                                YubiKitUsbSmartcardCertBasedAuthManager.this.mUsbDevice = null;
                            }
                            YubiKeyPivProviderManager.removePivProvider();
                            if (YubiKitUsbSmartcardCertBasedAuthManager.this.mDisconnectionCallback != null) {
                                YubiKitUsbSmartcardCertBasedAuthManager.this.mDisconnectionCallback.onClosedConnection();
                            }
                        }
                    });
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopDiscovery(@NonNull Activity activity) {
        String methodTag = TAG + ":stopDiscovery";
        Logger.info(methodTag, "Stopping YubiKey discovery for USB");
        Object object = sDeviceLock;
        synchronized (object) {
            this.mUsbDevice = null;
            this.mUsbYubiKeyManager.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void requestDeviceSession(final @NonNull AbstractSmartcardCertBasedAuthManager.ISessionCallback callback) {
        String methodTag = TAG + "requestDeviceSession:";
        Object object = sDeviceLock;
        synchronized (object) {
            if (this.isDeviceConnected()) {
                this.mUsbDevice.requestConnection(UsbSmartCardConnection.class, (Callback)new Callback<Result<UsbSmartCardConnection, IOException>>(){

                    public void invoke(@NonNull Result<UsbSmartCardConnection, IOException> value) {
                        try {
                            SmartCardConnection c = (SmartCardConnection)value.getValue();
                            PivSession piv = new PivSession(c);
                            YubiKitSmartcardSession session = new YubiKitSmartcardSession(piv);
                            callback.onGetSession(session);
                        }
                        catch (Exception e) {
                            callback.onException(e);
                        }
                    }
                });
                return;
            }
            Logger.error(methodTag, DEVICE_ERROR_MESSAGE, null);
            callback.onException(new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isDeviceConnected() {
        Object object = sDeviceLock;
        synchronized (object) {
            return this.mUsbDevice != null;
        }
    }

    @Override
    void initBeforeProceedingWithRequest(@NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        YubiKeyPivProviderManager.addPivProvider(telemetryHelper, this.getPivProviderCallback());
    }

    @Override
    void onDestroy(@NonNull Activity activity) {
        this.stopDiscovery(activity);
    }

    @NonNull
    Callback<Callback<Result<PivSession, Exception>>> getPivProviderCallback() {
        final String methodTag = TAG + "getPivProviderCallback:";
        return new Callback<Callback<Result<PivSession, Exception>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(final @NonNull Callback<Result<PivSession, Exception>> callback) {
                Object object = sDeviceLock;
                synchronized (object) {
                    if (YubiKitUsbSmartcardCertBasedAuthManager.this.isDeviceConnected()) {
                        YubiKitUsbSmartcardCertBasedAuthManager.this.mUsbDevice.requestConnection(UsbSmartCardConnection.class, (Callback)new Callback<Result<UsbSmartCardConnection, IOException>>(){

                            public void invoke(final @NonNull Result<UsbSmartCardConnection, IOException> value) {
                                callback.invoke((Object)Result.of((Callable)new Callable<PivSession>(){

                                    @Override
                                    public PivSession call() throws Exception {
                                        return new PivSession((SmartCardConnection)value.getValue());
                                    }
                                }));
                            }
                        });
                        return;
                    }
                    Logger.error(methodTag, YubiKitUsbSmartcardCertBasedAuthManager.DEVICE_ERROR_MESSAGE, null);
                    callback.invoke((Object)Result.failure((Throwable)new Exception(YubiKitUsbSmartcardCertBasedAuthManager.DEVICE_ERROR_MESSAGE)));
                }
            }
        };
    }
}

