/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;

public class SmartcardErrorDialog
extends SmartcardDialog {
    private final int mTitleStringResourceId;
    private final int mMessageStringResourceId;
    private final int mDismissButtonStringResourceId;
    private final IDismissCallback mDismissCallback;

    public SmartcardErrorDialog(int titleStringResourceId, int messageStringResourceId, int dismissButtonStringResourceId, @NonNull IDismissCallback dismissCallback, @NonNull Activity activity) {
        super(activity);
        this.mTitleStringResourceId = titleStringResourceId;
        this.mMessageStringResourceId = messageStringResourceId;
        this.mDismissButtonStringResourceId = dismissButtonStringResourceId;
        this.mDismissCallback = dismissCallback;
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SmartcardErrorDialog.this.mActivity, R.style.ErrorAlertDialogTheme).setTitle(SmartcardErrorDialog.this.mTitleStringResourceId).setMessage(SmartcardErrorDialog.this.mMessageStringResourceId).setPositiveButton(SmartcardErrorDialog.this.mDismissButtonStringResourceId, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SmartcardErrorDialog.this.mDismissCallback.onDismiss();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        SmartcardErrorDialog.this.mDismissCallback.onDismiss();
                    }
                });
                SmartcardErrorDialog.this.mDialog = dialog;
            }
        });
    }

    @Override
    void onUnexpectedUnplug() {
        this.mDismissCallback.onDismiss();
    }
}

