/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.webkit.ClientCertRequest;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.broker.AuthUxJavaScriptInterface;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.fido.AuthFidoChallengeHandler;
import com.microsoft.identity.common.internal.fido.CredManFidoManager;
import com.microsoft.identity.common.internal.fido.FidoChallenge;
import com.microsoft.identity.common.internal.fido.LegacyFido2ApiManager;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.PasskeyOriginRulesManager;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.ui.webview.ISendResultCallback;
import com.microsoft.identity.common.internal.ui.webview.OAuth2WebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.ProcessUtil;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.CertBasedAuthFactory;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.NonceRedirectHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ReAttachPrtHeaderHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserRequestHandler;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.broker.CommonTenantInfoProvider;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallengeFactory;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.IErrorInformation;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.BaggageExtension;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.ui.webview.authorization.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class AzureActiveDirectoryWebViewClient
extends OAuth2WebViewClient {
    private static final String TAG = AzureActiveDirectoryWebViewClient.class.getSimpleName();
    public static final String ERROR = "error";
    public static final String ERROR_DESCRIPTION = "error_description";
    private static final String DEVICE_CERT_ISSUER = "CN=MS-Organization-Access";
    private static final int THREAD_SLEEP_FOR_INTENT_LAUNCH_MS = 3;
    private final String mRedirectUrl;
    private final CertBasedAuthFactory mCertBasedAuthFactory;
    private AbstractCertBasedAuthChallengeHandler mCertBasedAuthChallengeHandler;
    private final SwitchBrowserRequestHandler mSwitchBrowserRequestHandler;
    private HashMap<String, String> mRequestHeaders;
    private String mRequestUrl;
    private boolean mInWebCpFlow = false;
    private boolean mAuthUxJavaScriptInterfaceAdded = false;
    private final boolean mIsWebViewWebCpEnabledInBrokerlessCase;
    private final SpanContext mSpanContext;
    private final String mUtid;
    private String mPasskeyRegistrationScript;

    public AzureActiveDirectoryWebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback, @NonNull String redirectUrl, @NonNull SwitchBrowserRequestHandler switchBrowserRequestHandler, @Nullable String utid, boolean isWebViewWebCpEnabledInBrokerlessCase) {
        super(activity, completionCallback, pageLoadedCallback);
        this.mRedirectUrl = redirectUrl;
        this.mCertBasedAuthFactory = new CertBasedAuthFactory(activity);
        this.mSwitchBrowserRequestHandler = switchBrowserRequestHandler;
        this.mUtid = utid;
        this.mSpanContext = activity instanceof AuthorizationActivity ? ((AuthorizationActivity)this.getActivity()).getSpanContext() : null;
        this.mIsWebViewWebCpEnabledInBrokerlessCase = isWebViewWebCpEnabledInBrokerlessCase;
    }

    public void initializeAuthUxJavaScriptApi(@NonNull WebView view, String url) {
        if (this.shouldExposeJavaScriptInterface(url)) {
            Logger.info(TAG, "Adding AuthUx JavaScript Interface");
            view.addJavascriptInterface((Object)new AuthUxJavaScriptInterface(), AuthUxJavaScriptInterface.Companion.getInterfaceName());
            this.mAuthUxJavaScriptInterfaceAdded = true;
        }
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.mAuthUxJavaScriptInterfaceAdded) {
            String jsScript = "window." + AuthUxJavaScriptInterface.Companion.getInterfaceName() + ".postMessageToBroker = function(message) {     window." + AuthUxJavaScriptInterface.Companion.getInterfaceName() + ".receiveAuthUxMessage(JSON.stringify(message)); };";
            view.evaluateJavascript(jsScript, null);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (StringUtil.isNullOrEmpty((String)url)) {
            throw new IllegalArgumentException("Redirect to empty url in web view.");
        }
        return this.handleUrl(view, url);
    }

    @TargetApi(value=24)
    @RequiresApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri requestUrl = request.getUrl();
        return this.handleUrl(view, requestUrl.toString());
    }

    public void setRequestHeaders(HashMap<String, String> requestHeaders) {
        this.mRequestHeaders = requestHeaders;
    }

    public void setRequestUrl(String requestUrl) {
        this.mRequestUrl = requestUrl;
    }

    private boolean handleUrl(WebView view, String url) {
        block24: {
            String methodTag = TAG + ":handleUrl";
            String formattedURL = url.toLowerCase(Locale.US);
            try {
                if (this.isPkeyAuthUrl(formattedURL)) {
                    Logger.info(methodTag, "WebView detected request for pkeyauth challenge.");
                    PKeyAuthChallengeFactory factory = new PKeyAuthChallengeFactory();
                    PKeyAuthChallenge pKeyAuthChallenge = factory.getPKeyAuthChallengeFromWebViewRedirect(url);
                    PKeyAuthChallengeHandler pKeyAuthChallengeHandler = new PKeyAuthChallengeHandler(view, this.getCompletionCallback());
                    pKeyAuthChallengeHandler.processChallenge(pKeyAuthChallenge);
                    break block24;
                }
                if (this.isPasskeyUrl(formattedURL)) {
                    Logger.info(methodTag, "WebView detected request for passkey protocol.");
                    FidoChallenge challenge = FidoChallenge.createFromRedirectUri(url);
                    Activity currentActivity = this.getActivity();
                    Context oTelContext = currentActivity instanceof AuthorizationActivity ? ((AuthorizationActivity)currentActivity).getOtelContext() : null;
                    LegacyFido2ApiManager legacyManager = currentActivity instanceof AuthorizationActivity && ((AuthorizationActivity)currentActivity).getFragment() instanceof WebViewAuthorizationFragment && CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_LEGACY_FIDO_SECURITY_KEY_LOGIC) && Build.VERSION.SDK_INT < 34 ? new LegacyFido2ApiManager(view.getContext(), (WebViewAuthorizationFragment)((AuthorizationActivity)currentActivity).getFragment()) : null;
                    AuthFidoChallengeHandler challengeHandler = new AuthFidoChallengeHandler(new CredManFidoManager(view.getContext(), legacyManager), view, oTelContext, ViewTreeLifecycleOwner.get((View)view));
                    challengeHandler.processChallenge(challenge);
                    break block24;
                }
                if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_ATTACH_NEW_PRT_HEADER_WHEN_NONCE_EXPIRED) && this.isNonceRedirect(formattedURL)) {
                    Logger.info(methodTag, "Navigation contains new nonce within the redirect uri.");
                    this.processNonceAndReAttachHeaders(view, url);
                    break block24;
                }
                if (this.isRedirectUrl(formattedURL)) {
                    Logger.info(methodTag, "Navigation starts with the redirect uri.");
                    if (this.mSwitchBrowserRequestHandler.isSwitchBrowserRequest(formattedURL, this.mRedirectUrl)) {
                        Logger.info(methodTag, "Request to switch browser.");
                        this.processSwitchBrowserRequest(url);
                    } else {
                        Logger.info(methodTag, "It is a redirect request.");
                        this.processRedirectUrl(view, url);
                    }
                    break block24;
                }
                if (this.isWebsiteRequestUrl(formattedURL)) {
                    Logger.info(methodTag, "It is an external website request");
                    this.processWebsiteRequest(view, url);
                    break block24;
                }
                if (this.isInstallRequestUrl(formattedURL)) {
                    Logger.info(methodTag, "It is an install request");
                    this.processInstallRequest(view, url);
                    break block24;
                }
                if (this.isWebCpUrl(formattedURL)) {
                    Logger.info(methodTag, "It is a request from WebCP");
                    this.processWebCpRequest(view, url);
                    break block24;
                }
                if (this.isPlayStoreUrl(formattedURL)) {
                    Logger.info(methodTag, "Request to open PlayStore.");
                    return this.processPlayStoreURL(view, url);
                }
                if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_PLAYSTORE_URL_LAUNCH) && this.isPlaystoreUrlToInstallBrokerApp(formattedURL)) {
                    Logger.info(methodTag, "Request to open PlayStore for broker app install.");
                    return this.processPlayStoreURLForBrokerApps(view, url);
                }
                if (this.isAuthAppMFAUrl(formattedURL)) {
                    Logger.info(methodTag, "Request to link account with Authenticator.");
                    this.processAuthAppMFAUrl(url);
                    break block24;
                }
                if (this.isAmazonAppRedirect(formattedURL)) {
                    Logger.info(methodTag, "It is an Amazon app request");
                    this.processAmazonAppUri(url);
                    break block24;
                }
                if (this.isInvalidRedirectUri(url)) {
                    Logger.info(methodTag, "Check for Redirect Uri.");
                    this.processInvalidRedirectUri(view, url);
                    break block24;
                }
                if (this.isBlankPageRequest(formattedURL)) {
                    Logger.info(methodTag, "It is an blank page request");
                    break block24;
                }
                if (this.isIntentRequestToInstallBrokerApp(formattedURL)) {
                    Logger.info(methodTag, "It is an intent request");
                    this.processIntentToInstallBrokerApp(view, url);
                    break block24;
                }
                if (!this.isUriSSLProtected(formattedURL)) {
                    Logger.info(methodTag, "Check for SSL protection");
                    this.processSSLProtectionCheck(view, url);
                    break block24;
                }
                if (this.isHeaderForwardingRequiredUri(url)) {
                    this.processHeaderForwardingRequiredUri(view, url);
                    break block24;
                }
                if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_ATTACH_PRT_HEADER_WHEN_CROSS_CLOUD) && this.isCrossCloudRedirect(formattedURL)) {
                    Logger.info(methodTag, "Navigation contains cross cloud redirect.");
                    this.processCrossCloudRedirect(view, url);
                    break block24;
                }
                if (this.mInWebCpFlow && this.isWebCpEnrollmentUrl(url)) {
                    Logger.info(methodTag, "Navigation contains web cp enrollment url.");
                    this.processWebCpEnrollmentUrl(view, url);
                    break block24;
                }
                if (this.mInWebCpFlow && this.isWebCpAuthorizeUrl(url)) {
                    this.processWebCpAuthorize(view, url);
                    break block24;
                }
                if (this.isDeviceCaRequest(url) && this.isHttpsScheme(url) && this.isWebCpInWebviewFeatureEnabled(url)) {
                    Logger.info(methodTag, "Navigation contains device CA request with https scheme.");
                    this.processDeviceCaRequest(view, url);
                    break block24;
                }
                Logger.info(methodTag, "This maybe a valid URI, but no special handling for this mentioned URI, hence deferring to WebView for loading.");
                this.processInvalidUrl(url);
                return false;
            }
            catch (ClientException exception) {
                Logger.error(methodTag, exception.getErrorCode(), null);
                Logger.errorPII(methodTag, exception.getMessage(), exception);
                this.returnError(exception.getErrorCode(), exception.getMessage());
                view.stopLoading();
            }
        }
        return true;
    }

    private boolean isUriSSLProtected(@NonNull String url) {
        return url.startsWith("https://");
    }

    private boolean isBlankPageRequest(@NonNull String url) {
        return "about:blank".equals(url);
    }

    private boolean isInvalidRedirectUri(@NonNull String url) {
        return this.isBrokerRequest(this.getActivity().getIntent()) && url.startsWith("msauth");
    }

    private boolean isAuthAppMFAUrl(@NonNull String url) {
        return url.startsWith("microsoft-authenticator://activatemfa");
    }

    private boolean isPlayStoreUrl(@NonNull String url) {
        return url.startsWith("market://details?id=");
    }

    private boolean isPlaystoreUrlToInstallBrokerApp(@NonNull String url) {
        if (url.startsWith("https://play.google.com/store/apps/details?id=")) {
            for (BrokerData brokerData : BrokerData.getAllBrokers()) {
                if (!url.contains("id=" + brokerData.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPkeyAuthUrl(@NonNull String url) {
        return url.startsWith("urn:http-auth:PKeyAuth".toLowerCase(Locale.ROOT));
    }

    private boolean isPasskeyUrl(@NonNull String url) {
        return url.startsWith("urn:http-auth:PassKey".toLowerCase(Locale.ROOT));
    }

    private boolean isRedirectUrl(@NonNull String url) {
        return url.startsWith(this.mRedirectUrl.toLowerCase(Locale.US));
    }

    private boolean isNonceRedirect(@NonNull String url) {
        return url.contains("sso_nonce");
    }

    private boolean isIntentRequestToInstallBrokerApp(@NonNull String url) {
        if (!url.startsWith("intent://")) {
            return false;
        }
        if (!url.contains(";package=com.android.vending;")) {
            return false;
        }
        for (BrokerData brokerData : BrokerData.getAllBrokers()) {
            if (!url.contains("id=" + brokerData.getPackageName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCrossCloudRedirect(@NonNull String url) {
        try {
            URL currentUrl = new URL(url);
            URL startUrl = new URL(this.mRequestUrl);
            if (AzureActiveDirectory.isValidCloudHost((URL)currentUrl) && AzureActiveDirectory.isValidCloudHost((URL)startUrl)) {
                Authority startUrlAuthority = Authority.getAuthorityFromAuthorityUrl((String)this.mRequestUrl);
                Authority currentLoadedUrlAuthority = Authority.getAuthorityFromAuthorityUrl((String)url);
                if (!startUrlAuthority.getAuthorityURL().getHost().equalsIgnoreCase(currentLoadedUrlAuthority.getAuthorityURL().getHost())) {
                    Logger.info(TAG, "Detected a cross cloud redirect.");
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            Logger.warn(TAG, "Failure in detecting if it is a cross cloud redirect url." + throwable);
        }
        return false;
    }

    private boolean isWebsiteRequestUrl(@NonNull String url) {
        return url.startsWith("browser://");
    }

    private boolean isInstallRequestUrl(@NonNull String url) {
        return url.startsWith("msauth://");
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        return callingIntent != null && !StringExtensions.isNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    private boolean isWebCpUrl(@NonNull String url) {
        return url.startsWith("companyportal://");
    }

    private boolean isAmazonAppRedirect(@NonNull String url) {
        return url.startsWith("aea://");
    }

    private boolean isWebCpEnrollmentUrl(@NonNull String url) {
        return url.startsWith("https://enterprise.google.com/android/enroll");
    }

    private boolean isWebCpAuthorizeUrl(@NonNull String url) {
        String methodTag = TAG + ":isWebCpAuthorizeUrl";
        try {
            URI uri = new URI(url);
            String host = uri.getHost();
            String path = uri.getPath();
            if (host == null || path == null) {
                Logger.verbose(methodTag, "URL missing host or path");
                return false;
            }
            if (!AzureActiveDirectory.isValidCloudHost((URL)new URL(url))) {
                Logger.info(methodTag, "URL host is not a valid Azure cloud host");
                return false;
            }
            if (!path.contains("/authorize")) {
                Logger.info(methodTag, "URL path does not contain /authorize");
                return false;
            }
            HashMap<String, String> queryParams = StringExtensions.getUrlParameters(url);
            String clientId = (String)queryParams.get("client_id");
            if (StringUtil.isNullOrEmpty((String)clientId)) {
                Logger.info(methodTag, "Authorize URL does not contain client_id");
                return false;
            }
            boolean isWebCpClient = "74bcdadc-2fdc-4bb3-8459-76d06952a0e9".equalsIgnoreCase(clientId);
            Logger.info(methodTag, isWebCpClient ? "WebCP authorize URL contains valid WebCP client_id." : "Not running WebCP flow as client_id in authorize is not webcp client_id");
            return isWebCpClient;
        }
        catch (MalformedURLException | URISyntaxException e) {
            Logger.info(methodTag, "Invalid URL: " + e.getMessage());
            return false;
        }
    }

    private boolean isHeaderForwardingRequiredUri(@NonNull String url) {
        boolean urlIsTrustedToReceiveHeaders = url.startsWith("https://login.live.com/");
        boolean originalRequestHasHeaders = this.mRequestHeaders != null && !this.mRequestHeaders.isEmpty();
        return urlIsTrustedToReceiveHeaders && originalRequestHasHeaders;
    }

    private void processRedirectUrl(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processRedirectUrl";
        Logger.info(methodTag, "It is pointing to redirect. Final url can be processed to get the code or error.");
        RawAuthorizationResult data = RawAuthorizationResult.fromRedirectUri((String)url);
        this.getCompletionCallback().onChallengeResponseReceived(data);
        view.stopLoading();
    }

    private void processSwitchBrowserRequest(@NonNull String url) {
        String methodTag = TAG + ":processSwitchBrowserRequest";
        try {
            this.mSwitchBrowserRequestHandler.processChallenge(SwitchBrowserChallenge.constructFromRedirectUrl(url, this.mRequestUrl));
        }
        catch (Throwable throwable) {
            Logger.error(methodTag, "Switch browser challenge could not be processed.", throwable);
            String errorCode = throwable instanceof IErrorInformation ? ((IErrorInformation)throwable).getErrorCode() : "unknown_error";
            this.returnError(errorCode, throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting(otherwise=2)
    protected void processWebsiteRequest(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processWebsiteRequest";
        view.stopLoading();
        Span span2 = this.createSpanWithAttributesFromParent(SpanName.ProcessWebsiteRequest.name());
        span2.setAttribute(AttributeName.is_in_web_cp_flow.name(), this.mInWebCpFlow);
        try (Scope scope = SpanExtension.makeCurrentSpan((Span)span2);){
            if (this.isDeviceCaRequest(url)) {
                this.processDeviceCaRequest(view, url);
                span2.setStatus(StatusCode.OK);
                return;
            }
            if (this.isRedirectToPlaystoreToInstallCp(url) && this.mInWebCpFlow) {
                this.handlePlaystoreLaunchUrlFromWebCp(url);
                span2.setStatus(StatusCode.OK);
                return;
            }
            this.handleBrowserRedirect(methodTag, url);
            span2.setStatus(StatusCode.OK);
            return;
        }
        catch (Throwable throwable) {
            Logger.error(methodTag, "Failed to open link in browser.", throwable);
            span2.recordException(throwable);
            span2.setStatus(StatusCode.ERROR);
            this.returnError("unexpected_error", "No browser found to open the link.");
            return;
        }
        finally {
            span2.end();
        }
    }

    private void handleBrowserRedirect(@NonNull String methodTag, @NonNull String url) {
        Logger.info(methodTag, "Not a device CA request. Redirecting to browser.");
        this.openLinkInBrowser(url);
        RawAuthorizationResult.ResultCode resultCode = this.mInWebCpFlow ? RawAuthorizationResult.ResultCode.MDM_FLOW : RawAuthorizationResult.ResultCode.CANCELLED;
        Logger.info(methodTag, "Returning result code: " + resultCode);
        this.returnResult(resultCode);
    }

    private void handlePlaystoreLaunchUrlFromWebCp(@NonNull String url) {
        String methodTag = TAG + ":handlePlaystoreLaunchUrlFromWebCp";
        Logger.info(methodTag, "Handling playstore launch URL from WebCP.");
        SpanExtension.current().setAttribute(AttributeName.is_redirect_to_playstore_launch_from_webcp.name(), true);
        this.openLinkInBrowser(url);
        this.returnResult(RawAuthorizationResult.ResultCode.MDM_FLOW);
    }

    private boolean isRedirectToPlaystoreToInstallCp(@NonNull String url) {
        if (url.contains("https://play.google.com/store/apps/details?id=com.microsoft.windowsintune.companyportal")) {
            Logger.info(TAG, "Redirect to Playstore to install Company Portal app.");
            return true;
        }
        return false;
    }

    private void processDeviceCaRequest(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processDeviceCaRequest";
        Logger.info(methodTag, "This is a device CA request.");
        if (this.shouldLaunchCompanyPortal()) {
            try {
                this.launchCompanyPortal();
                return;
            }
            catch (Exception ex) {
                Logger.warn(methodTag, "Failed to launch Company Portal, falling back to browser.");
            }
        }
        this.loadDeviceCaUrl(url, view);
    }

    private boolean isDeviceCaRequest(@NonNull String url) {
        return url.contains("&ismdmurl=1");
    }

    private boolean isHttpsScheme(@NonNull String url) {
        return url.startsWith("https");
    }

    private boolean shouldLaunchCompanyPortal() {
        PackageHelper packageHelper = new PackageHelper(this.getActivity().getPackageManager());
        return packageHelper.isPackageInstalledAndEnabled("com.microsoft.skype.teams.ipphone") && "iPULpH0pq8ms1Qy7cOzGsVRQN7/zW4IbW+UKcajvtrTrzM5o5VcaghNEA1Ho4Wq7ay0efqqJcalxa8eHxVnHKA==".equals(packageHelper.getSha512SignatureForPackage("com.microsoft.skype.teams.ipphone")) && packageHelper.isPackageInstalledAndEnabled("com.microsoft.windowsintune.companyportal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void loadDeviceCaUrl(@NonNull String originalUrl, @NonNull WebView view) {
        String methodTag = TAG + ":loadDeviceCaUrl";
        Span span2 = this.createSpanWithAttributesFromParent(SpanName.ProcessWebCpRedirects.name());
        try (Scope scope = SpanExtension.makeCurrentSpan((Span)span2);){
            if (this.isWebCpInWebviewFeatureEnabled(originalUrl)) {
                Logger.info(methodTag, "Loading device CA request in WebView.");
                span2.setAttribute(AttributeName.is_webcp_in_webview_enabled.name(), true);
                String httpsUrl = originalUrl.replace("browser://", "https://");
                view.loadUrl(httpsUrl, this.mRequestHeaders);
            } else {
                Logger.info(methodTag, "Loading device CA request in browser.");
                span2.setAttribute(AttributeName.is_webcp_in_webview_enabled.name(), false);
                this.openLinkInBrowser(originalUrl);
                this.returnResult(RawAuthorizationResult.ResultCode.MDM_FLOW);
            }
            span2.setStatus(StatusCode.OK);
        }
        catch (Throwable throwable) {
            Logger.error(methodTag, "Failed to load device CA URL in WebView.", throwable);
            span2.recordException(throwable);
            span2.setStatus(StatusCode.ERROR);
            this.returnError("unknown_error", throwable.getMessage());
        }
        finally {
            span2.end();
        }
    }

    @VisibleForTesting(otherwise=2)
    protected boolean isWebCpInWebviewFeatureEnabled(@NonNull String originalUrl) {
        String methodTag = TAG + ":isWebCpInWebviewFeatureEnabled";
        try {
            String homeTenantId;
            if (!ProcessUtil.isRunningOnAuthService(this.getActivity().getApplicationContext())) {
                this.mInWebCpFlow = this.mIsWebViewWebCpEnabledInBrokerlessCase;
                Logger.info(methodTag, "Not running on AuthService, WebCP in WebView feature enabled? " + this.mIsWebViewWebCpEnabledInBrokerlessCase);
                return this.mInWebCpFlow;
            }
            String string2 = homeTenantId = !StringUtil.isNullOrEmpty((String)this.mUtid) ? this.mUtid : this.getHomeTenantIdFromUrl(originalUrl);
            if (StringUtil.isNullOrEmpty((String)homeTenantId)) {
                Logger.info(methodTag, "Home tenantId is empty");
                return false;
            }
            long webCpGetFlightStartTime = System.currentTimeMillis();
            int waitForFlightsTimeOut = CommonFlightsManager.INSTANCE.getFlightsProvider().getIntValue((IFlightConfig)CommonFlight.WEB_CP_WAIT_TIMEOUT_FOR_FLIGHTS);
            boolean isWebCpFlightEnabled = CommonFlightsManager.INSTANCE.getFlightsProviderForTenant(homeTenantId, (long)waitForFlightsTimeOut).isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_WEB_CP_IN_WEBVIEW);
            SpanExtension.current().setAttribute(AttributeName.web_cp_flight_get_time.name(), System.currentTimeMillis() - webCpGetFlightStartTime);
            SpanExtension.current().setAttribute(AttributeName.tenant_id.name(), homeTenantId);
            if (isWebCpFlightEnabled) {
                Logger.info(methodTag, "WebCP in WebView feature is enabled.");
                this.mInWebCpFlow = true;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            Logger.error(methodTag, "Failed to check if WebCP in WebView feature is enabled.", throwable);
            return false;
        }
    }

    private String getHomeTenantIdFromUrl(@NonNull String url) {
        String username = StringExtensions.getUrlParameters(url).get("login_hint");
        if (StringUtil.isNullOrEmpty((String)username)) {
            return null;
        }
        return CommonTenantInfoProvider.INSTANCE.getHomeTenantId(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWebCpEnrollmentUrl(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processWebCpEnrollmentUrl";
        Span span2 = this.createSpanWithAttributesFromParent(SpanName.ProcessWebCpEnrollmentRedirect.name());
        try (Scope scope = SpanExtension.makeCurrentSpan((Span)span2);){
            view.stopLoading();
            Logger.info(methodTag, "Loading WebCP enrollment url in browser.");
            this.openGoogleEnrollmentUrl(url);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    AzureActiveDirectoryWebViewClient.this.returnResult(RawAuthorizationResult.ResultCode.MDM_FLOW);
                }
            }, TimeUnit.SECONDS.toMillis(3L));
            span2.setStatus(StatusCode.OK);
        }
        catch (Throwable throwable) {
            Logger.error(methodTag, "Failed to process WebCP enrollment URL.", throwable);
            span2.recordException(throwable);
            span2.setStatus(StatusCode.ERROR);
            this.returnError("unknown_error", throwable.getMessage());
        }
        finally {
            span2.end();
        }
    }

    private void openGoogleEnrollmentUrl(@NonNull String url) {
        String methodTag = TAG + ":openGoogleEnrollmentUrl";
        Logger.info(methodTag, "Opening Google enrollment URL");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10008000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "Failed to open the intent for google enrollment.", e);
            throw e;
        }
    }

    private boolean processPlayStoreURL(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processPlayStoreURL";
        view.stopLoading();
        if (!url.startsWith("market://details?id=com.microsoft.windowsintune.companyportal") && !url.startsWith("market://details?id=com.azure.authenticator")) {
            Logger.info(methodTag, "The URI is either trying to open an unknown application or contains unknown query parameters");
            return false;
        }
        String appPackageName = this.getBrokerAppPackageNameFromUrl(url);
        Logger.info(methodTag, "Request to open PlayStore to install package : '" + appPackageName + "'");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName)));
            intent.addFlags(0x10008000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "PlayStore is not present on the device", e);
        }
        return true;
    }

    private boolean processPlayStoreURLForBrokerApps(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processPlayStoreURL";
        String appPackageName = this.getBrokerAppPackageNameFromUrl(url);
        Logger.info(methodTag, "Request to open PlayStore to install package : '" + appPackageName + "'");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + appPackageName)));
            this.getActivity().startActivity(intent);
            view.stopLoading();
            return true;
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "PlayStore is not present on the device", e);
        }
        catch (Exception e) {
            Logger.error(methodTag, "Failed to intercept install broker playstore URL and launch the intent", e);
        }
        return false;
    }

    private void processAuthAppMFAUrl(String url) {
        String methodTag = TAG + ":processAuthAppMFAUrl";
        Logger.verbose(methodTag, "Linking Account in Broker for MFA.");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "Failed to open the Authenticator application.", e);
        }
    }

    private void launchCompanyPortal() {
        String methodTag = TAG + ":launchCompanyPortal";
        Logger.verbose(methodTag, "Sending intent to launch the CompanyPortal.");
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.microsoft.windowsintune.companyportal", "com.microsoft.windowsintune.companyportal.views.SplashActivity"));
        intent.addFlags(0x10008000);
        this.getActivity().startActivity(intent);
        this.returnResult(RawAuthorizationResult.ResultCode.MDM_FLOW);
    }

    private void processAmazonAppUri(@NonNull String url) {
        String methodTag = TAG + ":processAmazonAppUri";
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.getActivity().startActivity(intent);
        Logger.info(methodTag, "Sent Intent to launch Amazon app");
    }

    @VisibleForTesting(otherwise=2)
    protected void openLinkInBrowser(String url) {
        String methodTag = TAG + ":openLinkInBrowser";
        Logger.info(methodTag, "Try to open url link in browser");
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.getActivity().startActivity(intent);
        } else {
            Logger.warn(methodTag, "Unable to find an app to resolve the activity.");
        }
    }

    private void processWebCpRequest(@NonNull WebView view, @NonNull String url) {
        view.stopLoading();
        if (url.equalsIgnoreCase("companyportal://enrollment")) {
            this.launchCompanyPortal();
            return;
        }
        this.returnError("webcp_uri_invalid", "Unexpected URL from WebCP: " + url);
    }

    private void processInstallRequest(final @NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processInstallRequest";
        RawAuthorizationResult result = RawAuthorizationResult.fromRedirectUri((String)url);
        if (result.getResultCode() != RawAuthorizationResult.ResultCode.BROKER_INSTALLATION_TRIGGERED) {
            this.getCompletionCallback().onChallengeResponseReceived(result);
            view.stopLoading();
            return;
        }
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        final String appLink = (String)parameters.get("app_link");
        Logger.info(methodTag, "Launching the link to app:" + appLink);
        this.getCompletionCallback().onChallengeResponseReceived(result);
        Handler handler = new Handler();
        int threadSleepForCallingActivity = 1000;
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                String link = appLink.replace("browser://", "https://");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                AzureActiveDirectoryWebViewClient.this.getActivity().startActivity(intent);
                view.stopLoading();
            }
        }, 1000L);
        view.stopLoading();
    }

    private void processInvalidRedirectUri(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processInvalidRedirectUri";
        Logger.error(methodTag, "The RedirectUri is not as expected.", null);
        Logger.errorPII(methodTag, String.format("Received %s and expected %s", url, this.mRedirectUrl), null);
        this.returnError("The redirectUri for broker is invalid", String.format("The RedirectUri is not as expected. Received %s and expected %s", url, this.mRedirectUrl));
        view.stopLoading();
    }

    private void processIntentToInstallBrokerApp(@NonNull WebView view, @NonNull String intentUrl) {
        String methodTag = TAG + ":processIntentToInstallBrokerApp";
        try {
            Intent intent = Intent.parseUri((String)intentUrl, (int)1);
            if (intent != null && intent.getPackage() != null) {
                view.getContext().startActivity(intent);
                Logger.info(methodTag, "Intent request sent to launch the app: " + intent.getPackage());
            } else {
                Logger.warn(methodTag, "Unable to parse the intent URI");
            }
        }
        catch (URISyntaxException e) {
            Logger.error(methodTag, "Failed to parse the intent URI due to invalid syntax.", e);
            this.returnError("uri_syntax_error", e.getMessage());
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "No activity found to handle the intent.", e);
            this.returnError("activity_not_found", e.getMessage());
        }
        catch (Throwable throwable) {
            Logger.error(methodTag, "An unexpected error occurred while processing the intent URI.", throwable);
            this.returnError("unexpected_error", throwable.getMessage());
        }
    }

    private void processSSLProtectionCheck(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processSSLProtectionCheck";
        String redactedUrl = this.removeQueryParametersOrRedact(url);
        Logger.error(methodTag, "The webView was redirected to an unsafe URL: " + redactedUrl, null);
        this.returnError("Redirect url scheme not SSL protected", "The webView was redirected to an unsafe URL.");
        view.stopLoading();
    }

    private void processInvalidUrl(@NonNull String url) {
        String methodTag = TAG + ":processInvalidUrl";
        Logger.infoPII(methodTag, "We are declining to override loading and redirect to invalid URL: '" + this.removeQueryParametersOrRedact(url) + "' the user's url pattern is '" + this.mRedirectUrl + "'");
    }

    private void processHeaderForwardingRequiredUri(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processHeaderForwardingRequiredUri";
        Logger.infoPII(methodTag, "We are loading this new URL: '" + this.removeQueryParametersOrRedact(url) + "' with original requestHeaders appended.");
        view.loadUrl(url, this.mRequestHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNonceAndReAttachHeaders(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processNonceAndReAttachHeaders";
        HashMap<String, String> queryParams = StringExtensions.getUrlParameters(url);
        String nonceQueryParam = queryParams.get("sso_nonce");
        SpanExtension.current().setAttribute(AttributeName.is_sso_nonce_found_in_ests_request.name(), nonceQueryParam != null);
        if (nonceQueryParam != null) {
            Span span2 = OTelUtility.createSpanFromParent((String)SpanName.ProcessNonceFromEstsRedirect.name(), (SpanContext)this.mSpanContext);
            try (Scope scope = SpanExtension.makeCurrentSpan((Span)span2);){
                NonceRedirectHandler nonceRedirect = new NonceRedirectHandler(view, this.mRequestHeaders, span2);
                nonceRedirect.processChallenge(new URL(url));
                span2.setStatus(StatusCode.OK);
            }
            catch (MalformedURLException e) {
                Logger.errorPII(methodTag, "Redirect URI has invalid syntax, unable to parse", e);
                span2.setStatus(StatusCode.ERROR, "Redirect URI has invalid syntax, unable to parse");
                span2.recordException((Throwable)e);
            }
            catch (Throwable throwable) {
                Logger.error(methodTag, "Error processing nonce and re-attaching headers", throwable);
                span2.setStatus(StatusCode.ERROR, "Error processing nonce and re-attaching headers");
                span2.recordException(throwable);
                view.loadUrl(url, this.mRequestHeaders);
            }
            finally {
                span2.end();
            }
        }
    }

    private void processWebCpAuthorize(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processWebCPAuthorize";
        Logger.info(methodTag, "Processing WebCP authorize request.");
        Span span2 = this.createSpanWithAttributesFromParent(SpanName.ProcessWebCpAuthorizeUrlRedirect.name());
        ReAttachPrtHeaderHandler reAttachPrtHeaderHandler = new ReAttachPrtHeaderHandler(view, this.mRequestHeaders, span2);
        this.reAttachPrtHeader(url, reAttachPrtHeaderHandler, view, methodTag, span2);
    }

    private void processCrossCloudRedirect(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processCrossCloudRedirect";
        Span span2 = OTelUtility.createSpanFromParent((String)SpanName.ProcessCrossCloudRedirect.name(), (SpanContext)this.mSpanContext);
        ReAttachPrtHeaderHandler reAttachPrtHeaderHandler = new ReAttachPrtHeaderHandler(view, this.mRequestHeaders, span2);
        this.reAttachPrtHeader(url, reAttachPrtHeaderHandler, view, methodTag, span2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=2)
    public void reAttachPrtHeader(@NonNull String url, @NonNull ReAttachPrtHeaderHandler reAttachPrtHandler, @NonNull WebView view, @NonNull String methodTag, @NonNull Span span2) {
        try (Scope scope = SpanExtension.makeCurrentSpan((Span)span2);){
            reAttachPrtHandler.processChallenge(url);
            span2.setStatus(StatusCode.OK);
        }
        catch (Throwable e) {
            Logger.warn(methodTag, "Error attaching PRT header." + e);
            span2.recordException(e);
            span2.setStatus(StatusCode.ERROR);
            view.loadUrl(url);
        }
        finally {
            span2.end();
        }
    }

    private String removeQueryParametersOrRedact(@NonNull String url) {
        String methodTag = TAG + ":removeQueryParametersOrRedact";
        try {
            return StringExtensions.removeQueryParameterFromUrl(url);
        }
        catch (URISyntaxException e) {
            Logger.errorPII(methodTag, "Redirect URI has invalid syntax, unable to parse", e);
            return "redacted";
        }
    }

    private void returnResult(RawAuthorizationResult.ResultCode resultCode) {
        this.getCompletionCallback().onChallengeResponseReceived(RawAuthorizationResult.fromResultCode((RawAuthorizationResult.ResultCode)resultCode));
    }

    private void returnError(String errorCode, String errorMessage) {
        this.getCompletionCallback().onChallengeResponseReceived(RawAuthorizationResult.fromException((BaseException)((Object)new ClientException(errorCode, errorMessage))));
    }

    public void onReceivedClientCertRequest(@NonNull WebView view, final @NonNull ClientCertRequest clientCertRequest) {
        String methodTag = TAG + ":onReceivedClientCertRequest";
        Principal[] acceptableCertIssuers = clientCertRequest.getPrincipals();
        if (acceptableCertIssuers != null) {
            for (Principal issuer : acceptableCertIssuers) {
                if (!issuer.getName().contains(DEVICE_CERT_ISSUER)) continue;
                String message = "Cancelling the TLS request, not responding to TLS challenge triggered by device authentication.";
                Logger.info(methodTag, "Cancelling the TLS request, not responding to TLS challenge triggered by device authentication.");
                clientCertRequest.cancel();
                return;
            }
        }
        if (this.mCertBasedAuthChallengeHandler != null) {
            this.mCertBasedAuthChallengeHandler.cleanUp();
        }
        this.mCertBasedAuthFactory.createCertBasedAuthChallengeHandler(new CertBasedAuthFactory.CertBasedAuthChallengeHandlerCallback(){

            @Override
            public void onReceived(@Nullable AbstractCertBasedAuthChallengeHandler challengeHandler) {
                AzureActiveDirectoryWebViewClient.this.mCertBasedAuthChallengeHandler = challengeHandler;
                if (AzureActiveDirectoryWebViewClient.this.mCertBasedAuthChallengeHandler == null) {
                    clientCertRequest.cancel();
                    return;
                }
                AzureActiveDirectoryWebViewClient.this.mCertBasedAuthChallengeHandler.processChallenge(clientCertRequest);
            }
        });
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        if (this.mPasskeyRegistrationScript != null && PasskeyOriginRulesManager.isAllowedOrigin(url)) {
            Logger.verbose(TAG, "Executing onPageStarted PasskeyRegistration script for URL: " + url);
            view.evaluateJavascript(this.mPasskeyRegistrationScript, null);
        }
    }

    public void onDestroy() {
        if (this.mCertBasedAuthChallengeHandler != null) {
            this.mCertBasedAuthChallengeHandler.cleanUp();
        }
        this.mCertBasedAuthFactory.onDestroy();
    }

    public void finalizeBeforeSendingResult(@NonNull RawAuthorizationResult response, @NonNull ISendResultCallback callback) {
        if (this.mCertBasedAuthChallengeHandler == null) {
            callback.onResultReady();
            return;
        }
        this.mCertBasedAuthChallengeHandler.emitTelemetryForCertBasedAuthResults(response);
        if (!(this.mCertBasedAuthChallengeHandler instanceof AbstractSmartcardCertBasedAuthChallengeHandler)) {
            callback.onResultReady();
            return;
        }
        ((AbstractSmartcardCertBasedAuthChallengeHandler)this.mCertBasedAuthChallengeHandler).promptSmartcardRemovalForResult(callback);
    }

    private String getBrokerAppPackageNameFromUrl(@NonNull String url) {
        for (BrokerData brokerData : BrokerData.getAllBrokers()) {
            if (!url.contains(brokerData.getPackageName())) continue;
            return brokerData.getPackageName();
        }
        Logger.warn(TAG + ":getBrokerAppPackageNameFromUrl", "No known broker app package name found in URL: " + url);
        return "";
    }

    private Span createSpanWithAttributesFromParent(@NonNull String spanName) {
        Context oTelContext;
        Span span2 = OTelUtility.createSpanFromParent((String)spanName, (SpanContext)this.mSpanContext);
        if (this.mUtid != null) {
            span2.setAttribute(AttributeName.tenant_id.name(), this.mUtid);
        }
        Context context = oTelContext = this.getActivity() instanceof AuthorizationActivity ? ((AuthorizationActivity)this.getActivity()).getOtelContext() : null;
        if (oTelContext != null) {
            Baggage baggage = BaggageExtension.fromContext((Context)oTelContext);
            List<AttributeName> parentAttributeNames = Arrays.asList(AttributeName.correlation_id, AttributeName.calling_package_name);
            for (AttributeName attributeName : parentAttributeNames) {
                String value = baggage.getEntryValue(attributeName.name());
                if (value == null) continue;
                span2.setAttribute(attributeName.name(), value);
            }
        }
        return span2;
    }

    public void addPasskeyRegistrationJsScript(@NonNull String script) {
        this.mPasskeyRegistrationScript = script;
    }
}

