/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import com.microsoft.identity.common.logging.Logger;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyOriginRulesManager;", "", "()V", "ALLOWED_ORIGIN_PPE", "", "", "FIDO_SEGMENT", "HTTPS_SCHEME", "PRODUCTION_ORIGINS", "SOVEREIGN_CLOUD_ORIGINS", "TAG", "getAllowedOriginRules", "hasFidoPathSegment", "", "path", "isAllowedOrigin", "url", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nPasskeyOriginRulesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasskeyOriginRulesManager.kt\ncom/microsoft/identity/common/internal/providers/oauth2/PasskeyOriginRulesManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1747#2,3:162\n*S KotlinDebug\n*F\n+ 1 PasskeyOriginRulesManager.kt\ncom/microsoft/identity/common/internal/providers/oauth2/PasskeyOriginRulesManager\n*L\n145#1:162,3\n*E\n"})
public final class PasskeyOriginRulesManager {
    @NotNull
    public static final PasskeyOriginRulesManager INSTANCE = new PasskeyOriginRulesManager();
    @NotNull
    private static final String TAG = "PasskeyOriginRulesManager";
    @NotNull
    private static final String HTTPS_SCHEME = "https";
    @NotNull
    private static final String FIDO_SEGMENT = "fido";
    @NotNull
    private static final Set<String> PRODUCTION_ORIGINS;
    @NotNull
    private static final Set<String> SOVEREIGN_CLOUD_ORIGINS;
    @NotNull
    private static final Set<String> ALLOWED_ORIGIN_PPE;

    private PasskeyOriginRulesManager() {
    }

    @JvmStatic
    public static final boolean isAllowedOrigin(@NotNull String url) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URI uri = new URI(url);
            String string2 = uri.getScheme();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.scheme");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (!Intrinsics.areEqual((Object)string3, (Object)HTTPS_SCHEME)) {
                return false;
            }
            String string4 = uri.getHost();
            if (string4 == null) {
                return false;
            }
            String host = string4;
            String string5 = ("https://" + host).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String origin = string5;
            if (PRODUCTION_ORIGINS.contains(origin)) {
                return true;
            }
            if (SOVEREIGN_CLOUD_ORIGINS.contains(origin)) {
                return INSTANCE.hasFidoPathSegment(uri.getPath());
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Logger.error(TAG, "Error validating origin for URL.", throwable);
            bl = false;
        }
        return bl;
    }

    private final boolean hasFidoPathSegment(String path) {
        boolean bl;
        block4: {
            CharSequence charSequence = path;
            if (charSequence == null || charSequence.length() == 0) {
                return false;
            }
            String[] stringArray = new String[]{"/"};
            List segments = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$any$iv = segments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)FIDO_SEGMENT, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Set<String> getAllowedOriginRules() {
        return SetsKt.plus(PRODUCTION_ORIGINS, (Iterable)SOVEREIGN_CLOUD_ORIGINS);
    }

    static {
        Object[] objectArray = new String[]{"https://login.microsoft.com", "https://account.live.com", "https://mysignins.microsoft.com", "https://mysignins.azure.us", "https://mysignins.microsoft.scloud", "https://mysignins.eaglex.ic.gov"};
        PRODUCTION_ORIGINS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"https://login.microsoftonline.us", "https://login.microsoftonline.microsoft.scloud", "https://login.microsoftonline.eaglex.ic.gov", "https://login.sovcloud-identity.fr", "https://login.sovcloud-identity.de", "https://login.sovcloud-identity.sg"};
        SOVEREIGN_CLOUD_ORIGINS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"https://account.live-int.com", "https://login.windows-ppe.net", "https://mysignins-ppe.microsoft.com"};
        ALLOWED_ORIGIN_PPE = SetsKt.setOf((Object[])objectArray);
    }
}

