/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.migration;

import com.microsoft.identity.common.internal.migration.IMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TokenMigrationUtility<T extends BaseAccount, U extends RefreshToken> {
    private static final String TAG = TokenMigrationUtility.class.getSimpleName();
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();

    public void _import(final IMigrationAdapter<T, U> adapter, final Map<String, String> credentials, final IShareSingleSignOnState<T, U> destination, final TokenMigrationCallback callback) {
        final String methodTag = TAG + ":_import";
        sBackgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int accountsAdded = 0;
                for (Map.Entry accountTokenKeyValuePair : adapter.adapt(credentials)) {
                    try {
                        destination.setSingleSignOnState((BaseAccount)accountTokenKeyValuePair.getKey(), (RefreshToken)accountTokenKeyValuePair.getValue());
                        ++accountsAdded;
                    }
                    catch (ClientException e) {
                        Logger.warn(methodTag, "Failed to save account/refresh token . Skipping ");
                    }
                }
                callback.onMigrationFinished(accountsAdded);
            }
        });
    }
}

