/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.AbstractIpcStrategyWithServiceValidation;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.ContentProviderStatusLoader;
import com.microsoft.identity.common.internal.broker.ipc.IContentProviderStatusLoader;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.util.ParcelableUtil;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;

public class ContentProviderStrategy
extends AbstractIpcStrategyWithServiceValidation {
    private static final String TAG = ContentProviderStrategy.class.getSimpleName();
    private final Context mContext;
    private final IContentProviderStatusLoader mCache;

    public ContentProviderStrategy(Context context, IPlatformComponents components) {
        super(false);
        this.mContext = context;
        this.mCache = new ContentProviderStatusLoader(context, components);
    }

    @VisibleForTesting
    protected ContentProviderStrategy(Context context, IContentProviderStatusLoader cache, boolean shouldBypassSupportValidation) {
        super(shouldBypassSupportValidation);
        this.mContext = context;
        this.mCache = cache;
    }

    @Override
    @Nullable
    protected Bundle communicateToBrokerAfterValidation(@NonNull BrokerOperationBundle brokerOperationBundle) throws BrokerCommunicationException {
        Cursor cursor;
        String methodTag = TAG + ":communicateToBroker";
        String operationName = brokerOperationBundle.getOperation().name();
        Logger.info(methodTag, "Broker operation name: " + operationName + " brokerPackage: " + brokerOperationBundle.getTargetBrokerAppPackageName());
        Uri uri = this.getContentProviderURI(brokerOperationBundle.getTargetBrokerAppPackageName(), brokerOperationBundle.getContentProviderPath());
        Logger.info(methodTag, "Request to BrokerContentProvider for uri path " + brokerOperationBundle.getContentProviderPath());
        String marshalledRequestString = null;
        Bundle requestBundle = brokerOperationBundle.getBundle();
        if (requestBundle != null) {
            byte[] marshalledBytes = ParcelableUtil.marshall((Parcelable)requestBundle);
            marshalledRequestString = Base64.encodeToString((byte[])marshalledBytes, (int)0);
        }
        if ((cursor = this.mContext.getContentResolver().query(uri, null, marshalledRequestString, null, null)) != null) {
            try {
                Bundle resultBundle = cursor.getExtras();
                if (resultBundle == null) {
                    String message = "Received an empty bundle. This means the operation is not supported on the other side. If you're using a newer feature, please bump the minimum protocol version.";
                    Logger.error(methodTag, "Received an empty bundle. This means the operation is not supported on the other side. If you're using a newer feature, please bump the minimum protocol version.", null);
                    throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, this.getType(), "Received an empty bundle. This means the operation is not supported on the other side. If you're using a newer feature, please bump the minimum protocol version.", null);
                }
                Logger.info(methodTag, "Received successful result from Broker Content Provider.");
                Bundle message = resultBundle;
                return message;
            }
            catch (RuntimeException exception) {
                String message = "Failed to get result from Broker Content Provider";
                Logger.error(methodTag, "Failed to get result from Broker Content Provider", exception);
                throw new BrokerCommunicationException(BrokerCommunicationException.Category.CONNECTION_ERROR, this.getType(), "Failed to get result from Broker Content Provider", null);
            }
            finally {
                cursor.close();
            }
        }
        String message = "Failed to get result from Broker Content Provider, cursor is null";
        Logger.error(methodTag, "Failed to get result from Broker Content Provider, cursor is null", null);
        throw new BrokerCommunicationException(BrokerCommunicationException.Category.NULL_CURSOR, this.getType(), "Failed to get result from Broker Content Provider, cursor is null", null);
    }

    @Override
    public IIpcStrategy.Type getType() {
        return IIpcStrategy.Type.CONTENT_PROVIDER;
    }

    private Uri getContentProviderURI(@NonNull String targetedBrokerPackageName, @NonNull String path) {
        String authority = ContentProviderStrategy.getContentProviderAuthority(targetedBrokerPackageName);
        return Uri.parse((String)("content://" + authority + path));
    }

    public static String getContentProviderAuthority(@NonNull String targetedBrokerPackageName) {
        return targetedBrokerPackageName + "." + "microsoft.identity.broker";
    }

    @Override
    public boolean isSupportedByTargetedBroker(@NonNull String targetedBrokerPackageName) {
        return this.mCache.supportsContentProvider(targetedBrokerPackageName);
    }
}

