/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.activebrokerdiscovery;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.activebrokerdiscovery.AccountManagerBrokerDiscoveryUtil;
import com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClient;
import com.microsoft.identity.common.internal.activebrokerdiscovery.IBrokerDiscoveryClient;
import com.microsoft.identity.common.internal.activebrokerdiscovery.IBrokerDiscoveryClientTelemetryCallback;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.ContentProviderStrategy;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.cache.IClientActiveBrokerCache;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0002()B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB[\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u0012H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J%\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u0004\u0018\u00010\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u001a\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient;", "Lcom/microsoft/identity/common/internal/activebrokerdiscovery/IBrokerDiscoveryClient;", "context", "Landroid/content/Context;", "components", "Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;", "cache", "Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;", "(Landroid/content/Context;Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;)V", "brokerCandidates", "", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "getActiveBrokerFromAccountManager", "Lkotlin/Function0;", "ipcStrategy", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "isPackageInstalled", "Lkotlin/Function1;", "", "isValidBroker", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "cachedData", "Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient$CachedBrokerData;", "getCachedData$annotations", "()V", "getCachedData", "()Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient$CachedBrokerData;", "setCachedData", "(Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient$CachedBrokerData;)V", "forceBrokerRediscovery", "brokerCandidate", "getActiveBroker", "shouldSkipCache", "telemetryCallback", "Lcom/microsoft/identity/common/internal/activebrokerdiscovery/IBrokerDiscoveryClientTelemetryCallback;", "getActiveBrokerAsync", "(ZLcom/microsoft/identity/common/internal/activebrokerdiscovery/IBrokerDiscoveryClientTelemetryCallback;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActiveBrokerWithInMemoryCache", "validateInMemoryCacheValue", "data", "CachedBrokerData", "Companion", "common_distRelease"})
public final class BrokerDiscoveryClient
implements IBrokerDiscoveryClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BrokerData> brokerCandidates;
    @NotNull
    private final Function0<BrokerData> getActiveBrokerFromAccountManager;
    @NotNull
    private final IIpcStrategy ipcStrategy;
    @NotNull
    private final IClientActiveBrokerCache cache;
    @NotNull
    private final Function1<BrokerData, Boolean> isPackageInstalled;
    @NotNull
    private final Function1<BrokerData, Boolean> isValidBroker;
    @Nullable
    private volatile CachedBrokerData cachedData;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(BrokerDiscoveryClient.class).getSimpleName();
    @NotNull
    private static final CoroutineDispatcher dispatcher = Dispatchers.getIO().limitedParallelism(10);
    @NotNull
    public static final String ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY = "ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY";
    @NotNull
    public static final String ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY = "ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_BUNDLE_KEY = "FORCE_TRIGGER_BROKER_DISCOVERY_BUNDLE_KEY";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_EXECUTED_BUNDLE_KEY = "FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_EXECUTED_BUNDLE_KEY";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_OPERATION_NOT_SUPPORTED = "OPERATION_NOT_SUPPORTED";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_OPERATION_DISABLED = "OPERATION_DISABLED";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_PACKAGE_NOT_INSTALLED = "PACKAGE_NOT_INSTALLED";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_NOT_VALID_BROKER = "NOT_VALID_BROKER";
    @NotNull
    public static final String FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_UNEXPECTED_ERROR = "UNEXPECTED_ERROR";
    @NotNull
    public static final String ERROR_BUNDLE_KEY = "ERROR_BUNDLE_KEY";
    @NotNull
    private static final Mutex classLevelLock = MutexKt.Mutex$default((boolean)false, (int)1, null);

    public BrokerDiscoveryClient(@NotNull Set<BrokerData> brokerCandidates, @NotNull Function0<BrokerData> getActiveBrokerFromAccountManager, @NotNull IIpcStrategy ipcStrategy, @NotNull IClientActiveBrokerCache cache, @NotNull Function1<? super BrokerData, Boolean> isPackageInstalled, @NotNull Function1<? super BrokerData, Boolean> isValidBroker) {
        Intrinsics.checkNotNullParameter(brokerCandidates, (String)"brokerCandidates");
        Intrinsics.checkNotNullParameter(getActiveBrokerFromAccountManager, (String)"getActiveBrokerFromAccountManager");
        Intrinsics.checkNotNullParameter((Object)ipcStrategy, (String)"ipcStrategy");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter(isPackageInstalled, (String)"isPackageInstalled");
        Intrinsics.checkNotNullParameter(isValidBroker, (String)"isValidBroker");
        this.brokerCandidates = brokerCandidates;
        this.getActiveBrokerFromAccountManager = getActiveBrokerFromAccountManager;
        this.ipcStrategy = ipcStrategy;
        this.cache = cache;
        this.isPackageInstalled = isPackageInstalled;
        this.isValidBroker = isValidBroker;
    }

    @Nullable
    public final CachedBrokerData getCachedData() {
        return this.cachedData;
    }

    public final void setCachedData(@Nullable CachedBrokerData cachedBrokerData) {
        this.cachedData = cachedBrokerData;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCachedData$annotations() {
    }

    public BrokerDiscoveryClient(final @NotNull Context context, @NotNull IPlatformComponents components, @NotNull IClientActiveBrokerCache cache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this(BrokerData.Companion.getKnownBrokerApps(), (Function0<BrokerData>)((Function0)new Function0<BrokerData>(){

            @Nullable
            public final BrokerData invoke() {
                return new AccountManagerBrokerDiscoveryUtil(context).getActiveBrokerFromAccountManager();
            }
        }), new ContentProviderStrategy(context, components), cache, (Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData) {
                Intrinsics.checkNotNullParameter((Object)brokerData, (String)"brokerData");
                return new PackageHelper(context).isPackageInstalledAndEnabled(brokerData.getPackageName());
            }
        }), (Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData) {
                Intrinsics.checkNotNullParameter((Object)brokerData, (String)"brokerData");
                return new BrokerValidator(context).isSignedByKnownKeys(brokerData);
            }
        }));
    }

    @Override
    @NotNull
    public BrokerData forceBrokerRediscovery(@NotNull BrokerData brokerCandidate) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)brokerCandidate, (String)"brokerCandidate");
        String methodTag = TAG + ":forceBrokerRediscovery";
        return (BrokerData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(this, brokerCandidate, methodTag, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ BrokerDiscoveryClient this$0;
            final /* synthetic */ BrokerData $brokerCandidate;
            final /* synthetic */ String $methodTag;
            {
                this.this$0 = $receiver;
                this.$brokerCandidate = $brokerCandidate;
                this.$methodTag = $methodTag;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    @Nullable
    public BrokerData getActiveBrokerWithInMemoryCache(@Nullable IBrokerDiscoveryClientTelemetryCallback telemetryCallback) {
        CachedBrokerData cachedBrokerData = this.cachedData;
        if (cachedBrokerData != null) {
            CachedBrokerData it = cachedBrokerData;
            boolean bl = false;
            if (it.getBrokerData() == null) {
                return null;
            }
            if (this.validateInMemoryCacheValue(it.getBrokerData(), telemetryCallback)) {
                return it.getBrokerData();
            }
        }
        return (BrokerData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(telemetryCallback, this, null){
            long J$0;
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ IBrokerDiscoveryClientTelemetryCallback $telemetryCallback;
            final /* synthetic */ BrokerDiscoveryClient this$0;
            {
                this.$telemetryCallback = $telemetryCallback;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        timeStartAcquiringLock = System.nanoTime();
                        var4_4 = BrokerDiscoveryClient.access$getClassLevelLock$cp();
                        var6_5 = this.$telemetryCallback;
                        var7_6 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var6_5;
                        this.L$2 = var7_6;
                        this.J$0 = timeStartAcquiringLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl31
                    }
                    case 1: {
                        $i$f$withLock = false;
                        timeStartAcquiringLock = this.J$0;
                        var7_6 = (BrokerDiscoveryClient)this.L$2;
                        var6_5 = (IBrokerDiscoveryClientTelemetryCallback)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 3 sources

                        $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBrokerWithInMemoryCache$2$1 = false;
                        v1 = var6_5;
                        if (v1 != null) {
                            v1.onLockAcquired(System.nanoTime() - timeStartAcquiringLock);
                        }
                        v2 = var7_6.getCachedData();
                        if (v2 == null) ** GOTO lbl51
                        it = v2;
                        $i$a$-let-BrokerDiscoveryClient$getActiveBrokerWithInMemoryCache$2$1$1 = false;
                        if (it.getBrokerData() != null) ** GOTO lbl45
                        var16_15 = null;
                        $this$withLock_u24default$iv.unlock(owner$iv);
                        return var16_15;
lbl45:
                        // 2 sources

                        if (!BrokerDiscoveryClient.access$validateInMemoryCacheValue(var7_6, it.getBrokerData(), var6_5)) ** GOTO lbl50
                        var15_16 = it.getBrokerData();
                        $this$withLock_u24default$iv.unlock(owner$iv);
                        return var15_16;
lbl50:
                        // 2 sources

lbl51:
                        // 2 sources

                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var7_6;
                        this.L$2 = null;
                        this.label = 2;
                        v3 = BrokerDiscoveryClient.access$getActiveBrokerAsync(var7_6, false, var6_5, (Continuation)this);
                        ** if (v3 != var17_2) goto lbl58
lbl57:
                        // 1 sources

                        return var17_2;
lbl58:
                        // 1 sources

                        ** GOTO lbl69
                    }
                    case 2: {
                        $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBrokerWithInMemoryCache$2$1 = false;
                        $i$f$withLock = false;
                        var7_6 = (BrokerDiscoveryClient)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl69:
                            // 2 sources

                            brokerData = (BrokerData)v3;
                            var7_6.setCachedData(new CachedBrokerData(brokerData));
                            var14_18 = brokerData;
                            return var14_18;
                        }
                        catch (Throwable var13_19) {
                            throw var13_19;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final boolean validateInMemoryCacheValue(BrokerData data, IBrokerDiscoveryClientTelemetryCallback telemetryCallback) {
        boolean isValidBroker;
        block0: {
            long timeStartIsValidBroker = System.nanoTime();
            isValidBroker = (Boolean)this.isValidBroker.invoke((Object)data);
            IBrokerDiscoveryClientTelemetryCallback iBrokerDiscoveryClientTelemetryCallback = telemetryCallback;
            if (iBrokerDiscoveryClientTelemetryCallback == null) break block0;
            iBrokerDiscoveryClientTelemetryCallback.onFinishCheckingIfValidBroker(System.nanoTime() - timeStartIsValidBroker);
        }
        return isValidBroker;
    }

    @Override
    @Nullable
    public BrokerData getActiveBroker(boolean shouldSkipCache) {
        return (BrokerData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(this, shouldSkipCache, null){
            Object L$0;
            Object L$1;
            boolean Z$0;
            int label;
            final /* synthetic */ BrokerDiscoveryClient this$0;
            final /* synthetic */ boolean $shouldSkipCache;
            {
                this.this$0 = $receiver;
                this.$shouldSkipCache = $shouldSkipCache;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = BrokerDiscoveryClient.access$getClassLevelLock$cp();
                        var4_4 = this.this$0;
                        var5_5 = this.$shouldSkipCache;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.Z$0 = var5_5;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var5_5 = this.Z$0;
                        var4_4 = (BrokerDiscoveryClient)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 3 sources

                        $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBroker$1$1 = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = null;
                        this.label = 2;
                        v1 = BrokerDiscoveryClient.access$getActiveBrokerAsync(var4_4, var5_5 != false, null, (Continuation)this);
                        ** if (v1 != var10_2) goto lbl36
lbl35:
                        // 1 sources

                        return var10_2;
lbl36:
                        // 1 sources

                        ** GOTO lbl46
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBroker$1$1 = false;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl46:
                            // 2 sources

                            var9_9 = v1;
                            return var9_9;
                        }
                        catch (Throwable var8_10) {
                            throw var8_10;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    @Nullable
    public BrokerData getActiveBroker(boolean shouldSkipCache, @NotNull IBrokerDiscoveryClientTelemetryCallback telemetryCallback) {
        Intrinsics.checkNotNullParameter((Object)telemetryCallback, (String)"telemetryCallback");
        return (BrokerData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(telemetryCallback, this, shouldSkipCache, null){
            long J$0;
            Object L$0;
            Object L$1;
            Object L$2;
            boolean Z$0;
            int label;
            final /* synthetic */ IBrokerDiscoveryClientTelemetryCallback $telemetryCallback;
            final /* synthetic */ BrokerDiscoveryClient this$0;
            final /* synthetic */ boolean $shouldSkipCache;
            {
                this.$telemetryCallback = $telemetryCallback;
                this.this$0 = $receiver;
                this.$shouldSkipCache = $shouldSkipCache;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        timeStartAcquiringLock = System.nanoTime();
                        var4_4 = BrokerDiscoveryClient.access$getClassLevelLock$cp();
                        var6_5 = this.$telemetryCallback;
                        var7_6 = this.this$0;
                        var8_7 = this.$shouldSkipCache;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var6_5;
                        this.L$2 = var7_6;
                        this.J$0 = timeStartAcquiringLock;
                        this.Z$0 = var8_7;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl34
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var8_7 = this.Z$0;
                        timeStartAcquiringLock = this.J$0;
                        var7_6 = (BrokerDiscoveryClient)this.L$2;
                        var6_5 = (IBrokerDiscoveryClientTelemetryCallback)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl34:
                        // 3 sources

                        $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBroker$2$1 = false;
                        var6_5.onLockAcquired(System.nanoTime() - timeStartAcquiringLock);
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 2;
                        v1 = BrokerDiscoveryClient.access$getActiveBrokerAsync(var7_6, var8_7 != false, var6_5, (Continuation)this);
                        ** if (v1 != var13_2) goto lbl44
lbl43:
                        // 1 sources

                        return var13_2;
lbl44:
                        // 1 sources

                        ** GOTO lbl54
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBroker$2$1 = false;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl54:
                            // 2 sources

                            var12_11 = v1;
                            return var12_11;
                        }
                        catch (Throwable var11_12) {
                            throw var11_12;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getActiveBrokerAsync(boolean var1_1, IBrokerDiscoveryClientTelemetryCallback var2_2, Continuation<? super BrokerData> var3_3) {
        if (!(var3_3 instanceof getActiveBrokerAsync.1)) ** GOTO lbl-1000
        var18_4 = var3_3;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ BrokerDiscoveryClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BrokerDiscoveryClient.access$getActiveBrokerAsync(this.this$0, false, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                methodTag = BrokerDiscoveryClient.TAG + ":getActiveBrokerAsync";
                if (shouldSkipCache == false) {
                    if (this.cache.shouldUseAccountManager()) {
                        v0 = telemetryCallback;
                        if (v0 != null) {
                            v0.onUseAccountManager();
                        }
                        return this.getActiveBrokerFromAccountManager.invoke();
                    }
                    timeStartReadingFromCache = System.nanoTime();
                    v1 = this.cache.getCachedActiveBroker();
                    if (v1 != null) {
                        it = v1;
                        $i$a$-let-BrokerDiscoveryClient$getActiveBrokerAsync$2 = false;
                        v2 = telemetryCallback;
                        if (v2 != null) {
                            v2.onReadFromCache(System.nanoTime() - timeStartReadingFromCache);
                        }
                        timeStartIsPackageInstalled = System.nanoTime();
                        isPackageInstalled = (Boolean)this.isPackageInstalled.invoke((Object)it);
                        v3 = telemetryCallback;
                        if (v3 != null) {
                            v3.onFinishCheckingIfPackageIsInstalled(System.nanoTime() - timeStartIsPackageInstalled);
                        }
                        if (!isPackageInstalled) {
                            Logger.info((String)methodTag, (String)("There is a cached broker: " + it + ", but the app is no longer installed."));
                            this.cache.clearCachedActiveBroker();
                        } else {
                            timeStartIsValidBroker = System.nanoTime();
                            isValidBroker = (Boolean)this.isValidBroker.invoke((Object)it);
                            v4 = telemetryCallback;
                            if (v4 != null) {
                                v4.onFinishCheckingIfValidBroker(System.nanoTime() - timeStartIsValidBroker);
                            }
                            if (!isValidBroker) {
                                Logger.info((String)methodTag, (String)"Clearing cache as the installed app does not have a matching signature hash.");
                                this.cache.clearCachedActiveBroker();
                            } else {
                                Logger.info((String)methodTag, (String)("Returning cached broker: " + it));
                                return it;
                            }
                        }
                    }
                }
                timeStartQueryFromBroker = System.nanoTime();
                $continuation.L$0 = this;
                $continuation.L$1 = telemetryCallback;
                $continuation.L$2 = methodTag;
                $continuation.J$0 = timeStartQueryFromBroker;
                $continuation.label = 1;
                v5 = BrokerDiscoveryClient.Companion.queryFromBroker$common_distRelease(this.brokerCandidates, this.ipcStrategy, this.isPackageInstalled, this.isValidBroker, (Continuation<? super BrokerData>)$continuation);
                if (v5 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl64
            }
            case 1: {
                timeStartQueryFromBroker = $continuation.J$0;
                methodTag = (String)$continuation.L$2;
                telemetryCallback = (IBrokerDiscoveryClientTelemetryCallback)$continuation.L$1;
                this = (BrokerDiscoveryClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl64:
                // 2 sources

                brokerData = (BrokerData)v5;
                v6 = telemetryCallback;
                if (v6 != null) {
                    v6.onFinishQueryingResultFromBroker(System.nanoTime() - timeStartQueryFromBroker);
                }
                if (brokerData != null) {
                    this.cache.setCachedActiveBroker(brokerData);
                    return brokerData;
                }
                Logger.info((String)methodTag, (String)"Will skip broker discovery via IPC and fall back to AccountManager for the next 60 minutes.");
                this.cache.clearCachedActiveBroker();
                this.cache.setShouldUseAccountManagerForTheNextMilliseconds(TimeUnit.MINUTES.toMillis(60L));
                v7 = telemetryCallback;
                if (v7 != null) {
                    v7.onUseAccountManager();
                }
                accountManagerResult = (BrokerData)this.getActiveBrokerFromAccountManager.invoke();
                v8 = accountManagerResult;
                Logger.info((String)methodTag, (String)("Tried getting active broker from account manager, get " + (v8 != null ? v8.getPackageName() : null) + '.'));
                return accountManagerResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Mutex access$getClassLevelLock$cp() {
        return classLevelLock;
    }

    public static final /* synthetic */ Function1 access$isPackageInstalled$p(BrokerDiscoveryClient $this) {
        return $this.isPackageInstalled;
    }

    public static final /* synthetic */ Function1 access$isValidBroker$p(BrokerDiscoveryClient $this) {
        return $this.isValidBroker;
    }

    public static final /* synthetic */ IIpcStrategy access$getIpcStrategy$p(BrokerDiscoveryClient $this) {
        return $this.ipcStrategy;
    }

    public static final /* synthetic */ IClientActiveBrokerCache access$getCache$p(BrokerDiscoveryClient $this) {
        return $this.cache;
    }

    public static final /* synthetic */ boolean access$validateInMemoryCacheValue(BrokerDiscoveryClient $this, BrokerData data, IBrokerDiscoveryClientTelemetryCallback telemetryCallback) {
        return $this.validateInMemoryCacheValue(data, telemetryCallback);
    }

    public static final /* synthetic */ Object access$getActiveBrokerAsync(BrokerDiscoveryClient $this, boolean shouldSkipCache, IBrokerDiscoveryClientTelemetryCallback telemetryCallback, Continuation $completion) {
        return $this.getActiveBrokerAsync(shouldSkipCache, telemetryCallback, (Continuation<? super BrokerData>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient$CachedBrokerData;", "", "brokerData", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "(Lcom/microsoft/identity/common/internal/broker/BrokerData;)V", "getBrokerData", "()Lcom/microsoft/identity/common/internal/broker/BrokerData;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "common_distRelease"})
    public static final class CachedBrokerData {
        @Nullable
        private final BrokerData brokerData;

        public CachedBrokerData(@Nullable BrokerData brokerData) {
            this.brokerData = brokerData;
        }

        @Nullable
        public final BrokerData getBrokerData() {
            return this.brokerData;
        }

        @Nullable
        public final BrokerData component1() {
            return this.brokerData;
        }

        @NotNull
        public final CachedBrokerData copy(@Nullable BrokerData brokerData) {
            return new CachedBrokerData(brokerData);
        }

        public static /* synthetic */ CachedBrokerData copy$default(CachedBrokerData cachedBrokerData, BrokerData brokerData, int n, Object object) {
            if ((n & 1) != 0) {
                brokerData = cachedBrokerData.brokerData;
            }
            return cachedBrokerData.copy(brokerData);
        }

        @NotNull
        public String toString() {
            return "CachedBrokerData(brokerData=" + this.brokerData + ')';
        }

        public int hashCode() {
            return this.brokerData == null ? 0 : this.brokerData.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedBrokerData)) {
                return false;
            }
            CachedBrokerData cachedBrokerData = (CachedBrokerData)other;
            return Intrinsics.areEqual((Object)this.brokerData, (Object)cachedBrokerData.brokerData);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002JS\u0010\"\u001a\u0004\u0018\u00010\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0006\u0010 \u001a\u00020!2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0&H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient$Companion;", "", "()V", "ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY", "", "ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY", "ERROR_BUNDLE_KEY", "FORCE_TRIGGER_BROKER_DISCOVERY_BUNDLE_KEY", "FORCE_TRIGGER_BROKER_DISCOVERY_NOT_VALID_BROKER", "FORCE_TRIGGER_BROKER_DISCOVERY_PACKAGE_NOT_INSTALLED", "FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_EXECUTED_BUNDLE_KEY", "FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_OPERATION_DISABLED", "FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_OPERATION_NOT_SUPPORTED", "FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_UNEXPECTED_ERROR", "TAG", "getTAG", "()Ljava/lang/String;", "classLevelLock", "Lkotlinx/coroutines/sync/Mutex;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getDispatcher$annotations", "getDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "extractResult", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "bundle", "Landroid/os/Bundle;", "forceTriggerDiscoveryFlow", "", "makeRequest", "candidate", "ipcStrategy", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "queryFromBroker", "brokerCandidates", "", "isPackageInstalled", "Lkotlin/Function1;", "isValidBroker", "queryFromBroker$common_distRelease", "(Ljava/util/Set;Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final CoroutineDispatcher getDispatcher() {
            return dispatcher;
        }

        public static /* synthetic */ void getDispatcher$annotations() {
        }

        @Nullable
        public final Object queryFromBroker$common_distRelease(@NotNull Set<BrokerData> brokerCandidates, @NotNull IIpcStrategy ipcStrategy, @NotNull Function1<? super BrokerData, Boolean> isPackageInstalled, @NotNull Function1<? super BrokerData, Boolean> isValidBroker, @NotNull Continuation<? super BrokerData> $completion) {
            return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(brokerCandidates, isPackageInstalled, isValidBroker, ipcStrategy, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Set<BrokerData> $brokerCandidates;
                final /* synthetic */ Function1<BrokerData, Boolean> $isPackageInstalled;
                final /* synthetic */ Function1<BrokerData, Boolean> $isValidBroker;
                final /* synthetic */ IIpcStrategy $ipcStrategy;
                {
                    this.$brokerCandidates = $brokerCandidates;
                    this.$isPackageInstalled = $isPackageInstalled;
                    this.$isValidBroker = $isValidBroker;
                    this.$ipcStrategy = $ipcStrategy;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                            Iterable iterable = this.$brokerCandidates;
                            Function1<BrokerData, Boolean> function1 = this.$isPackageInstalled;
                            boolean $i$f$filter = false;
                            void var7_10 = $this$filter$iv;
                            Iterable<E> destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                if (!((Boolean)function1.invoke(element$iv$iv)).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            Function1<BrokerData, Boolean> function12 = this.$isValidBroker;
                            $i$f$filter = false;
                            $this$filterTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                if (!((Boolean)function12.invoke(element$iv$iv)).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List installedCandidates = (List)destination$iv$iv;
                            Iterable iterable2 = installedCandidates;
                            IIpcStrategy iIpcStrategy = this.$ipcStrategy;
                            boolean $i$f$map = false;
                            destination$iv$iv = iterable2;
                            Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void candidate;
                                BrokerData brokerData = (BrokerData)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl = false;
                                collection.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)BrokerDiscoveryClient.Companion.getDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>((BrokerData)candidate, iIpcStrategy, null){
                                    int label;
                                    final /* synthetic */ BrokerData $candidate;
                                    final /* synthetic */ IIpcStrategy $ipcStrategy;
                                    {
                                        this.$candidate = $candidate;
                                        this.$ipcStrategy = $ipcStrategy;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                return com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClient$Companion.access$makeRequest(BrokerDiscoveryClient.Companion, this.$candidate, this.$ipcStrategy);
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null));
                            }
                            List deferredResults2 = (List)destination$iv$iv2;
                            this.label = 1;
                            Object object3 = AwaitKt.awaitAll((Collection)deferredResults2, (Continuation)((Continuation)this));
                            if (object3 != object2) return CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((Iterable)object3)));
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((Iterable)object3)));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super BrokerData>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final BrokerData makeRequest(BrokerData candidate, IIpcStrategy ipcStrategy) {
            BrokerData brokerData;
            String methodTag = this.getTAG() + ":makeRequest";
            BrokerOperationBundle operationBundle = new BrokerOperationBundle(BrokerOperationBundle.Operation.BROKER_DISCOVERY_FROM_SDK, candidate.getPackageName(), new Bundle());
            try {
                Bundle result = ipcStrategy.communicateToBroker(operationBundle);
                brokerData = this.extractResult(result, false);
            }
            catch (Throwable t) {
                if (t instanceof BrokerCommunicationException && BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE == ((BrokerCommunicationException)((Object)t)).getCategory()) {
                    Logger.info((String)methodTag, (String)("Tried broker discovery on " + candidate + ". It doesn't support the IPC mechanism."));
                } else if (t instanceof ClientException && Intrinsics.areEqual((Object)"ONLY_SUPPORTS_ACCOUNT_MANAGER_ERROR_CODE", (Object)((ClientException)t).getErrorCode())) {
                    Logger.info((String)methodTag, (String)("Tried broker discovery on " + candidate + ". The Broker side indicates that only AccountManager is supported."));
                } else {
                    Logger.error((String)methodTag, (String)("Tried broker discovery on " + candidate + ", get an error"), (Throwable)t);
                }
                brokerData = null;
            }
            return brokerData;
        }

        private final BrokerData extractResult(Bundle bundle, boolean forceTriggerDiscoveryFlow) throws NoSuchElementException {
            if (bundle == null) {
                return null;
            }
            Serializable errorData = bundle.getSerializable(BrokerDiscoveryClient.ERROR_BUNDLE_KEY);
            if (errorData != null) {
                throw (Throwable)errorData;
            }
            if (forceTriggerDiscoveryFlow && !bundle.containsKey(BrokerDiscoveryClient.FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_EXECUTED_BUNDLE_KEY)) {
                throw new ClientException(BrokerDiscoveryClient.FORCE_TRIGGER_BROKER_DISCOVERY_RESULT_OPERATION_NOT_SUPPORTED, "Force Broker Discovery is not supported by the broker side. Please update the app.");
            }
            String string = bundle.getString(BrokerDiscoveryClient.ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY);
            if (string == null) {
                throw new NoSuchElementException("ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY must not be null");
            }
            String pkgName = string;
            String string2 = bundle.getString(BrokerDiscoveryClient.ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY);
            if (string2 == null) {
                throw new NoSuchElementException("ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY must not be null");
            }
            String signatureHash = string2;
            return new BrokerData(pkgName, signatureHash);
        }

        public static final /* synthetic */ BrokerData access$makeRequest(Companion $this, BrokerData candidate, IIpcStrategy ipcStrategy) {
            return $this.makeRequest(candidate, ipcStrategy);
        }

        public static final /* synthetic */ BrokerData access$extractResult(Companion $this, Bundle bundle, boolean forceTriggerDiscoveryFlow) {
            return $this.extractResult(bundle, forceTriggerDiscoveryFlow);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

