/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.crypto.AndroidWrappedKeyProvider;
import com.microsoft.identity.common.crypto.CipherSpec;
import com.microsoft.identity.common.crypto.CryptoParameterSpecFactory;
import com.microsoft.identity.common.crypto.IKeyGenSpec;
import com.microsoft.identity.common.crypto.KeyStoreBackedSecretKeyProvider;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKey;
import com.microsoft.identity.common.internal.util.AndroidKeyStoreUtil;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.crypto.key.AES256SecretKeyGenerator;
import com.microsoft.identity.common.java.crypto.key.ISecretKeyProvider;
import com.microsoft.identity.common.java.crypto.key.KeyUtil;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.util.FileUtil;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.SecretKey;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 62\u00020\u0001:\u00016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0007J\b\u0010\"\u001a\u00020 H\u0007J\b\u0010#\u001a\u00020\u001aH\u0002J\u0006\u0010$\u001a\u00020\u000fJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0016\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0&H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u0004\u0018\u00010\u000fJ\u0018\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020.2\u0006\u0010(\u001a\u00020\u001aH\u0002J\u0016\u00102\u001a\u00020 2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001c0&H\u0002J\u0018\u00104\u001a\u00020.2\u0006\u00105\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001aH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\t\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lcom/microsoft/identity/common/crypto/KeyStoreBackedSecretKeyProvider;", "Lcom/microsoft/identity/common/java/crypto/key/ISecretKeyProvider;", "context", "Landroid/content/Context;", "alias", "", "filePath", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "getAlias", "()Ljava/lang/String;", "cipherTransformation", "getCipherTransformation", "cryptoParameterSpecFactory", "Lcom/microsoft/identity/common/crypto/CryptoParameterSpecFactory;", "key", "Ljavax/crypto/SecretKey;", "getKey", "()Ljavax/crypto/SecretKey;", "keyFile", "Ljava/io/File;", "keyFromCache", "getKeyFromCache", "keyTypeIdentifier", "getKeyTypeIdentifier", "attemptKeyGeneration", "Lkotlin/Result;", "Ljava/security/KeyPair;", "spec", "Lcom/microsoft/identity/common/crypto/IKeyGenSpec;", "attemptKeyGeneration-IoAF18A", "(Lcom/microsoft/identity/common/crypto/IKeyGenSpec;)Ljava/lang/Object;", "clearCachedKeyIfCantLoadOrFileDoesNotExist", "", "clearKeyFromCache", "deleteSecretKeyFromStorage", "generateKeyPair", "generateNewSecretKey", "getKeyPairCompatibleCipherSpecs", "", "Lcom/microsoft/identity/common/crypto/CipherSpec;", "keyPair", "handleAllFailures", "", "failures", "", "loadSecretKeyFromFile", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKey;", "readSecretKeyFromStorage", "unwrapSecretKey", "wrappedSecretKey", "validateSpecsAvailable", "specs", "wrapSecretKey", "secretKey", "Companion", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nKeyStoreBackedSecretKeyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStoreBackedSecretKeyProvider.kt\ncom/microsoft/identity/common/crypto/KeyStoreBackedSecretKeyProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,527:1\n288#2,2:528\n766#2:530\n857#2:531\n1747#2,3:532\n858#2:535\n1855#2,2:536\n*S KotlinDebug\n*F\n+ 1 KeyStoreBackedSecretKeyProvider.kt\ncom/microsoft/identity/common/crypto/KeyStoreBackedSecretKeyProvider\n*L\n307#1:528,2\n359#1:530\n359#1:531\n360#1:532,3\n359#1:535\n492#1:536,2\n*E\n"})
public final class KeyStoreBackedSecretKeyProvider
implements ISecretKeyProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String alias;
    @NotNull
    private final String filePath;
    @NotNull
    private final String keyTypeIdentifier;
    @NotNull
    private final String cipherTransformation;
    @NotNull
    private final CryptoParameterSpecFactory cryptoParameterSpecFactory;
    @NotNull
    private final File keyFile;
    @NotNull
    private static final String TAG = "KeyStoreBackedSecretKeyProvider";
    @NotNull
    public static final String AES_CBC_PKCS5_PADDING_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    @NotNull
    public static final String KEY_TYPE_IDENTIFIER = "A001";
    public static final int KEY_FILE_SIZE = 1024;
    @NotNull
    private static final ConcurrentMap<String, SecretKey> sKeyCacheMap = new ConcurrentHashMap();

    public KeyStoreBackedSecretKeyProvider(@NotNull Context context, @NotNull String alias, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.alias = alias;
        this.filePath = filePath;
        this.keyTypeIdentifier = KEY_TYPE_IDENTIFIER;
        this.cipherTransformation = AES_CBC_PKCS5_PADDING_TRANSFORMATION;
        this.cryptoParameterSpecFactory = new CryptoParameterSpecFactory(context, this.getAlias(), null, 4, null);
        this.keyFile = new File(context.getDir(context.getPackageName(), 0), this.filePath);
    }

    @NotNull
    public String getAlias() {
        return this.alias;
    }

    @NotNull
    public String getKeyTypeIdentifier() {
        return this.keyTypeIdentifier;
    }

    @NotNull
    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    @VisibleForTesting
    @Nullable
    public final SecretKey getKeyFromCache() {
        this.clearCachedKeyIfCantLoadOrFileDoesNotExist();
        return (SecretKey)sKeyCacheMap.get(this.filePath);
    }

    @VisibleForTesting
    public final void clearKeyFromCache() {
        sKeyCacheMap.remove(this.filePath);
    }

    @VisibleForTesting
    public final void deleteSecretKeyFromStorage() throws ClientException {
        AndroidKeyStoreUtil.deleteKey(this.getAlias());
        FileUtil.deleteFile((File)this.keyFile);
        sKeyCacheMap.remove(this.filePath);
    }

    private final void clearCachedKeyIfCantLoadOrFileDoesNotExist() {
        boolean shouldClearCache;
        boolean bl = shouldClearCache = !AndroidWrappedKeyProvider.sSkipKeyInvalidationCheck && (!AndroidKeyStoreUtil.canLoadKey(this.getAlias()) || !this.keyFile.exists());
        if (shouldClearCache) {
            sKeyCacheMap.remove(this.filePath);
        }
    }

    @NotNull
    public synchronized SecretKey getKey() throws ClientException {
        String methodTag = "KeyStoreBackedSecretKeyProvider:getKey";
        SecretKey secretKey = this.getKeyFromCache();
        if (secretKey != null) {
            SecretKey it = secretKey;
            boolean bl = false;
            return it;
        }
        SecretKey secretKey2 = this.readSecretKeyFromStorage();
        if (secretKey2 != null) {
            SecretKey it = secretKey2;
            boolean bl = false;
            ((Map)sKeyCacheMap).put(this.filePath, it);
            Logger.verbose(methodTag, "Key loaded from storage and cached with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)it));
            return it;
        }
        SecretKey newKey = this.generateNewSecretKey();
        ((Map)sKeyCacheMap).put(this.filePath, newKey);
        Logger.verbose(methodTag, "New key is generated and cached with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)newKey));
        return newKey;
    }

    @NotNull
    public final SecretKey generateNewSecretKey() throws ClientException {
        KeyPair keyPair;
        String methodTag = "KeyStoreBackedSecretKeyProvider:generateNewSecretKey";
        SecretKey newSecretKey = AES256SecretKeyGenerator.INSTANCE.generateRandomKey();
        KeyPair keyPair2 = AndroidKeyStoreUtil.readKey(this.getAlias());
        if (keyPair2 == null) {
            KeyStoreBackedSecretKeyProvider $this$generateNewSecretKey_u24lambda_u242 = this;
            boolean bl = false;
            Logger.info(methodTag, "No existing keypair found. Generating a new one.");
            keyPair = $this$generateNewSecretKey_u24lambda_u242.generateKeyPair();
        } else {
            keyPair = keyPair2;
        }
        KeyPair keyPair3 = keyPair;
        WrappedSecretKey wrappedSecretKey = this.wrapSecretKey(newSecretKey, keyPair3);
        FileUtil.writeDataToFile((byte[])wrappedSecretKey.serialize(), (File)this.keyFile);
        return newSecretKey;
    }

    @Nullable
    public final synchronized SecretKey readSecretKeyFromStorage() throws ClientException {
        String methodTag = "KeyStoreBackedSecretKeyProvider:readSecretKeyFromStorage";
        try {
            KeyPair keyPair = AndroidKeyStoreUtil.readKey(this.getAlias());
            if (keyPair == null) {
                Logger.info(methodTag, "key does not exist in keystore");
                this.deleteSecretKeyFromStorage();
                return null;
            }
            WrappedSecretKey wrappedSecretKey = this.loadSecretKeyFromFile();
            if (wrappedSecretKey == null) {
                Logger.warn(methodTag, "Key file is empty");
                FileUtil.deleteFile((File)this.keyFile);
                this.clearKeyFromCache();
                return null;
            }
            return this.unwrapSecretKey(wrappedSecretKey, keyPair);
        }
        catch (ClientException e) {
            Logger.warn(methodTag, "Error when loading key from Storage, wipe all existing key data ");
            this.deleteSecretKeyFromStorage();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WrappedSecretKey wrapSecretKey(SecretKey secretKey, KeyPair keyPair) {
        Object object;
        String methodTag = "KeyStoreBackedSecretKeyProvider:wrapSecretKey";
        Span span2 = OTelUtility.createSpanFromParent((String)SpanName.SecretKeyWrapping.name(), (SpanContext)SpanExtension.current().getSpanContext());
        try {
            WrappedSecretKey wrappedSecretKey;
            object = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)span2);
            Throwable throwable = null;
            try {
                Scope cfr_ignored_0 = (Scope)object;
                boolean bl = false;
                span2.setAttribute(AttributeName.secret_key_wrapping_operation.name(), "WRAP");
                CipherSpec cipherSpec = (CipherSpec)CollectionsKt.firstOrNull(this.getKeyPairCompatibleCipherSpecs(keyPair));
                if (cipherSpec == null) {
                    throw new ClientException("unknown_crypto_error", "No compatible cipher specs found for key pair: " + keyPair);
                }
                CipherSpec cipherParamsSpec = cipherSpec;
                span2.setAttribute(AttributeName.secret_key_wrapping_transformation.name(), cipherParamsSpec.getTransformation());
                Logger.info(methodTag, "Wrapping secret key with cipher spec: " + cipherParamsSpec);
                byte[] wrappedKey = AndroidKeyStoreUtil.wrap(secretKey, keyPair, cipherParamsSpec.getTransformation(), cipherParamsSpec.getAlgorithmParameterSpec());
                span2.setStatus(StatusCode.OK);
                Intrinsics.checkNotNullExpressionValue((Object)wrappedKey, (String)"wrappedKey");
                String string = secretKey.getAlgorithm();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"secretKey.algorithm");
                wrappedSecretKey = new WrappedSecretKey(wrappedKey, string, cipherParamsSpec.getTransformation());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = wrappedSecretKey;
        }
        catch (Exception exception) {
            Logger.error(methodTag, "Failed to wrap secret key", exception);
            span2.setStatus(StatusCode.ERROR);
            span2.recordException((Throwable)exception);
            throw exception;
        }
        finally {
            span2.end();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey unwrapSecretKey(WrappedSecretKey wrappedSecretKey, KeyPair keyPair) {
        SecretKey secretKey;
        String methodTag = "KeyStoreBackedSecretKeyProvider:unwrapSecretKey";
        Span span2 = OTelUtility.createSpanFromParent((String)SpanName.SecretKeyWrapping.name(), (SpanContext)SpanExtension.current().getSpanContext());
        try {
            SecretKey secretKey2;
            AutoCloseable autoCloseable = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)span2);
            Throwable throwable = null;
            try {
                Object v0;
                block12: {
                    Scope cfr_ignored_0 = (Scope)autoCloseable;
                    boolean bl = false;
                    span2.setAttribute(AttributeName.secret_key_wrapping_operation.name(), "UNWRAP");
                    Iterable $this$firstOrNull$iv = this.getKeyPairCompatibleCipherSpecs(keyPair);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CipherSpec spec = (CipherSpec)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)spec.getTransformation(), (CharSequence)wrappedSecretKey.getCipherTransformation(), (boolean)true)) continue;
                        v0 = element$iv;
                        break block12;
                    }
                    v0 = null;
                }
                CipherSpec cipherSpec = v0;
                if (cipherSpec == null) {
                    throw new ClientException("unknown_crypto_error", "No compatible cipher specs found for key pair: " + keyPair);
                }
                CipherSpec cipherParamsSpec = cipherSpec;
                span2.setAttribute(AttributeName.secret_key_wrapping_transformation.name(), cipherParamsSpec.getTransformation());
                Logger.info(methodTag, "Unwrapping secret key with cipher spec: " + cipherParamsSpec);
                SecretKey key = AndroidKeyStoreUtil.unwrap(wrappedSecretKey.getWrappedKeyData(), wrappedSecretKey.getAlgorithm(), keyPair, cipherParamsSpec.getTransformation(), cipherParamsSpec.getAlgorithmParameterSpec());
                span2.setStatus(StatusCode.OK);
                SecretKey secretKey3 = key;
                secretKey2 = secretKey3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)secretKey2, (String)"{\n            SpanExtens\u2026y\n            }\n        }");
            secretKey = secretKey2;
        }
        catch (Exception exception) {
            Logger.error(methodTag, "Failed to wrap secret key", exception);
            span2.setStatus(StatusCode.ERROR);
            span2.recordException((Throwable)exception);
            throw exception;
        }
        finally {
            span2.end();
        }
        return secretKey;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CipherSpec> getKeyPairCompatibleCipherSpecs(KeyPair keyPair) throws ClientException {
        void $this$filterTo$iv$iv;
        String methodTag = "KeyStoreBackedSecretKeyProvider:selectCompatibleCipherSpecs";
        List<String> supportedPaddings = AndroidKeyStoreUtil.getKeyPairEncryptionPaddings(keyPair);
        List<CipherSpec> availableCipherSpecs = this.cryptoParameterSpecFactory.getPrioritizedCipherParameterSpecs();
        Logger.verbose(methodTag, "Supported paddings by the keyPair: " + supportedPaddings + ",Specs available in order of priority: " + availableCipherSpecs);
        Iterable $this$filter$iv = availableCipherSpecs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                CipherSpec spec = (CipherSpec)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(supportedPaddings, (String)"supportedPaddings");
                Iterable $this$any$iv = supportedPaddings;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String padding = (String)element$iv;
                        boolean bl3 = false;
                        CharSequence charSequence = spec.getPadding();
                        Intrinsics.checkNotNullExpressionValue((Object)padding, (String)"padding");
                        if (!StringsKt.contains((CharSequence)charSequence, (CharSequence)padding, (boolean)true)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List compatibleSpecs = (List)destination$iv$iv;
        Logger.verbose(methodTag, "Found " + compatibleSpecs.size() + " compatible cipher specs: " + compatibleSpecs);
        return compatibleSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyPair generateKeyPair() throws ClientException {
        Object object;
        String methodTag = "KeyStoreBackedSecretKeyProvider:generateKeyPair";
        Span span2 = OTelUtility.createSpanFromParent((String)SpanName.KeyPairGeneration.name(), (SpanContext)SpanExtension.current().getSpanContext());
        List failures = new ArrayList();
        try {
            KeyPair keyPair;
            object = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)span2);
            Throwable throwable = null;
            try {
                Object object2;
                IKeyGenSpec spec;
                block9: {
                    Scope cfr_ignored_0 = (Scope)object;
                    boolean bl = false;
                    List<IKeyGenSpec> specs = this.cryptoParameterSpecFactory.getPrioritizedKeyGenParameterSpecs();
                    this.validateSpecsAvailable(specs);
                    Iterator<IKeyGenSpec> iterator = specs.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Throwable throwable2;
                        int index = n++;
                        spec = iterator.next();
                        Logger.verbose(methodTag, "Attempting key generation with spec " + (index + 1) + ": " + spec);
                        object2 = this.attemptKeyGeneration-IoAF18A(spec);
                        if (Result.isSuccess-impl((Object)object2)) break block9;
                        if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
                        Throwable throwable3 = throwable2;
                        boolean bl2 = false;
                        Logger.warn(methodTag, "Failed to generate key pair with spec: " + spec + ", error: " + throwable3.getMessage());
                        failures.add(throwable3);
                    }
                    this.handleAllFailures(failures);
                    throw new KotlinNothingValueException();
                }
                KeyPair keyPair2 = (KeyPair)object2;
                boolean bl = false;
                Logger.info(methodTag, "Key pair generated successfully with spec: " + spec);
                span2.setAttribute(AttributeName.key_pair_gen_description.name(), spec.getDescription());
                span2.setAttribute(AttributeName.key_pair_gen_algorithm.name(), spec.getAlgorithm());
                span2.setAttribute(AttributeName.key_pair_gen_encryptionPaddings.name(), spec.getEncryptionPaddings().toString());
                span2.setStatus(StatusCode.OK);
                keyPair = keyPair2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = keyPair;
        }
        finally {
            span2.end();
        }
        return object;
    }

    private final void validateSpecsAvailable(List<? extends IKeyGenSpec> specs) throws ClientException {
        if (specs.isEmpty()) {
            ClientException error = new ClientException("unknown_crypto_error", "No key generation specifications available for generating key pair.");
            SpanExtension.current().setStatus(StatusCode.ERROR);
            SpanExtension.current().recordException((Throwable)error);
            ClientException clientException = ExceptionAdapter.clientExceptionFromException((Throwable)error);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)clientException), (String)"clientExceptionFromException(error)");
            throw (Throwable)clientException;
        }
    }

    private final Object attemptKeyGeneration-IoAF18A(IKeyGenSpec spec) {
        Object object;
        KeyStoreBackedSecretKeyProvider keyStoreBackedSecretKeyProvider = this;
        try {
            KeyStoreBackedSecretKeyProvider $this$attemptKeyGeneration_IoAF18A_u24lambda_u2411 = keyStoreBackedSecretKeyProvider;
            boolean bl = false;
            long startTime = System.currentTimeMillis();
            KeyPair keyPair = AndroidKeyStoreUtil.generateKeyPair(spec.getAlgorithm(), spec.getAlgorithmParameterSpec());
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(\n       \u2026rameterSpec\n            )");
            KeyPair keyPair2 = keyPair;
            long elapsedTime = System.currentTimeMillis() - startTime;
            SpanExtension.current().setAttribute(AttributeName.elapsed_time_keypair_generation.name(), elapsedTime);
            object = Result.constructor-impl((Object)keyPair2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private final Void handleAllFailures(List<? extends Throwable> failures) {
        String methodTag = "KeyStoreBackedSecretKeyProvider:handleAllFailures";
        if (!(!((Collection)failures).isEmpty())) {
            boolean $i$a$-require-KeyStoreBackedSecretKeyProvider$handleAllFailures$22 = false;
            String $i$a$-require-KeyStoreBackedSecretKeyProvider$handleAllFailures$22 = "No failures encountered, but no key pair generated. This should not happen.";
            throw new IllegalArgumentException($i$a$-require-KeyStoreBackedSecretKeyProvider$handleAllFailures$22.toString());
        }
        String errorMessages2 = CollectionsKt.joinToString$default((Iterable)failures, (CharSequence)"; ", null, null, (int)0, null, (Function1)handleAllFailures.errorMessages.1.INSTANCE, (int)30, null);
        Iterable $this$forEach$iv = failures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Throwable exception = (Throwable)element$iv;
            boolean bl = false;
            Logger.error(methodTag, "Key pair generation failed with: " + exception.getMessage(), exception);
        }
        SpanExtension.current().setAttribute(AttributeName.keypair_gen_exception.name(), errorMessages2);
        Throwable finalError = (Throwable)CollectionsKt.last(failures);
        SpanExtension.current().setStatus(StatusCode.ERROR);
        SpanExtension.current().recordException(finalError);
        ClientException clientException = ExceptionAdapter.clientExceptionFromException((Throwable)finalError);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)clientException), (String)"clientExceptionFromException(finalError)");
        throw (Throwable)clientException;
    }

    private final WrappedSecretKey loadSecretKeyFromFile() {
        String methodTag = "KeyStoreBackedSecretKeyProvider:loadFromFile";
        if (!this.keyFile.exists()) {
            Logger.warn(methodTag, "Key file does not exist");
            return null;
        }
        byte[] wrappedSecretKeyData = FileUtil.readFromFile((File)this.keyFile, (int)1024);
        if (wrappedSecretKeyData == null || wrappedSecretKeyData.length == 0) {
            Logger.warn(methodTag, "Key file is empty");
            return null;
        }
        return WrappedSecretKey.Companion.deserialize(wrappedSecretKeyData);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/crypto/KeyStoreBackedSecretKeyProvider$Companion;", "", "()V", "AES_CBC_PKCS5_PADDING_TRANSFORMATION", "", "KEY_FILE_SIZE", "", "getKEY_FILE_SIZE$annotations", "KEY_TYPE_IDENTIFIER", "TAG", "sKeyCacheMap", "Ljava/util/concurrent/ConcurrentMap;", "Ljavax/crypto/SecretKey;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getKEY_FILE_SIZE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

