/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.util;

import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.util.ICacheRecordGsonAdapter;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import java.lang.reflect.Type;
import java.util.List;

public final class JsonExtensions {
    private JsonExtensions() {
    }

    public static List<ICacheRecord> getICacheRecordListFromJsonString(String accountJson) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ICacheRecord.class, (Object)new ICacheRecordGsonAdapter());
        Type listOfCacheRecords = TypeToken.getParameterized(List.class, (Type[])new Type[]{ICacheRecord.class}).getType();
        return (List)builder.create().fromJson(accountJson, listOfCacheRecords);
    }

    public static String getJsonStringFromICacheRecordList(List<ICacheRecord> cacheRecords) {
        Type listOfCacheRecords = TypeToken.getParameterized(List.class, (Type[])new Type[]{ICacheRecord.class}).getType();
        return new Gson().toJson(cacheRecords, listOfCacheRecords);
    }

    public static BrokerResult getBrokerResultFromJsonString(@NonNull String jsonString) {
        return (BrokerResult)new GsonBuilder().registerTypeAdapter(ICacheRecord.class, (Object)new ICacheRecordGsonAdapter()).create().fromJson(jsonString, BrokerResult.class);
    }
}

