/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal;

import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.BatteryOptimizationStatus;
import com.microsoft.identity.common.internal.DeviceDozeModeStatus;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PowerManagerWrapper {
    private static final String TAG = PowerManagerWrapper.class.getSimpleName();
    private static PowerManagerWrapper sInstance;
    private static final String UNKNOWN_STATUS = "Unknown";
    private final Map<String, BatteryOptimizationStatus> batteryOptOutCache = new ConcurrentHashMap<String, BatteryOptimizationStatus>();

    public static void setInstance(PowerManagerWrapper wrapper) {
        sInstance = wrapper;
    }

    public static synchronized PowerManagerWrapper getInstance() {
        if (sInstance == null) {
            sInstance = new PowerManagerWrapper();
        }
        return sInstance;
    }

    @RequiresApi(value=23)
    public boolean isDeviceIdleMode(Context connectionContext) {
        return ((PowerManager)connectionContext.getSystemService("power")).isDeviceIdleMode();
    }

    @NonNull
    public String getDeviceIdleMode(@NonNull Context context) {
        try {
            if (Build.VERSION.SDK_INT < 23) {
                return UNKNOWN_STATUS;
            }
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager.isDeviceIdleMode()) {
                return "Idle";
            }
            if (Build.VERSION.SDK_INT >= 33 && powerManager.isDeviceLightIdleMode()) {
                return "LightIdle";
            }
        }
        catch (Exception e) {
            return UNKNOWN_STATUS;
        }
        return "";
    }

    @NonNull
    public DeviceDozeModeStatus getDeviceDozeModeStatus(@NonNull Context context) {
        String methodTag = TAG + ":getDeviceDozeModeStatus";
        try {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager == null) {
                Logger.error(methodTag, "PowerManager is null", null);
                return DeviceDozeModeStatus.CannotRetrievePowerManager;
            }
            if (powerManager.isDeviceIdleMode()) {
                return DeviceDozeModeStatus.Idle;
            }
            if (Build.VERSION.SDK_INT >= 33 && powerManager.isDeviceLightIdleMode()) {
                return DeviceDozeModeStatus.LightIdle;
            }
            return DeviceDozeModeStatus.NotInDozeMode;
        }
        catch (Exception e) {
            Logger.error(methodTag, "Unknown Exception when checking doze mode status", e);
            return DeviceDozeModeStatus.UnknownError;
        }
    }

    @NonNull
    public String getPowerOptimizationSettings(@NonNull Context context) {
        try {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager.isIgnoringBatteryOptimizations(context.getPackageName())) {
                return "OptOut";
            }
            return "";
        }
        catch (Exception e) {
            return UNKNOWN_STATUS;
        }
    }

    public boolean isIgnoringBatteryOptimizations(Context connectionContext) {
        return ((PowerManager)connectionContext.getSystemService("power")).isIgnoringBatteryOptimizations(connectionContext.getPackageName());
    }

    public BatteryOptimizationStatus isAppOptedOutFromBatteryOptimization(@NonNull String packageName, @NonNull Context context) {
        String methodTag = TAG + ":isAppOptedOutFromBatteryOptimization";
        return this.batteryOptOutCache.computeIfAbsent(packageName, key -> {
            try {
                PowerManager powerManager = (PowerManager)context.getSystemService("power");
                if (powerManager == null) {
                    Logger.error(methodTag, "PowerManager is null", null);
                    return BatteryOptimizationStatus.CannotRetrievePowerManager;
                }
                if (powerManager.isIgnoringBatteryOptimizations(key)) {
                    return BatteryOptimizationStatus.OptOut;
                }
                return BatteryOptimizationStatus.NotOptOut;
            }
            catch (Exception e) {
                Logger.error(methodTag, "Unknown Exception when checking battery optimization status for package: " + packageName, e);
                return BatteryOptimizationStatus.UnknownError;
            }
        });
    }
}

