/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import androidx.annotation.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    public static byte[] compressString(@NonNull String inputString) throws IOException {
        byte[] bytes = inputString.getBytes("UTF-8");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(bytes, 0, bytes.length);
        gzipOutputStream.flush();
        gzipOutputStream.close();
        byte[] result = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return result;
    }

    public static String decompressBytesToString(@NonNull byte[] compressedBytes) throws IOException {
        int bytesRead;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedBytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] tempBuffer = new byte[256];
        while ((bytesRead = gzipInputStream.read(tempBuffer)) >= 0) {
            byteArrayOutputStream.write(tempBuffer, 0, bytesRead);
        }
        gzipInputStream.close();
        byte[] deCompressedBytes = byteArrayOutputStream.toByteArray();
        byteArrayInputStream.close();
        return new String(deCompressedBytes, 0, deCompressedBytes.length, "UTF-8");
    }
}

