/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.ISendResultCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IConnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDisconnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;
import java.util.concurrent.atomic.AtomicBoolean;

public class NfcSmartcardCertBasedAuthChallengeHandler
extends AbstractSmartcardCertBasedAuthChallengeHandler<AbstractNfcSmartcardCertBasedAuthManager> {
    public NfcSmartcardCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull AbstractNfcSmartcardCertBasedAuthManager nfcSmartcardCertBasedAuthManager, @NonNull IDialogHolder dialogHolder, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        super(activity, nfcSmartcardCertBasedAuthManager, dialogHolder, telemetryHelper, NfcSmartcardCertBasedAuthChallengeHandler.class.getSimpleName());
    }

    @Override
    protected void prepForNextUserInteraction(final @NonNull IDisconnectionCallback nextInteractionCallback) {
        if (!((AbstractNfcSmartcardCertBasedAuthManager)this.mCbaManager).isDeviceConnected()) {
            nextInteractionCallback.onClosedConnection();
            return;
        }
        this.clearAllManagerCallbacks();
        final AtomicBoolean hasCallbackBeenCalled = new AtomicBoolean(false);
        this.mDialogHolder.showSmartcardRemovalPromptDialog(new IDismissCallback(){

            @Override
            public void onDismiss() {
                if (hasCallbackBeenCalled.compareAndSet(false, true)) {
                    ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).stopDiscovery(NfcSmartcardCertBasedAuthChallengeHandler.this.mActivity);
                    nextInteractionCallback.onClosedConnection();
                }
            }
        });
        ((AbstractNfcSmartcardCertBasedAuthManager)this.mCbaManager).disconnect(new IDisconnectionCallback(){

            @Override
            public void onClosedConnection() {
                if (hasCallbackBeenCalled.compareAndSet(false, true)) {
                    NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                    ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).stopDiscovery(NfcSmartcardCertBasedAuthChallengeHandler.this.mActivity);
                    nextInteractionCallback.onClosedConnection();
                }
            }
        });
    }

    @Override
    protected void indicateDisconnectionError(@NonNull String methodName) {
    }

    @Override
    protected SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(final @NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request) {
        final String methodTag = this.TAG + ":getSmartcardPinDialogPositiveButtonListener";
        return new SmartcardPinDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(final @NonNull char[] pin) {
                NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showSmartcardNfcPromptDialog(new ICancelCbaCallback(){

                    @Override
                    public void onCancel() {
                        NfcSmartcardCertBasedAuthChallengeHandler.this.getGeneralCancelCbaCallback(request).onCancel();
                        ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).stopDiscovery(NfcSmartcardCertBasedAuthChallengeHandler.this.mActivity);
                    }
                });
                ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).setConnectionCallback(new IConnectionCallback(){

                    @Override
                    public void onCreateConnection() {
                        NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showSmartcardNfcLoadingDialog();
                        if (((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).isDeviceChanged()) {
                            NfcSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                            request.cancel();
                            NfcSmartcardCertBasedAuthChallengeHandler.this.prepForNextUserInteraction(new IDisconnectionCallback(){

                                @Override
                                public void onClosedConnection() {
                                    String errorMessage = "Device connected via NFC is different from initially connected device.";
                                    Logger.info(methodTag, "Device connected via NFC is different from initially connected device.");
                                    NfcSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("Device connected via NFC is different from initially connected device.");
                                    NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_nfc_diff_connected_title, R.string.smartcard_nfc_diff_connected_message, R.string.smartcard_nfc_diff_connected_positive_button);
                                }
                            });
                            return;
                        }
                        ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

                            @Override
                            public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                                NfcSmartcardCertBasedAuthChallengeHandler.this.tryUsingSmartcardWithPin(pin, certDetails, request, session);
                                NfcSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                            }

                            @Override
                            public void onException(final @NonNull Exception e) {
                                NfcSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                                request.cancel();
                                NfcSmartcardCertBasedAuthChallengeHandler.this.prepForNextUserInteraction(new IDisconnectionCallback(){

                                    @Override
                                    public void onClosedConnection() {
                                        NfcSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                                    }
                                });
                            }
                        });
                    }
                });
                ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).startDiscovery(NfcSmartcardCertBasedAuthChallengeHandler.this.mActivity);
            }
        };
    }

    @Override
    @RequiresApi(api=21)
    protected void setPinDialogForIncorrectAttempt(@NonNull ICertDetails certDetails, @NonNull ClientCertRequest request) {
        this.mDialogHolder.showPinDialog(this.getSmartcardPinDialogPositiveButtonListener(certDetails, request), this.getGeneralCancelCbaCallback(request));
        this.mDialogHolder.setPinDialogErrorMode();
    }

    @Override
    public void promptSmartcardRemovalForResult(final @NonNull ISendResultCallback callback) {
        if (((AbstractNfcSmartcardCertBasedAuthManager)this.mCbaManager).isDeviceConnected()) {
            this.prepForNextUserInteraction(new IDisconnectionCallback(){

                @Override
                public void onClosedConnection() {
                    callback.onResultReady();
                }
            });
            return;
        }
        callback.onResultReady();
    }

    @Override
    protected void clearAllManagerCallbacks() {
        ((AbstractNfcSmartcardCertBasedAuthManager)this.mCbaManager).clearConnectionCallback();
    }
}

