/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeWithClientKeyInternal;
import com.microsoft.identity.common.logging.Logger;
import java.lang.reflect.Type;

public class AuthenticationSchemeTypeAdapter
implements JsonDeserializer<AbstractAuthenticationScheme>,
JsonSerializer<AbstractAuthenticationScheme> {
    private static final String TAG = AuthenticationSchemeTypeAdapter.class.getSimpleName();
    private static Gson sRequestAdapterGsonInstance = new GsonBuilder().registerTypeAdapter(AbstractAuthenticationScheme.class, (Object)new AuthenticationSchemeTypeAdapter()).create();

    public static Gson getGsonInstance() {
        return sRequestAdapterGsonInstance;
    }

    public AbstractAuthenticationScheme deserialize(@NonNull JsonElement json, @NonNull Type typeOfT, @NonNull JsonDeserializationContext context) throws JsonParseException {
        String schemeNameStr;
        String methodTag = TAG + ":deserialize";
        JsonObject authScheme = json.getAsJsonObject();
        JsonElement schemeName = authScheme.get("name");
        switch (schemeNameStr = schemeName.getAsString()) {
            case "Bearer": {
                return (AbstractAuthenticationScheme)context.deserialize(json, BearerAuthenticationSchemeInternal.class);
            }
            case "PoP": {
                return (AbstractAuthenticationScheme)context.deserialize(json, PopAuthenticationSchemeInternal.class);
            }
            case "PoP_With_Client_Key": {
                return (AbstractAuthenticationScheme)context.deserialize(json, PopAuthenticationSchemeWithClientKeyInternal.class);
            }
        }
        Logger.warn(methodTag, "Unrecognized auth scheme. Deserializing as null.");
        return null;
    }

    public JsonElement serialize(@NonNull AbstractAuthenticationScheme src, @NonNull Type typeOfSrc, @NonNull JsonSerializationContext context) {
        String methodTag = TAG + ":serialize";
        switch (src.getName()) {
            case "Bearer": {
                return context.serialize((Object)src, BearerAuthenticationSchemeInternal.class);
            }
            case "PoP": {
                return context.serialize((Object)src, PopAuthenticationSchemeInternal.class);
            }
            case "PoP_With_Client_Key": {
                return context.serialize((Object)src, PopAuthenticationSchemeWithClientKeyInternal.class);
            }
        }
        Logger.warn(methodTag, "Unrecognized auth scheme. Serializing as null.");
        return null;
    }
}

