/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.os.Bundle;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.cache.IClientActiveBrokerCache;
import com.microsoft.identity.common.logging.Logger;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/microsoft/identity/common/internal/cache/ActiveBrokerCacheUpdater;", "", "context", "Landroid/content/Context;", "cache", "Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;", "(Landroid/content/Context;Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;)V", "isValidBroker", "Lkotlin/Function1;", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "", "(Lkotlin/jvm/functions/Function1;Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;)V", "updateCachedActiveBrokerFromResultBundle", "", "bundle", "Landroid/os/Bundle;", "Companion", "common_distRelease"})
public final class ActiveBrokerCacheUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<BrokerData, Boolean> isValidBroker;
    @NotNull
    private final IClientActiveBrokerCache cache;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(ActiveBrokerCacheUpdater.class).getSimpleName();
    @NotNull
    public static final String ACTIVE_BROKER_PACKAGE_NAME_KEY = "active.broker.package.name";
    @NotNull
    public static final String ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_KEY = "active.broker.signing.certificate.thumbprint";
    @NotNull
    public static final String BROKER_DISCOVERY_DISABLED_KEY = "broker.discovery.disabled";
    @NotNull
    public static final String KEY_REQUEST_ACTIVE_BROKER_DATA = "com.microsoft.identity.request.broker.data";

    public ActiveBrokerCacheUpdater(@NotNull Function1<? super BrokerData, Boolean> isValidBroker, @NotNull IClientActiveBrokerCache cache) {
        Intrinsics.checkNotNullParameter(isValidBroker, (String)"isValidBroker");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.isValidBroker = isValidBroker;
        this.cache = cache;
    }

    public ActiveBrokerCacheUpdater(final @NotNull Context context, @NotNull IClientActiveBrokerCache cache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this((Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData) {
                Intrinsics.checkNotNullParameter((Object)brokerData, (String)"brokerData");
                return new BrokerValidator(context).isSignedByKnownKeys(brokerData);
            }
        }), cache);
    }

    public final void updateCachedActiveBrokerFromResultBundle(@Nullable Bundle bundle) {
        String methodTag = TAG + ":updateCachedActiveBrokerFromResultBundle";
        if (bundle == null) {
            return;
        }
        boolean shouldWipeCachedActiveBroker = bundle.getBoolean(BROKER_DISCOVERY_DISABLED_KEY, false);
        if (shouldWipeCachedActiveBroker) {
            Logger.info(methodTag, "Got a response indicating that the broker discovery is disabled.Will also wipe the local active broker cache,and skip broker discovery via IPC (only fall back to AccountManager) for the next 60 minutes.");
            this.cache.clearCachedActiveBroker();
            this.cache.setShouldUseAccountManagerForTheNextMilliseconds(TimeUnit.MINUTES.toMillis(60L));
            return;
        }
        String packageName = bundle.getString(ACTIVE_BROKER_PACKAGE_NAME_KEY);
        String signingCertThumbprint = bundle.getString(ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_KEY);
        CharSequence charSequence = packageName;
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)signingCertThumbprint) == null || charSequence.length() == 0) {
            Logger.info(methodTag, "A response was received without active broker information.");
            return;
        }
        BrokerData brokerData = new BrokerData(packageName, signingCertThumbprint);
        if (!((Boolean)this.isValidBroker.invoke((Object)brokerData)).booleanValue()) {
            Logger.warn(methodTag, "Cannot find an installed " + packageName + " with a matching signing certificate thumbprint.");
            return;
        }
        this.cache.setCachedActiveBroker(brokerData);
    }

    @JvmStatic
    public static final void appendActiveBrokerToResultBundle(@NotNull Bundle bundle, @NotNull BrokerData activeBroker) {
        Companion.appendActiveBrokerToResultBundle(bundle, activeBroker);
    }

    @JvmStatic
    public static final void appendBrokerDiscoveryDisabledToResultBundle(@NotNull Bundle bundle) {
        Companion.appendBrokerDiscoveryDisabledToResultBundle(bundle);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/microsoft/identity/common/internal/cache/ActiveBrokerCacheUpdater$Companion;", "", "()V", "ACTIVE_BROKER_PACKAGE_NAME_KEY", "", "ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_KEY", "BROKER_DISCOVERY_DISABLED_KEY", "KEY_REQUEST_ACTIVE_BROKER_DATA", "TAG", "appendActiveBrokerToResultBundle", "", "bundle", "Landroid/os/Bundle;", "activeBroker", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "appendBrokerDiscoveryDisabledToResultBundle", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void appendActiveBrokerToResultBundle(@NotNull Bundle bundle, @NotNull BrokerData activeBroker) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)activeBroker, (String)"activeBroker");
            bundle.putString(ActiveBrokerCacheUpdater.ACTIVE_BROKER_PACKAGE_NAME_KEY, activeBroker.getPackageName());
            bundle.putString(ActiveBrokerCacheUpdater.ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_KEY, activeBroker.getSigningCertificateThumbprint());
        }

        @JvmStatic
        public final void appendBrokerDiscoveryDisabledToResultBundle(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            bundle.putBoolean(ActiveBrokerCacheUpdater.BROKER_DISCOVERY_DISABLED_KEY, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

