/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common;

import android.content.Context;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.util.AbstractSharedPrefNameValueStorage;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;

public class SharedPreferenceStringStorage
extends AbstractSharedPrefNameValueStorage<String> {
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Lombok inserts nullchecks")
    public SharedPreferenceStringStorage(@NonNull Context context, @NonNull String sharedPrefFileName) {
        super(SharedPreferencesFileManager.getSharedPreferences(context, sharedPrefFileName, null));
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (sharedPrefFileName == null) {
            throw new NullPointerException("sharedPrefFileName is marked non-null but is null");
        }
    }

    public String get(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.mManager.getString(name);
    }

    public Iterator<Map.Entry<String, String>> getAllFilteredByKey(Predicate<String> keyPredicate) {
        return this.mManager.getAllFilteredByKey(keyPredicate);
    }

    @NonNull
    public Map<String, String> getAll() {
        return this.mManager.getAll();
    }

    public void put(@NonNull String name, @Nullable String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.mManager.putString(name, value);
    }
}

