/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.UserManager;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.logging.Logger;

public final class AccountManagerUtil {
    private static final String TAG = AccountManagerUtil.class.getSimpleName();
    private static final String MANIFEST_PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";

    private AccountManagerUtil() {
    }

    public static boolean canUseAccountManagerOperation(Context context) {
        String methodTag = TAG + ":canUseAccountManagerOperation:";
        if (Build.VERSION.SDK_INT >= 21) {
            String[] accountTypesWithManagementDisabled;
            UserManager userManager = (UserManager)context.getSystemService("user");
            if (userManager.hasUserRestriction("no_modify_accounts")) {
                Logger.verbose(methodTag, "UserManager.DISALLOW_MODIFY_ACCOUNTS is enabled for this user.");
                return false;
            }
            DevicePolicyManager devicePolicyManager = (DevicePolicyManager)context.getSystemService("device_policy");
            if (devicePolicyManager != null && (accountTypesWithManagementDisabled = devicePolicyManager.getAccountTypesWithManagementDisabled()) != null) {
                for (String accountType : accountTypesWithManagementDisabled) {
                    if (!"com.microsoft.workaccount".equalsIgnoreCase(accountType)) continue;
                    Logger.verbose(methodTag, "Broker account type is disabled by MDM.");
                    return false;
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                return true;
            }
            return AccountManagerUtil.isPermissionGranted(context, MANIFEST_PERMISSION_MANAGE_ACCOUNTS);
        }
        Logger.verbose(methodTag, "Cannot verify. Skipping AccountManager operation.");
        return false;
    }

    public static boolean isPermissionGranted(@NonNull Context context, @NonNull String permissionName) {
        String methodTag = TAG + ":isPermissionGranted";
        PackageManager pm = context.getPackageManager();
        boolean isGranted = pm.checkPermission(permissionName, context.getPackageName()) == 0;
        Logger.verbose(methodTag, "is " + permissionName + " granted? [" + isGranted + "]");
        return isGranted;
    }
}

