/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKeyPivProviderManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKitSmartcardSession;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.android.transport.nfc.NfcConfiguration;
import com.yubico.yubikit.android.transport.nfc.NfcNotAvailable;
import com.yubico.yubikit.android.transport.nfc.NfcSmartCardConnection;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyDevice;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyManager;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.PivSession;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class YubiKitNfcSmartcardCertBasedAuthManager
extends AbstractNfcSmartcardCertBasedAuthManager {
    private static final String TAG = YubiKitNfcSmartcardCertBasedAuthManager.class.getSimpleName();
    private static final String DEVICE_ERROR_MESSAGE = "No NFC device is currently connected.";
    private static final int NFC_TIMEOUT = 5000;
    private final NfcYubiKeyManager mNfcYubiKitManager;
    private NfcYubiKeyDevice mNfcDevice;
    private byte[] mTagId;
    private static final Object sDeviceLock = new Object();

    public YubiKitNfcSmartcardCertBasedAuthManager(@NonNull Context context) throws NfcNotAvailable {
        this.mNfcYubiKitManager = new NfcYubiKeyManager(context.getApplicationContext(), null);
        this.isDeviceChanged = false;
    }

    @Override
    boolean startDiscovery(@NonNull Activity activity) {
        try {
            this.mNfcYubiKitManager.enable(activity, new NfcConfiguration().timeout(5000), (Callback)new Callback<NfcYubiKeyDevice>(){

                public void invoke(@NonNull NfcYubiKeyDevice value) {
                    YubiKitNfcSmartcardCertBasedAuthManager.this.mNfcDevice = value;
                    byte[] tagId = YubiKitNfcSmartcardCertBasedAuthManager.this.mNfcDevice.getTag().getId();
                    YubiKitNfcSmartcardCertBasedAuthManager.this.isDeviceChanged = YubiKitNfcSmartcardCertBasedAuthManager.this.mTagId != null && !Arrays.equals(YubiKitNfcSmartcardCertBasedAuthManager.this.mTagId, tagId);
                    YubiKitNfcSmartcardCertBasedAuthManager.access$102(YubiKitNfcSmartcardCertBasedAuthManager.this, tagId);
                    if (YubiKitNfcSmartcardCertBasedAuthManager.this.mConnectionCallback != null) {
                        YubiKitNfcSmartcardCertBasedAuthManager.this.mConnectionCallback.onCreateConnection();
                    }
                }
            });
            return false;
        }
        catch (NfcNotAvailable e) {
            Logger.info(TAG, "Device has NFC functionality turned off.");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopDiscovery(final @NonNull Activity activity) {
        Object object = sDeviceLock;
        synchronized (object) {
            if (this.isDeviceConnected()) {
                this.mNfcDevice.remove(new Runnable(){

                    @Override
                    public void run() {
                        YubiKitNfcSmartcardCertBasedAuthManager.this.mNfcDevice = null;
                        YubiKitNfcSmartcardCertBasedAuthManager.this.mNfcYubiKitManager.disable(activity);
                    }
                });
                return;
            }
        }
        this.mNfcYubiKitManager.disable(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void requestDeviceSession(final @NonNull AbstractSmartcardCertBasedAuthManager.ISessionCallback callback) {
        String methodTag = TAG + "requestDeviceSession:";
        Object object = sDeviceLock;
        synchronized (object) {
            if (this.isDeviceConnected()) {
                this.mNfcDevice.requestConnection(NfcSmartCardConnection.class, (Callback)new Callback<Result<NfcSmartCardConnection, IOException>>(){

                    public void invoke(@NonNull Result<NfcSmartCardConnection, IOException> value) {
                        try {
                            SmartCardConnection c = (SmartCardConnection)value.getValue();
                            PivSession piv = new PivSession(c);
                            YubiKitSmartcardSession session = new YubiKitSmartcardSession(piv);
                            callback.onGetSession(session);
                        }
                        catch (Exception e) {
                            callback.onException(e);
                        }
                    }
                });
                return;
            }
            Logger.error(methodTag, DEVICE_ERROR_MESSAGE, null);
            callback.onException(new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isDeviceConnected() {
        Object object = sDeviceLock;
        synchronized (object) {
            return this.mNfcDevice != null;
        }
    }

    @Override
    void initBeforeProceedingWithRequest(@NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        YubiKeyPivProviderManager.addPivProvider(telemetryHelper, this.getPivProviderCallback());
    }

    @Override
    void onDestroy(@NonNull Activity activity) {
        YubiKeyPivProviderManager.removePivProvider();
    }

    @NonNull
    Callback<Callback<Result<PivSession, Exception>>> getPivProviderCallback() {
        final String methodTag = TAG + "getPivProviderCallback:";
        return new Callback<Callback<Result<PivSession, Exception>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @RequiresApi(api=21)
            public void invoke(final @NonNull Callback<Result<PivSession, Exception>> callback) {
                Object object = sDeviceLock;
                synchronized (object) {
                    if (YubiKitNfcSmartcardCertBasedAuthManager.this.isDeviceConnected()) {
                        YubiKitNfcSmartcardCertBasedAuthManager.this.mNfcDevice.requestConnection(NfcSmartCardConnection.class, (Callback)new Callback<Result<NfcSmartCardConnection, IOException>>(){

                            public void invoke(final @NonNull Result<NfcSmartCardConnection, IOException> value) {
                                callback.invoke((Object)Result.of((Callable)new Callable<PivSession>(){

                                    @Override
                                    public PivSession call() throws Exception {
                                        return new PivSession((SmartCardConnection)value.getValue());
                                    }
                                }));
                            }
                        });
                        return;
                    }
                    Logger.error(methodTag, YubiKitNfcSmartcardCertBasedAuthManager.DEVICE_ERROR_MESSAGE, null);
                    callback.invoke((Object)Result.failure((Throwable)new Exception(YubiKitNfcSmartcardCertBasedAuthManager.DEVICE_ERROR_MESSAGE)));
                }
            }
        };
    }

    static /* synthetic */ byte[] access$102(YubiKitNfcSmartcardCertBasedAuthManager x0, byte[] x1) {
        x0.mTagId = x1;
        return x1;
    }
}

